package org.pdb.beans;

/**
 *  Data items in the ENTITY_NAME_COM category record the common name
 *  or names associated with the entity. In some cases, the entity
 *  name may not be the same as the name of the biological structure.
 *  For example, haemoglobin alpha chain would be the entity common
 *  name, not haemoglobin.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:entity_name_comCategory>
 *  <PDBx:entity_name_com entity_id="1" name="HIV-1 protease monomer"></PDBx:entity_name_com>
 *  <PDBx:entity_name_com entity_id="1" name="HIV-1 PR monomer"></PDBx:entity_name_com>
 *  <PDBx:entity_name_com entity_id="2" name="acetyl-pepstatin"></PDBx:entity_name_com>
 *  <PDBx:entity_name_com entity_id="2" name="acetyl-Ile-Val-Asp-Statine-Ala-Ile-Statine"></PDBx:entity_name_com>
 *  <PDBx:entity_name_com entity_id="3" name="water"></PDBx:entity_name_com>
 *  </PDBx:entity_name_comCategory>
 * </pre>
 */
public class Entity_name_com 
{
		protected java.lang.String entity_id;


	/**
	 *  This data item is a pointer to  attribute id in category entity in the ENTITY category.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String name;


	/**
	 *  A common name for the entity.
	 *  HIV protease monomer
	 *  hemoglobin alpha chain
	 *  2-fluoro-1,4-dichloro benzene
	 *  arbutin
	 */
	public java.lang.String getName() 
	{
		return name;
	}
 
	public void setName(java.lang.String name)
	{
		this.name = name;
	}

 }
