package org.pdb.beans;

/**
 *  Data items in the ENTITY_POLY category record details about the
 *  polymer, such as the type of the polymer, the number of
 *  monomers and whether it has nonstandard features.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:entity_polyCategory>
 *  <PDBx:entity_poly entity_id="1">
 *  <PDBx:type>polypeptide(L)</PDBx:type>
 *  <PDBx:nstd_chirality>no</PDBx:nstd_chirality>
 *  <PDBx:nstd_linkage>no</PDBx:nstd_linkage>
 *  <PDBx:nstd_monomer>no</PDBx:nstd_monomer>
 *  </PDBx:entity_poly>
 *  </PDBx:entity_polyCategory>
 * </pre>
 */
public class Entity_poly 
{
		protected java.lang.String entity_id;


	/**
	 *  This data item is a pointer to  attribute id in category entity in the ENTITY category.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String nstd_chirality;


	/**
	 *  A flag to indicate whether the polymer contains at least
	 *  one monomer unit with chirality different from that specified in
	 *  attribute type in category entity_poly.
	 */
	public java.lang.String getNstd_chirality() 
	{
		return nstd_chirality;
	}
 
	public void setNstd_chirality(java.lang.String nstd_chirality)
	{
		this.nstd_chirality = nstd_chirality;
	}

 	protected java.lang.String nstd_linkage;


	/**
	 *  A flag to indicate whether the polymer contains at least
	 *  one monomer-to-monomer link different from that implied by
	 *  attribute type in category entity_poly.
	 */
	public java.lang.String getNstd_linkage() 
	{
		return nstd_linkage;
	}
 
	public void setNstd_linkage(java.lang.String nstd_linkage)
	{
		this.nstd_linkage = nstd_linkage;
	}

 	protected java.lang.String nstd_monomer;


	/**
	 *  A flag to indicate whether the polymer contains at least
	 *  one monomer that is not considered standard.
	 */
	public java.lang.String getNstd_monomer() 
	{
		return nstd_monomer;
	}
 
	public void setNstd_monomer(java.lang.String nstd_monomer)
	{
		this.nstd_monomer = nstd_monomer;
	}

 	protected java.lang.Integer number_of_monomers;


	/**
	 *  The number of monomers in the polymer.
	 */
	public java.lang.Integer getNumber_of_monomers() 
	{
		return number_of_monomers;
	}
 
	public void setNumber_of_monomers(java.lang.Integer number_of_monomers)
	{
		this.number_of_monomers = number_of_monomers;
	}

 	protected java.lang.String pdbx_seq_one_letter_code;


	/**
	 *  Chemical sequence expressed as string of one-letter
	 *  amino acid codes. Modifications and non-standard
	 *  amino acids are coded as X.
	 *  
	 *  A  for alanine or adenine
	 *  B  for ambiguous asparagine/aspartic-acid
	 *  R  for arginine
	 *  N  for asparagine
	 *  D  for aspartic-acid
	 *  C  for cysteine or cystine or cytosine
	 *  Q  for glutamine
	 *  E  for glutamic-acid
	 *  Z  for ambiguous glutamine/glutamic acid
	 *  G  for glycine or guanine
	 *  H  for histidine
	 *  I  for isoleucine
	 *  L  for leucine
	 *  K  for lysine
	 *  M  for methionine
	 *  F  for phenylalanine
	 *  P  for proline
	 *  S  for serine
	 *  T  for threonine or thymine
	 *  W  for tryptophan
	 *  Y  for tyrosine
	 *  V  for valine
	 *  U  for uracil
	 *  O  for water
	 *  X  for other
	 */
	public java.lang.String getPdbx_seq_one_letter_code() 
	{
		return pdbx_seq_one_letter_code;
	}
 
	public void setPdbx_seq_one_letter_code(java.lang.String pdbx_seq_one_letter_code)
	{
		this.pdbx_seq_one_letter_code = org.pdb.ormapping.util.Field.removeCrLf(pdbx_seq_one_letter_code);
	}

 	protected java.lang.String pdbx_seq_one_letter_code_can;


	/**
	 *  Cannonical chemical sequence expressed as string of
	 *  one-letter amino acid codes. Modifications are coded
	 *  as the parent amino acid where possible.
	 *  
	 *  A  for alanine or adenine
	 *  B  for ambiguous asparagine/aspartic-acid
	 *  R  for arginine
	 *  N  for asparagine
	 *  D  for aspartic-acid
	 *  C  for cysteine or cystine or cytosine
	 *  Q  for glutamine
	 *  E  for glutamic-acid
	 *  Z  for ambiguous glutamine/glutamic acid
	 *  G  for glycine or guanine
	 *  H  for histidine
	 *  I  for isoleucine
	 *  L  for leucine
	 *  K  for lysine
	 *  M  for methionine
	 *  F  for phenylalanine
	 *  P  for proline
	 *  S  for serine
	 *  T  for threonine or thymine
	 *  W  for tryptophan
	 *  Y  for tyrosine
	 *  V  for valine
	 *  U  for uracil
	 *  
	 *  MSHHWGYGKHNGPEHWHKDFPIAKGERQSPVDIDTHTAKYDPSLKPLSVSYDQATSLRILNNGAAFNVEFD
	 */
	public java.lang.String getPdbx_seq_one_letter_code_can() 
	{
		return pdbx_seq_one_letter_code_can;
	}
 
	public void setPdbx_seq_one_letter_code_can(java.lang.String pdbx_seq_one_letter_code_can)
	{
		this.pdbx_seq_one_letter_code_can = org.pdb.ormapping.util.Field.removeCrLf(pdbx_seq_one_letter_code_can);
	}

 	protected java.lang.String pdbx_strand_id;


	/**
	 *  The PDB strand/chain id(s) corresponding to this polymer entity.
	 *  A
	 *  B
	 *  A,B,C
	 */
	public java.lang.String getPdbx_strand_id() 
	{
		return pdbx_strand_id;
	}
 
	public void setPdbx_strand_id(java.lang.String pdbx_strand_id)
	{
		this.pdbx_strand_id = pdbx_strand_id;
	}

 	protected java.lang.String pdbx_target_identifier;


	/**
	 *  The sequence's target identifier registered at target database.
	 *  356560
	 */
	public java.lang.String getPdbx_target_identifier() 
	{
		return pdbx_target_identifier;
	}
 
	public void setPdbx_target_identifier(java.lang.String pdbx_target_identifier)
	{
		this.pdbx_target_identifier = pdbx_target_identifier;
	}

 	protected java.lang.String type;


	/**
	 *  The type of the polymer.
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 	protected java.lang.String type_details;


	/**
	 *  A description of special aspects of the polymer type.
	 *  monomer Ala 16 is a D-amino acid
	 *  the oligomer contains alternating RNA and DNA units
	 */
	public java.lang.String getType_details() 
	{
		return type_details;
	}
 
	public void setType_details(java.lang.String type_details)
	{
		this.type_details = type_details;
	}

 }
