package org.pdb.beans;

/**
 *  Data items in the ENTITY_POLY_SEQ category specify the sequence
 *  of monomers in a polymer. Allowance is made for the possibility
 *  of microheterogeneity in a sample by allowing a given sequence
 *  number to be correlated with more than one monomer ID. The
 *  corresponding ATOM_SITE entries should reflect this
 *  heterogeneity.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:entity_poly_seqCategory>
 *  <PDBx:entity_poly_seq entity_id="1" num="1" mon_id="PRO"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="2" mon_id="GLN"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="3" mon_id="ILE"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="4" mon_id="THR"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="5" mon_id="LEU"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="6" mon_id="TRP"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="7" mon_id="GLN"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="8" mon_id="ARG"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="9" mon_id="PRO"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="10" mon_id="LEU"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="11" mon_id="VAL"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="12" mon_id="THR"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="13" mon_id="ILE"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="14" mon_id="LYS"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="15" mon_id="ILE"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="16" mon_id="GLY"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="17" mon_id="GLY"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="18" mon_id="GLN"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="19" mon_id="LEU"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="20" mon_id="LYS"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="21" mon_id="GLU"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="22" mon_id="ALA"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="23" mon_id="LEU"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="24" mon_id="LEU"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="25" mon_id="ASP"></PDBx:entity_poly_seq>
 *  </PDBx:entity_poly_seqCategory>
 * </pre>
 */
public class Entity_poly_seq 
{
		protected java.lang.String entity_id;


	/**
	 *  This data item is a pointer to  attribute id in category entity in the ENTITY category.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String hetero;


	/**
	 *  A flag to indicate whether this monomer in the polymer is
	 *  heterogeneous in sequence. This would be rare.
	 */
	public java.lang.String getHetero() 
	{
		return hetero;
	}
 
	public void setHetero(java.lang.String hetero)
	{
		this.hetero = hetero;
	}

 	protected java.lang.String mon_id;


	/**
	 *  This data item is a pointer to  attribute id in category chem_comp in the CHEM_COMP
	 *  category.
	 */
	public java.lang.String getMon_id() 
	{
		return mon_id;
	}
 
	public void setMon_id(java.lang.String mon_id)
	{
		this.mon_id = mon_id;
	}

 	protected java.lang.Integer num;


	/**
	 *  The value of  attribute num in category entity_poly_seq must uniquely and sequentially
	 *  identify a record in the ENTITY_POLY_SEQ list.
	 *  
	 *  Note that this item must be a number and that the sequence
	 *  numbers must progress in increasing numerical order.
	 */
	public java.lang.Integer getNum() 
	{
		return num;
	}
 
	public void setNum(java.lang.Integer num)
	{
		this.num = num;
	}

 }
