package org.pdb.beans;

/**
 *  There is only one item in the ENTRY category,  attribute id in category entry.  This
 *  data item gives a name to this entry and is indirectly a key to
 *  the categories (such as CELL, GEOM, EXPTL) that describe
 *  information pertinent to the entire data block.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:entryCategory>
 *  <PDBx:entry id="5HVP"></PDBx:entry>
 *  </PDBx:entryCategory>
 *  
 *  
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:entryCategory>
 *  <PDBx:entry id="TOZ"></PDBx:entry>
 *  </PDBx:entryCategory>
 * </pre>
 */
public class Entry 
{
		protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category entry identifies the data block.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String pdbx_DOI;


	/**
	 *  Document Object Identifier (DOI) for this entry registered
	 *  with http://crossref.org.
	 */
	public java.lang.String getPdbx_DOI() 
	{
		return pdbx_DOI;
	}
 
	public void setPdbx_DOI(java.lang.String pdbx_DOI)
	{
		this.pdbx_DOI = pdbx_DOI;
	}

 }
