package org.pdb.beans;

/**
 *  Data items in the ENTRY_LINK category record the
 *  relationships between the current data block
 *  identified by  attribute id in category entry and other data blocks
 *  within the current file which may be referenced
 *  in the current data block.
 *  
 * <pre>
 *  Example 1 - example file for the one-dimensional incommensurately
 *  modulated structure of K~2~SeO~4~.
 *  <PDBx:entry_linkCategory>
 *  <PDBx:entry_link id="KSE_COM" entry_id="KSE_TEXT">
 *  <PDBx:details>experimental data common to ref./mod. structures</PDBx:details>
 *  </PDBx:entry_link>
 *  <PDBx:entry_link id="KSE_REF" entry_id="KSE_TEXT">
 *  <PDBx:details>reference structure</PDBx:details>
 *  </PDBx:entry_link>
 *  <PDBx:entry_link id="KSE_MOD" entry_id="KSE_TEXT">
 *  <PDBx:details>modulated structure</PDBx:details>
 *  </PDBx:entry_link>
 *  </PDBx:entry_linkCategory>
 * </pre>
 */
public class Entry_link 
{
		protected java.lang.String details;


	/**
	 *  A description of the relationship between the data blocks
	 *  identified by _entry_link.id and _entry_link.entry_id.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category entry_link identifies a data block
	 *  related to the current data block.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 }
