package org.pdb.beans;

/**
 *  Data items in the EXPTL_CRYSTAL category record the results of
 *  experimental measurements on the crystal or crystals used,
 *  such as shape, size or density.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for Yb(S-C5H4N)2(THF)4.
 *  <PDBx:exptl_crystalCategory>
 *  <PDBx:exptl_crystal id="xst2l">
 *  <PDBx:colour>pale yellow</PDBx:colour>
 *  <PDBx:density_diffrn>1.113</PDBx:density_diffrn>
 *  <PDBx:density_Matthews>1.01</PDBx:density_Matthews>
 *  <PDBx:density_meas>1.11</PDBx:density_meas>
 *  <PDBx:density_meas_temp>294.5</PDBx:density_meas_temp>
 *  <PDBx:density_method>neutral buoyancy</PDBx:density_method>
 *  <PDBx:density_percent_sol>0.15</PDBx:density_percent_sol>
 *  <PDBx:description>hexagonal rod, uncut</PDBx:description>
 *  <PDBx:F_000>202</PDBx:F_000>
 *  <PDBx:preparation> hanging drop, crystal soaked in 10&#37; ethylene glycol for
 *  10 h, then placed in nylon loop at data collection time</PDBx:preparation>
 *  <PDBx:size_max>0.30</PDBx:size_max>
 *  <PDBx:size_mid>0.20</PDBx:size_mid>
 *  <PDBx:size_min>0.05</PDBx:size_min>
 *  <PDBx:size_rad>0.025</PDBx:size_rad>
 *  </PDBx:exptl_crystal>
 *  </PDBx:exptl_crystalCategory>
 *  
 *  
 *  Example 2 - using separate items to define upper and lower
 *  limits for a value.
 *  <PDBx:exptl_crystalCategory>
 *  <PDBx:exptl_crystal>
 *  <PDBx:density_meas_gt>2.5</PDBx:density_meas_gt>
 *  <PDBx:density_meas_lt>5.0</PDBx:density_meas_lt>
 *  </PDBx:exptl_crystal>
 *  </PDBx:exptl_crystalCategory>
 *  
 *  
 *  Example 3 - here the density was measured at some
 *  unspecified temperature below room temperature.
 *  <PDBx:exptl_crystalCategory>
 *  <PDBx:exptl_crystal>
 *  <PDBx:density_meas_temp_lt>300.</PDBx:density_meas_temp_lt>
 *  </PDBx:exptl_crystal>
 *  </PDBx:exptl_crystalCategory>
 * </pre>
 */
public class Exptl_crystal 
{
		protected java.lang.Integer F_000;


	/**
	 *  The effective number of electrons in the crystal unit cell
	 *  contributing to F(000). This may contain dispersion contributions
	 *  and is calculated as
	 *  
	 *  F(000) = [ sum (f~r~^2^ + f~i~^2^) ]^1/2^
	 *  
	 *  f~r~ = real part of the scattering factors at theta = 0 degree
	 *  f~i~ = imaginary part of the scattering factors at
	 *  theta = 0 degree
	 *  
	 *  the sum is taken over each atom in the unit cell
	 */
	public java.lang.Integer getF_000() 
	{
		return F_000;
	}
 
	public void setF_000(java.lang.Integer F_000)
	{
		this.F_000 = F_000;
	}

 	protected java.lang.String colour;


	/**
	 *  The colour of the crystal.
	 *  dark green
	 */
	public java.lang.String getColour() 
	{
		return colour;
	}
 
	public void setColour(java.lang.String colour)
	{
		this.colour = colour;
	}

 	protected java.lang.String colour_lustre;


	/**
	 *  The enumeration list of standardized names developed for the
	 *  International Centre for Diffraction Data.
	 *  The colour of a crystal is given by the combination of
	 *  attribute colour_modifier in category exptl_crystal with
	 *  attribute colour_primary in category exptl_crystal as in 'dark-green' or
	 *  'bluish-violet', if necessary combined with
	 *  attribute colour_lustre in category exptl_crystal as in 'metallic-green'.
	 */
	public java.lang.String getColour_lustre() 
	{
		return colour_lustre;
	}
 
	public void setColour_lustre(java.lang.String colour_lustre)
	{
		this.colour_lustre = colour_lustre;
	}

 	protected java.lang.String colour_modifier;


	/**
	 *  The enumeration list of standardized names developed for the
	 *  International Centre for Diffraction Data.
	 *  The colour of a crystal is given by the combination of
	 *  attribute colour_modifier in category exptl_crystal with
	 *  attribute colour_primary in category exptl_crystal as in 'dark-green' or
	 *  'bluish-violet', if necessary combined with
	 *  attribute colour_lustre in category exptl_crystal as in 'metallic-green'.
	 */
	public java.lang.String getColour_modifier() 
	{
		return colour_modifier;
	}
 
	public void setColour_modifier(java.lang.String colour_modifier)
	{
		this.colour_modifier = colour_modifier;
	}

 	protected java.lang.String colour_primary;


	/**
	 *  The enumeration list of standardized names developed for the
	 *  International Centre for Diffraction Data.
	 *  The colour of a crystal is given by the combination of
	 *  attribute colour_modifier in category exptl_crystal with
	 *  attribute colour_primary in category exptl_crystal as in 'dark-green' or
	 *  'bluish-violet', if necessary combined with
	 *  attribute colour_lustre in category exptl_crystal as in 'metallic-green'.
	 */
	public java.lang.String getColour_primary() 
	{
		return colour_primary;
	}
 
	public void setColour_primary(java.lang.String colour_primary)
	{
		this.colour_primary = colour_primary;
	}

 	protected java.lang.Float density_Matthews;


	/**
	 *  The density of the crystal, expressed as the ratio of the
	 *  volume of the asymmetric unit to the molecular mass of a
	 *  monomer of the structure, in units of angstroms^3^ per dalton.
	 *  
	 *  Ref: Matthews, B. W. (1968). J. Mol. Biol. 33, 491-497.
	 */
	public java.lang.Float getDensity_Matthews() 
	{
		return density_Matthews;
	}
 
	public void setDensity_Matthews(java.lang.Float density_Matthews)
	{
		this.density_Matthews = density_Matthews;
	}

 	protected java.lang.Float density_diffrn;


	/**
	 *  Density values calculated from the crystal cell and contents. The
	 *  units are megagrams per cubic metre (grams per cubic centimetre).
	 */
	public java.lang.Float getDensity_diffrn() 
	{
		return density_diffrn;
	}
 
	public void setDensity_diffrn(java.lang.Float density_diffrn)
	{
		this.density_diffrn = density_diffrn;
	}

 	protected java.lang.Float density_meas;


	/**
	 *  Density values measured using standard chemical and physical
	 *  methods. The units are megagrams per cubic metre (grams per
	 *  cubic centimetre).
	 */
	public java.lang.Float getDensity_meas() 
	{
		return density_meas;
	}
 
	public void setDensity_meas(java.lang.Float density_meas)
	{
		this.density_meas = density_meas;
	}

 	protected java.lang.Float density_meas_esd;


	/**
	 *  The estimated standard deviation of  attribute density_meas in category exptl_crystal.
	 */
	public java.lang.Float getDensity_meas_esd() 
	{
		return density_meas_esd;
	}
 
	public void setDensity_meas_esd(java.lang.Float density_meas_esd)
	{
		this.density_meas_esd = density_meas_esd;
	}

 	protected java.lang.Float density_meas_gt;


	/**
	 *  The value above which the density measured using standard
	 *  chemical and physical methods lies. The units are megagrams
	 *  per cubic metre (grams per cubic centimetre).
	 *  _exptl_crystal.density_meas_gt and _exptl_crystal.density_meas_lt
	 *  should not be used to report new experimental work, for which
	 *  attribute density_meas in category exptl_crystal should be used. These items are
	 *  intended for use in reporting information in existing databases
	 *  and archives which would be misleading if reported under
	 *  attribute density_meas in category exptl_crystal.
	 *  lower limit for the density (only the range
	 *  within which the density lies was given in the
	 *  original paper)
	 *  2.5
	 */
	public java.lang.Float getDensity_meas_gt() 
	{
		return density_meas_gt;
	}
 
	public void setDensity_meas_gt(java.lang.Float density_meas_gt)
	{
		this.density_meas_gt = density_meas_gt;
	}

 	protected java.lang.Float density_meas_lt;


	/**
	 *  The value below which the density measured using standard
	 *  chemical and physical methods lies. The units are megagrams
	 *  per cubic metre (grams per cubic centimetre).
	 *  _exptl_crystal.density_meas_gt and _exptl_crystal.density_meas_lt
	 *  should not be used to report new experimental work, for which
	 *  attribute density_meas in category exptl_crystal should be used. These items are
	 *  intended for use in reporting information in existing databases
	 *  and archives which would be misleading if reported under
	 *  attribute density_meas in category exptl_crystal.
	 *  specimen floats in water
	 *  1.0
	 *  upper limit for the density (only the range
	 *  within which the density lies was given in the
	 *  original paper)
	 *  5.0
	 */
	public java.lang.Float getDensity_meas_lt() 
	{
		return density_meas_lt;
	}
 
	public void setDensity_meas_lt(java.lang.Float density_meas_lt)
	{
		this.density_meas_lt = density_meas_lt;
	}

 	protected java.lang.Float density_meas_temp;


	/**
	 *  Temperature in kelvins at which  attribute density_meas
	 *  in category exptl_crystal was determined.
	 */
	public java.lang.Float getDensity_meas_temp() 
	{
		return density_meas_temp;
	}
 
	public void setDensity_meas_temp(java.lang.Float density_meas_temp)
	{
		this.density_meas_temp = density_meas_temp;
	}

 	protected java.lang.Float density_meas_temp_esd;


	/**
	 *  The estimated standard deviation of
	 *  attribute density_meas_temp in category exptl_crystal.
	 */
	public java.lang.Float getDensity_meas_temp_esd() 
	{
		return density_meas_temp_esd;
	}
 
	public void setDensity_meas_temp_esd(java.lang.Float density_meas_temp_esd)
	{
		this.density_meas_temp_esd = density_meas_temp_esd;
	}

 	protected java.lang.Float density_meas_temp_gt;


	/**
	 *  Temperature in kelvins above which  attribute density_meas
	 *  in category exptl_crystal was determined.  attribute density_meas_temp_gt in category exptl_crystal and
	 *  attribute density_meas_temp_lt in category exptl_crystal should not be used for
	 *  reporting new work,  for which the correct temperature of
	 *  measurement should be given. These items are intended for
	 *  use in reporting information stored in databases or archives
	 *  which would be misleading if reported under
	 *  attribute density_meas_temp in category exptl_crystal.
	 */
	public java.lang.Float getDensity_meas_temp_gt() 
	{
		return density_meas_temp_gt;
	}
 
	public void setDensity_meas_temp_gt(java.lang.Float density_meas_temp_gt)
	{
		this.density_meas_temp_gt = density_meas_temp_gt;
	}

 	protected java.lang.Float density_meas_temp_lt;


	/**
	 *  Temperature in kelvins below which  attribute density_meas
	 *  in category exptl_crystal was determined.  attribute density_meas_temp_gt in category exptl_crystal and
	 *  attribute density_meas_temp_lt in category exptl_crystal should not be used for
	 *  reporting new work,  for which the correct temperature of
	 *  measurement should be given. These items are intended for
	 *  use in reporting information stored in databases or archives
	 *  which would be misleading if reported under
	 *  attribute density_meas_temp in category exptl_crystal.
	 *  The density was measured at some unspecified
	 *  temperature below room temperature.
	 *  300
	 */
	public java.lang.Float getDensity_meas_temp_lt() 
	{
		return density_meas_temp_lt;
	}
 
	public void setDensity_meas_temp_lt(java.lang.Float density_meas_temp_lt)
	{
		this.density_meas_temp_lt = density_meas_temp_lt;
	}

 	protected java.lang.String density_method;


	/**
	 *  The method used to measure  attribute density_meas in category exptl_crystal.
	 */
	public java.lang.String getDensity_method() 
	{
		return density_method;
	}
 
	public void setDensity_method(java.lang.String density_method)
	{
		this.density_method = density_method;
	}

 	protected java.lang.Float density_percent_sol;


	/**
	 *  Density value P calculated from the crystal cell and contents,
	 *  expressed as per cent solvent.
	 *  
	 *  P = 1 - (1.23 N MMass) / V
	 *  
	 *  N     = the number of molecules in the unit cell
	 *  MMass = the molecular mass of each molecule (gm/mole)
	 *  V     = the volume of the unit cell (A^3^)
	 *  1.23  = a conversion factor evaluated as:
	 *  
	 *  (0.74 cm^3^/g) (10^24^ A^3^/cm^3^)
	 *  --------------------------------------
	 *  (6.02*10^23^) molecules/mole
	 *  
	 *  where 0.74 is an assumed value for the partial specific
	 *  volume of the molecule
	 */
	public java.lang.Float getDensity_percent_sol() 
	{
		return density_percent_sol;
	}
 
	public void setDensity_percent_sol(java.lang.Float density_percent_sol)
	{
		this.density_percent_sol = density_percent_sol;
	}

 	protected java.lang.String description;


	/**
	 *  A description of the quality and habit of the crystal.
	 *  The crystal dimensions should not normally be reported here;
	 *  use instead the specific items in the EXPTL_CRYSTAL category
	 *  relating to size for the gross dimensions of the crystal and
	 *  data items in the EXPTL_CRYSTAL_FACE category to describe the
	 *  relationship between individual faces.
	 */
	public java.lang.String getDescription() 
	{
		return description;
	}
 
	public void setDescription(java.lang.String description)
	{
		this.description = description;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category exptl_crystal must uniquely identify a record in
	 *  the EXPTL_CRYSTAL list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String pdbx_crystal_image_format;


	/**
	 *  The image format for the file containing the image of crystal specified
	 *  as an RFC2045/RFC2046 mime type.
	 *  jpeg
	 *  gif
	 *  tiff
	 */
	public java.lang.String getPdbx_crystal_image_format() 
	{
		return pdbx_crystal_image_format;
	}
 
	public void setPdbx_crystal_image_format(java.lang.String pdbx_crystal_image_format)
	{
		this.pdbx_crystal_image_format = pdbx_crystal_image_format;
	}

 	protected java.lang.String pdbx_crystal_image_url;


	/**
	 *  The URL for an a file containing the image of crystal.
	 */
	public java.lang.String getPdbx_crystal_image_url() 
	{
		return pdbx_crystal_image_url;
	}
 
	public void setPdbx_crystal_image_url(java.lang.String pdbx_crystal_image_url)
	{
		this.pdbx_crystal_image_url = pdbx_crystal_image_url;
	}

 	protected java.lang.String preparation;


	/**
	 *  Details of crystal growth and preparation of the crystal (e.g.
	 *  mounting) prior to the intensity measurements.
	 *  mounted in an argon-filled quartz capillary
	 */
	public java.lang.String getPreparation() 
	{
		return preparation;
	}
 
	public void setPreparation(java.lang.String preparation)
	{
		this.preparation = preparation;
	}

 	protected java.lang.Float size_max;


	/**
	 *  The maximum dimension of the crystal. This item may appear in a
	 *  list with  attribute id in category exptl_crystal if multiple crystals are used in the
	 *  experiment.
	 */
	public java.lang.Float getSize_max() 
	{
		return size_max;
	}
 
	public void setSize_max(java.lang.Float size_max)
	{
		this.size_max = size_max;
	}

 	protected java.lang.Float size_mid;


	/**
	 *  The medial dimension of the crystal. This item may appear in a
	 *  list with  attribute id in category exptl_crystal if multiple crystals are used in the
	 *  experiment.
	 */
	public java.lang.Float getSize_mid() 
	{
		return size_mid;
	}
 
	public void setSize_mid(java.lang.Float size_mid)
	{
		this.size_mid = size_mid;
	}

 	protected java.lang.Float size_min;


	/**
	 *  The minimum dimension of the crystal. This item may appear in a
	 *  list with  attribute id in category exptl_crystal if multiple crystals are used in the
	 *  experiment.
	 */
	public java.lang.Float getSize_min() 
	{
		return size_min;
	}
 
	public void setSize_min(java.lang.Float size_min)
	{
		this.size_min = size_min;
	}

 	protected java.lang.Float size_rad;


	/**
	 *  The radius of the crystal, if the crystal is a sphere or a
	 *  cylinder. This item may appear in a list with  attribute id
	 *  in category exptl_crystal if multiple crystals are used in the experiment.
	 */
	public java.lang.Float getSize_rad() 
	{
		return size_rad;
	}
 
	public void setSize_rad(java.lang.Float size_rad)
	{
		this.size_rad = size_rad;
	}

 }
