package org.pdb.beans;

/**
 *  Data items in the EXPTL_CRYSTAL_FACE category record details
 *  of the crystal faces.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for Yb(S-C5H4N)2(THF)4
 *  for the 100 face of crystal xstl1.
 *  <PDBx:exptl_crystal_faceCategory>
 *  <PDBx:exptl_crystal_face crystal_id="xstl1" index_h="1" index_k="0" index_l="0">
 *  <PDBx:diffr_chi>42.56</PDBx:diffr_chi>
 *  <PDBx:diffr_kappa>30.23</PDBx:diffr_kappa>
 *  <PDBx:diffr_phi>-125.56</PDBx:diffr_phi>
 *  <PDBx:diffr_psi>-0.34</PDBx:diffr_psi>
 *  <PDBx:perp_dist>0.025</PDBx:perp_dist>
 *  </PDBx:exptl_crystal_face>
 *  </PDBx:exptl_crystal_faceCategory>
 * </pre>
 */
public class Exptl_crystal_face 
{
		protected java.lang.String crystal_id;


	/**
	 *  This data item is a pointer to  attribute id in category exptl_crystal in the
	 *  EXPTL_CRYSTAL category.
	 */
	public java.lang.String getCrystal_id() 
	{
		return crystal_id;
	}
 
	public void setCrystal_id(java.lang.String crystal_id)
	{
		this.crystal_id = crystal_id;
	}

 	protected java.lang.Float diffr_chi;


	/**
	 *  The chi diffractometer setting angle in degrees for a specific
	 *  crystal face associated with  attribute perp_dist in category exptl_crystal_face.
	 */
	public java.lang.Float getDiffr_chi() 
	{
		return diffr_chi;
	}
 
	public void setDiffr_chi(java.lang.Float diffr_chi)
	{
		this.diffr_chi = diffr_chi;
	}

 	protected java.lang.Float diffr_kappa;


	/**
	 *  The kappa diffractometer setting angle in degrees for a specific
	 *  crystal face associated with  attribute perp_dist in category exptl_crystal_face.
	 */
	public java.lang.Float getDiffr_kappa() 
	{
		return diffr_kappa;
	}
 
	public void setDiffr_kappa(java.lang.Float diffr_kappa)
	{
		this.diffr_kappa = diffr_kappa;
	}

 	protected java.lang.Float diffr_phi;


	/**
	 *  The phi diffractometer setting angle in degrees for a specific
	 *  crystal face associated with  attribute perp_dist in category exptl_crystal_face.
	 */
	public java.lang.Float getDiffr_phi() 
	{
		return diffr_phi;
	}
 
	public void setDiffr_phi(java.lang.Float diffr_phi)
	{
		this.diffr_phi = diffr_phi;
	}

 	protected java.lang.Float diffr_psi;


	/**
	 *  The psi diffractometer setting angle in degrees for a specific
	 *  crystal face associated with  attribute perp_dist in category exptl_crystal_face.
	 */
	public java.lang.Float getDiffr_psi() 
	{
		return diffr_psi;
	}
 
	public void setDiffr_psi(java.lang.Float diffr_psi)
	{
		this.diffr_psi = diffr_psi;
	}

 	protected java.lang.Integer index_h;


	/**
	 *  Miller index h of the crystal face associated with the value
	 *  attribute perp_dist in category exptl_crystal_face.
	 */
	public java.lang.Integer getIndex_h() 
	{
		return index_h;
	}
 
	public void setIndex_h(java.lang.Integer index_h)
	{
		this.index_h = index_h;
	}

 	protected java.lang.Integer index_k;


	/**
	 *  Miller index k of the crystal face associated with the value
	 *  attribute perp_dist in category exptl_crystal_face.
	 */
	public java.lang.Integer getIndex_k() 
	{
		return index_k;
	}
 
	public void setIndex_k(java.lang.Integer index_k)
	{
		this.index_k = index_k;
	}

 	protected java.lang.Integer index_l;


	/**
	 *  Miller index l of the crystal face associated with the value
	 *  attribute perp_dist in category exptl_crystal_face.
	 */
	public java.lang.Integer getIndex_l() 
	{
		return index_l;
	}
 
	public void setIndex_l(java.lang.Integer index_l)
	{
		this.index_l = index_l;
	}

 	protected java.lang.Float perp_dist;


	/**
	 *  The perpendicular distance in millimetres from the face to the
	 *  centre of rotation of the crystal.
	 */
	public java.lang.Float getPerp_dist() 
	{
		return perp_dist;
	}
 
	public void setPerp_dist(java.lang.Float perp_dist)
	{
		this.perp_dist = perp_dist;
	}

 }
