package org.pdb.beans;

/**
 *  Data items in the GEOM and related (GEOM_ANGLE,
 *  GEOM_BOND, GEOM_CONTACT, GEOM_HBOND and GEOM_TORSION)
 *  categories record details about the molecular
 *  geometry as calculated from the contents of the ATOM, CELL
 *  and SYMMETRY data.
 *  
 *  Geometry data are therefore redundant, in that they can be
 *  calculated from other more fundamental quantities in the data
 *  block. However, they provide a check on the correctness of
 *  both sets of data and enable the most important geometric data
 *  to be identified for publication by setting the appropriate
 *  publication flag.
 */
public class Geom 
{
		protected java.lang.String details;


	/**
	 *  A description of geometry not covered by the
	 *  existing data names in the GEOM categories, such as
	 *  least-squares planes.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 }
