package org.pdb.beans;

/**
 *  Data items in the GEOM_ANGLE category record details about the
 *  bond angles as calculated from the contents
 *  of the ATOM, CELL and SYMMETRY data.
 *  
 * <pre>
 *  Example 1 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:geom_angleCategory>
 *  <PDBx:geom_angle atom_site_id_1="C2" atom_site_id_2="O1" atom_site_id_3="C5" site_symmetry_1="1_555" site_symmetry_2="1_555" site_symmetry_3="1_555">
 *  <PDBx:value>111.6</PDBx:value>
 *  <PDBx:value_esd>0.2</PDBx:value_esd>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_angle>
 *  <PDBx:geom_angle atom_site_id_1="O1" atom_site_id_2="C2" atom_site_id_3="C3" site_symmetry_1="1_555" site_symmetry_2="1_555" site_symmetry_3="1_555">
 *  <PDBx:value>110.9</PDBx:value>
 *  <PDBx:value_esd>0.2</PDBx:value_esd>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_angle>
 *  <PDBx:geom_angle atom_site_id_1="O1" atom_site_id_2="C2" atom_site_id_3="O21" site_symmetry_1="1_555" site_symmetry_2="1_555" site_symmetry_3="1_555">
 *  <PDBx:value>122.2</PDBx:value>
 *  <PDBx:value_esd>0.3</PDBx:value_esd>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_angle>
 *  <PDBx:geom_angle atom_site_id_1="C3" atom_site_id_2="C2" atom_site_id_3="O21" site_symmetry_1="1_555" site_symmetry_2="1_555" site_symmetry_3="1_555">
 *  <PDBx:value>127.0</PDBx:value>
 *  <PDBx:value_esd>0.3</PDBx:value_esd>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_angle>
 *  <PDBx:geom_angle atom_site_id_1="C2" atom_site_id_2="C3" atom_site_id_3="N4" site_symmetry_1="1_555" site_symmetry_2="1_555" site_symmetry_3="1_555">
 *  <PDBx:value>101.3</PDBx:value>
 *  <PDBx:value_esd>0.2</PDBx:value_esd>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_angle>
 *  <PDBx:geom_angle atom_site_id_1="C2" atom_site_id_2="C3" atom_site_id_3="C31" site_symmetry_1="1_555" site_symmetry_2="1_555" site_symmetry_3="1_555">
 *  <PDBx:value>111.3</PDBx:value>
 *  <PDBx:value_esd>0.2</PDBx:value_esd>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_angle>
 *  <PDBx:geom_angle atom_site_id_1="C2" atom_site_id_2="C3" atom_site_id_3="H3" site_symmetry_1="1_555" site_symmetry_2="1_555" site_symmetry_3="1_555">
 *  <PDBx:value>107.</PDBx:value>
 *  <PDBx:value_esd>1.</PDBx:value_esd>
 *  <PDBx:publ_flag>no</PDBx:publ_flag>
 *  </PDBx:geom_angle>
 *  <PDBx:geom_angle atom_site_id_1="N4" atom_site_id_2="C3" atom_site_id_3="C31" site_symmetry_1="1_555" site_symmetry_2="1_555" site_symmetry_3="1_555">
 *  <PDBx:value>116.7</PDBx:value>
 *  <PDBx:value_esd>0.2</PDBx:value_esd>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_angle>
 *  </PDBx:geom_angleCategory>
 * </pre>
 */
public class Geom_angle 
{
		protected java.lang.String atom_site_auth_asym_id_1;


	/**
	 *  An optional identifier of the first of the three atom sites that
	 *  define the angle.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_asym_id_1() 
	{
		return atom_site_auth_asym_id_1;
	}
 
	public void setAtom_site_auth_asym_id_1(java.lang.String atom_site_auth_asym_id_1)
	{
		this.atom_site_auth_asym_id_1 = atom_site_auth_asym_id_1;
	}

 	protected java.lang.String atom_site_auth_asym_id_2;


	/**
	 *  An optional identifier of the second of the three atom sites
	 *  that define the angle.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_asym_id_2() 
	{
		return atom_site_auth_asym_id_2;
	}
 
	public void setAtom_site_auth_asym_id_2(java.lang.String atom_site_auth_asym_id_2)
	{
		this.atom_site_auth_asym_id_2 = atom_site_auth_asym_id_2;
	}

 	protected java.lang.String atom_site_auth_asym_id_3;


	/**
	 *  An optional identifier of the third of the three atom sites that
	 *  define the angle.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_asym_id_3() 
	{
		return atom_site_auth_asym_id_3;
	}
 
	public void setAtom_site_auth_asym_id_3(java.lang.String atom_site_auth_asym_id_3)
	{
		this.atom_site_auth_asym_id_3 = atom_site_auth_asym_id_3;
	}

 	protected java.lang.String atom_site_auth_atom_id_1;


	/**
	 *  An optional identifier of the first of the three atom sites that
	 *  define the angle.
	 *  
	 *  This data item is a pointer to  attribute auth_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_atom_id_1() 
	{
		return atom_site_auth_atom_id_1;
	}
 
	public void setAtom_site_auth_atom_id_1(java.lang.String atom_site_auth_atom_id_1)
	{
		this.atom_site_auth_atom_id_1 = atom_site_auth_atom_id_1;
	}

 	protected java.lang.String atom_site_auth_atom_id_2;


	/**
	 *  An optional identifier of the second of the three atom sites
	 *  that define the angle.
	 *  
	 *  This data item is a pointer to  attribute auth_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_atom_id_2() 
	{
		return atom_site_auth_atom_id_2;
	}
 
	public void setAtom_site_auth_atom_id_2(java.lang.String atom_site_auth_atom_id_2)
	{
		this.atom_site_auth_atom_id_2 = atom_site_auth_atom_id_2;
	}

 	protected java.lang.String atom_site_auth_atom_id_3;


	/**
	 *  An optional identifier of the third of the three atom sites that
	 *  define the angle.
	 *  
	 *  This data item is a pointer to  attribute auth_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_atom_id_3() 
	{
		return atom_site_auth_atom_id_3;
	}
 
	public void setAtom_site_auth_atom_id_3(java.lang.String atom_site_auth_atom_id_3)
	{
		this.atom_site_auth_atom_id_3 = atom_site_auth_atom_id_3;
	}

 	protected java.lang.String atom_site_auth_comp_id_1;


	/**
	 *  An optional identifier of the first of the three atom sites that
	 *  define the angle.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_comp_id_1() 
	{
		return atom_site_auth_comp_id_1;
	}
 
	public void setAtom_site_auth_comp_id_1(java.lang.String atom_site_auth_comp_id_1)
	{
		this.atom_site_auth_comp_id_1 = atom_site_auth_comp_id_1;
	}

 	protected java.lang.String atom_site_auth_comp_id_2;


	/**
	 *  An optional identifier of the second of the three atom sites
	 *  that define the angle.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_comp_id_2() 
	{
		return atom_site_auth_comp_id_2;
	}
 
	public void setAtom_site_auth_comp_id_2(java.lang.String atom_site_auth_comp_id_2)
	{
		this.atom_site_auth_comp_id_2 = atom_site_auth_comp_id_2;
	}

 	protected java.lang.String atom_site_auth_comp_id_3;


	/**
	 *  An optional identifier of the third of the three atom sites that
	 *  define the angle.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_comp_id_3() 
	{
		return atom_site_auth_comp_id_3;
	}
 
	public void setAtom_site_auth_comp_id_3(java.lang.String atom_site_auth_comp_id_3)
	{
		this.atom_site_auth_comp_id_3 = atom_site_auth_comp_id_3;
	}

 	protected java.lang.String atom_site_auth_seq_id_1;


	/**
	 *  An optional identifier of the first of the three atom sites that
	 *  define the angle.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_seq_id_1() 
	{
		return atom_site_auth_seq_id_1;
	}
 
	public void setAtom_site_auth_seq_id_1(java.lang.String atom_site_auth_seq_id_1)
	{
		this.atom_site_auth_seq_id_1 = atom_site_auth_seq_id_1;
	}

 	protected java.lang.String atom_site_auth_seq_id_2;


	/**
	 *  An optional identifier of the second of the three atom sites
	 *  that define the angle.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_seq_id_2() 
	{
		return atom_site_auth_seq_id_2;
	}
 
	public void setAtom_site_auth_seq_id_2(java.lang.String atom_site_auth_seq_id_2)
	{
		this.atom_site_auth_seq_id_2 = atom_site_auth_seq_id_2;
	}

 	protected java.lang.String atom_site_auth_seq_id_3;


	/**
	 *  An optional identifier of the third of the three atom sites that
	 *  define the angle.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_seq_id_3() 
	{
		return atom_site_auth_seq_id_3;
	}
 
	public void setAtom_site_auth_seq_id_3(java.lang.String atom_site_auth_seq_id_3)
	{
		this.atom_site_auth_seq_id_3 = atom_site_auth_seq_id_3;
	}

 	protected java.lang.String atom_site_id_1;


	/**
	 *  The identifier of the first of the three atom sites that define
	 *  the angle.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_site in the ATOM_SITE
	 *  category.
	 */
	public java.lang.String getAtom_site_id_1() 
	{
		return atom_site_id_1;
	}
 
	public void setAtom_site_id_1(java.lang.String atom_site_id_1)
	{
		this.atom_site_id_1 = atom_site_id_1;
	}

 	protected java.lang.String atom_site_id_2;


	/**
	 *  The identifier of the second of the three atom sites that define
	 *  the angle. The second atom is taken to be the apex of the angle.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_site in the ATOM_SITE
	 *  category.
	 */
	public java.lang.String getAtom_site_id_2() 
	{
		return atom_site_id_2;
	}
 
	public void setAtom_site_id_2(java.lang.String atom_site_id_2)
	{
		this.atom_site_id_2 = atom_site_id_2;
	}

 	protected java.lang.String atom_site_id_3;


	/**
	 *  The identifier of the third of the three atom sites that define
	 *  the angle.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_site in the ATOM_SITE
	 *  category.
	 */
	public java.lang.String getAtom_site_id_3() 
	{
		return atom_site_id_3;
	}
 
	public void setAtom_site_id_3(java.lang.String atom_site_id_3)
	{
		this.atom_site_id_3 = atom_site_id_3;
	}

 	protected java.lang.String atom_site_label_alt_id_1;


	/**
	 *  An optional identifier of the first of the three atom sites that
	 *  define the angle.
	 *  
	 *  This data item is a pointer to  attribute label_alt_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_alt_id_1() 
	{
		return atom_site_label_alt_id_1;
	}
 
	public void setAtom_site_label_alt_id_1(java.lang.String atom_site_label_alt_id_1)
	{
		this.atom_site_label_alt_id_1 = atom_site_label_alt_id_1;
	}

 	protected java.lang.String atom_site_label_alt_id_2;


	/**
	 *  An optional identifier of the second of the three atom sites
	 *  that define the angle.
	 *  
	 *  This data item is a pointer to  attribute label_alt_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_alt_id_2() 
	{
		return atom_site_label_alt_id_2;
	}
 
	public void setAtom_site_label_alt_id_2(java.lang.String atom_site_label_alt_id_2)
	{
		this.atom_site_label_alt_id_2 = atom_site_label_alt_id_2;
	}

 	protected java.lang.String atom_site_label_alt_id_3;


	/**
	 *  An optional identifier of the third of the three atom sites that
	 *  define the angle.
	 *  
	 *  This data item is a pointer to  attribute label_alt_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_alt_id_3() 
	{
		return atom_site_label_alt_id_3;
	}
 
	public void setAtom_site_label_alt_id_3(java.lang.String atom_site_label_alt_id_3)
	{
		this.atom_site_label_alt_id_3 = atom_site_label_alt_id_3;
	}

 	protected java.lang.String atom_site_label_asym_id_1;


	/**
	 *  An optional identifier of the first of the three atom sites that
	 *  define the angle.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_asym_id_1() 
	{
		return atom_site_label_asym_id_1;
	}
 
	public void setAtom_site_label_asym_id_1(java.lang.String atom_site_label_asym_id_1)
	{
		this.atom_site_label_asym_id_1 = atom_site_label_asym_id_1;
	}

 	protected java.lang.String atom_site_label_asym_id_2;


	/**
	 *  An optional identifier of the second of the three atom sites
	 *  that define the angle.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_asym_id_2() 
	{
		return atom_site_label_asym_id_2;
	}
 
	public void setAtom_site_label_asym_id_2(java.lang.String atom_site_label_asym_id_2)
	{
		this.atom_site_label_asym_id_2 = atom_site_label_asym_id_2;
	}

 	protected java.lang.String atom_site_label_asym_id_3;


	/**
	 *  An optional identifier of the third of the three atom sites that
	 *  define the angle.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_asym_id_3() 
	{
		return atom_site_label_asym_id_3;
	}
 
	public void setAtom_site_label_asym_id_3(java.lang.String atom_site_label_asym_id_3)
	{
		this.atom_site_label_asym_id_3 = atom_site_label_asym_id_3;
	}

 	protected java.lang.String atom_site_label_atom_id_1;


	/**
	 *  An optional identifier of the first of the three atom sites that
	 *  define the angle.
	 *  
	 *  This data item is a pointer to  attribute label_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_atom_id_1() 
	{
		return atom_site_label_atom_id_1;
	}
 
	public void setAtom_site_label_atom_id_1(java.lang.String atom_site_label_atom_id_1)
	{
		this.atom_site_label_atom_id_1 = atom_site_label_atom_id_1;
	}

 	protected java.lang.String atom_site_label_atom_id_2;


	/**
	 *  An optional identifier of the second of the three atom sites
	 *  that define the angle.
	 *  
	 *  This data item is a pointer to  attribute label_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_atom_id_2() 
	{
		return atom_site_label_atom_id_2;
	}
 
	public void setAtom_site_label_atom_id_2(java.lang.String atom_site_label_atom_id_2)
	{
		this.atom_site_label_atom_id_2 = atom_site_label_atom_id_2;
	}

 	protected java.lang.String atom_site_label_atom_id_3;


	/**
	 *  An optional identifier of the third of the three atom sites that
	 *  define the angle.
	 *  
	 *  This data item is a pointer to  attribute label_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_atom_id_3() 
	{
		return atom_site_label_atom_id_3;
	}
 
	public void setAtom_site_label_atom_id_3(java.lang.String atom_site_label_atom_id_3)
	{
		this.atom_site_label_atom_id_3 = atom_site_label_atom_id_3;
	}

 	protected java.lang.String atom_site_label_comp_id_1;


	/**
	 *  An optional identifier of the first of the three atom sites that
	 *  define the angle.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_comp_id_1() 
	{
		return atom_site_label_comp_id_1;
	}
 
	public void setAtom_site_label_comp_id_1(java.lang.String atom_site_label_comp_id_1)
	{
		this.atom_site_label_comp_id_1 = atom_site_label_comp_id_1;
	}

 	protected java.lang.String atom_site_label_comp_id_2;


	/**
	 *  An optional identifier of the second of the three atom sites
	 *  that define the angle.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_comp_id_2() 
	{
		return atom_site_label_comp_id_2;
	}
 
	public void setAtom_site_label_comp_id_2(java.lang.String atom_site_label_comp_id_2)
	{
		this.atom_site_label_comp_id_2 = atom_site_label_comp_id_2;
	}

 	protected java.lang.String atom_site_label_comp_id_3;


	/**
	 *  An optional identifier of the third of the three atom sites that
	 *  define the angle.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_comp_id_3() 
	{
		return atom_site_label_comp_id_3;
	}
 
	public void setAtom_site_label_comp_id_3(java.lang.String atom_site_label_comp_id_3)
	{
		this.atom_site_label_comp_id_3 = atom_site_label_comp_id_3;
	}

 	protected java.lang.Integer atom_site_label_seq_id_1;


	/**
	 *  An optional identifier of the first of the three atom sites that
	 *  define the angle.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getAtom_site_label_seq_id_1() 
	{
		return atom_site_label_seq_id_1;
	}
 
	public void setAtom_site_label_seq_id_1(java.lang.Integer atom_site_label_seq_id_1)
	{
		this.atom_site_label_seq_id_1 = atom_site_label_seq_id_1;
	}

 	protected java.lang.Integer atom_site_label_seq_id_2;


	/**
	 *  An optional identifier of the second of the three atom sites
	 *  that define the angle.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getAtom_site_label_seq_id_2() 
	{
		return atom_site_label_seq_id_2;
	}
 
	public void setAtom_site_label_seq_id_2(java.lang.Integer atom_site_label_seq_id_2)
	{
		this.atom_site_label_seq_id_2 = atom_site_label_seq_id_2;
	}

 	protected java.lang.Integer atom_site_label_seq_id_3;


	/**
	 *  An optional identifier of the third of the three atom sites that
	 *  define the angle.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getAtom_site_label_seq_id_3() 
	{
		return atom_site_label_seq_id_3;
	}
 
	public void setAtom_site_label_seq_id_3(java.lang.Integer atom_site_label_seq_id_3)
	{
		this.atom_site_label_seq_id_3 = atom_site_label_seq_id_3;
	}

 	protected java.lang.Integer pdbx_PDB_model_num;


	/**
	 *  Pointer to  attribute pdbx_PDB_model_num in category atom_site
	 */
	public java.lang.Integer getPdbx_PDB_model_num() 
	{
		return pdbx_PDB_model_num;
	}
 
	public void setPdbx_PDB_model_num(java.lang.Integer pdbx_PDB_model_num)
	{
		this.pdbx_PDB_model_num = pdbx_PDB_model_num;
	}

 	protected java.lang.String pdbx_atom_site_PDB_ins_code_1;


	/**
	 *  Pointer to  attribute pdbx_PDB_ins_code in category atom_site.
	 */
	public java.lang.String getPdbx_atom_site_PDB_ins_code_1() 
	{
		return pdbx_atom_site_PDB_ins_code_1;
	}
 
	public void setPdbx_atom_site_PDB_ins_code_1(java.lang.String pdbx_atom_site_PDB_ins_code_1)
	{
		this.pdbx_atom_site_PDB_ins_code_1 = pdbx_atom_site_PDB_ins_code_1;
	}

 	protected java.lang.String pdbx_atom_site_PDB_ins_code_2;


	/**
	 *  Pointer to  attribute pdbx_PDB_ins_code in category atom_site.
	 */
	public java.lang.String getPdbx_atom_site_PDB_ins_code_2() 
	{
		return pdbx_atom_site_PDB_ins_code_2;
	}
 
	public void setPdbx_atom_site_PDB_ins_code_2(java.lang.String pdbx_atom_site_PDB_ins_code_2)
	{
		this.pdbx_atom_site_PDB_ins_code_2 = pdbx_atom_site_PDB_ins_code_2;
	}

 	protected java.lang.String pdbx_atom_site_PDB_ins_code_3;


	/**
	 *  Pointer to  attribute pdbx_PDB_ins_code in category atom_site.
	 */
	public java.lang.String getPdbx_atom_site_PDB_ins_code_3() 
	{
		return pdbx_atom_site_PDB_ins_code_3;
	}
 
	public void setPdbx_atom_site_PDB_ins_code_3(java.lang.String pdbx_atom_site_PDB_ins_code_3)
	{
		this.pdbx_atom_site_PDB_ins_code_3 = pdbx_atom_site_PDB_ins_code_3;
	}

 	protected java.lang.String publ_flag;


	/**
	 *  This code signals whether the angle is referred to in a
	 *  publication or should be placed in a table of significant angles.
	 */
	public java.lang.String getPubl_flag() 
	{
		return publ_flag;
	}
 
	public void setPubl_flag(java.lang.String publ_flag)
	{
		this.publ_flag = publ_flag;
	}

 	protected java.lang.String site_symmetry_1;


	/**
	 *  The symmetry code of the first of the three atom sites that
	 *  define the angle.
	 *  no symmetry or translation to site
	 *  4th symmetry operation applied
	 *  4
	 *  7th symm. posn.; +a on x; -b on y
	 *  7_645
	 */
	public java.lang.String getSite_symmetry_1() 
	{
		return site_symmetry_1;
	}
 
	public void setSite_symmetry_1(java.lang.String site_symmetry_1)
	{
		this.site_symmetry_1 = site_symmetry_1;
	}

 	protected java.lang.String site_symmetry_2;


	/**
	 *  The symmetry code of the second of the three atom sites that
	 *  define the angle.
	 *  no symmetry or translation to site
	 *  4th symmetry operation applied
	 *  4
	 *  7th symm. posn.; +a on x; -b on y
	 *  7_645
	 */
	public java.lang.String getSite_symmetry_2() 
	{
		return site_symmetry_2;
	}
 
	public void setSite_symmetry_2(java.lang.String site_symmetry_2)
	{
		this.site_symmetry_2 = site_symmetry_2;
	}

 	protected java.lang.String site_symmetry_3;


	/**
	 *  The symmetry code of the third of the three atom sites that
	 *  define the angle.
	 *  no symmetry or translation to site
	 *  4th symmetry operation applied
	 *  4
	 *  7th symm. posn.; +a on x; -b on y
	 *  7_645
	 */
	public java.lang.String getSite_symmetry_3() 
	{
		return site_symmetry_3;
	}
 
	public void setSite_symmetry_3(java.lang.String site_symmetry_3)
	{
		this.site_symmetry_3 = site_symmetry_3;
	}

 	protected java.lang.Float value;


	/**
	 *  Angle in degrees defined by the three sites
	 *  _geom_angle.atom_site_id_1, _geom_angle.atom_site_id_2 and
	 *  attribute atom_site_id_3 in category geom_angle.
	 */
	public java.lang.Float getValue() 
	{
		return value;
	}
 
	public void setValue(java.lang.Float value)
	{
		this.value = value;
	}

 	protected java.lang.Float value_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute value in category geom_angle.
	 */
	public java.lang.Float getValue_esd() 
	{
		return value_esd;
	}
 
	public void setValue_esd(java.lang.Float value_esd)
	{
		this.value_esd = value_esd;
	}

 }
