package org.pdb.beans;

/**
 *  Data items in the GEOM_TORSION category record details about
 *  torsion angles as calculated from the
 *  contents of the ATOM, CELL and SYMMETRY data.
 *  
 *  The vector direction  attribute atom_site_id_2 in category geom_torsion to
 *  attribute atom_site_id_3 in category geom_torsion is the viewing direction, and the
 *  torsion angle is the angle of twist required to superimpose the
 *  projection of the vector between site 2 and site 1 onto the
 *  projection of the vector between site 3 and site 4. Clockwise
 *  torsions are positive, anticlockwise torsions are negative.
 *  
 *  Ref: Klyne, W. & Prelog, V. (1960). Experientia, 16, 521-523.
 *  
 * <pre>
 *  Example 1 - based on data set CLPHO6 of Ferguson, Ruhl, McKervey & Browne
 *  [Acta Cryst. (1992), C48, 2262-2264].
 *  <PDBx:geom_torsionCategory>
 *  <PDBx:geom_torsion atom_site_id_1="C(9)" atom_site_id_2="O(2)" atom_site_id_3="C(7)" atom_site_id_4="C(2)" site_symmetry_1="" site_symmetry_2="" site_symmetry_3="" site_symmetry_4="">
 *  <PDBx:value>71.8</PDBx:value>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_torsion>
 *  <PDBx:geom_torsion atom_site_id_1="C(7)" atom_site_id_2="O(2)" atom_site_id_3="C(9)" atom_site_id_4="C(10)" site_symmetry_1="" site_symmetry_2="" site_symmetry_3="" site_symmetry_4="2_666">
 *  <PDBx:value>-168.0</PDBx:value>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_torsion>
 *  <PDBx:geom_torsion atom_site_id_1="C(10)" atom_site_id_2="O(3)" atom_site_id_3="C(8)" atom_site_id_4="C(6)" site_symmetry_1="" site_symmetry_2="" site_symmetry_3="" site_symmetry_4="">
 *  <PDBx:value>-167.7</PDBx:value>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_torsion>
 *  <PDBx:geom_torsion atom_site_id_1="C(8)" atom_site_id_2="O(3)" atom_site_id_3="C(10)" atom_site_id_4="C(9)" site_symmetry_1="" site_symmetry_2="" site_symmetry_3="" site_symmetry_4="2_666">
 *  <PDBx:value>-69.7</PDBx:value>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_torsion>
 *  <PDBx:geom_torsion atom_site_id_1="O(1)" atom_site_id_2="C(1)" atom_site_id_3="C(2)" atom_site_id_4="C(3)" site_symmetry_1="" site_symmetry_2="" site_symmetry_3="" site_symmetry_4="">
 *  <PDBx:value>-179.5</PDBx:value>
 *  <PDBx:publ_flag>no</PDBx:publ_flag>
 *  </PDBx:geom_torsion>
 *  <PDBx:geom_torsion atom_site_id_1="O(1)" atom_site_id_2="C(1)" atom_site_id_3="C(2)" atom_site_id_4="C(7)" site_symmetry_1="" site_symmetry_2="" site_symmetry_3="" site_symmetry_4="">
 *  <PDBx:value>-0.6</PDBx:value>
 *  <PDBx:publ_flag>no</PDBx:publ_flag>
 *  </PDBx:geom_torsion>
 *  </PDBx:geom_torsionCategory>
 * </pre>
 */
public class Geom_torsion 
{
		protected java.lang.String atom_site_auth_asym_id_1;


	/**
	 *  An optional identifier of the first of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_asym_id_1() 
	{
		return atom_site_auth_asym_id_1;
	}
 
	public void setAtom_site_auth_asym_id_1(java.lang.String atom_site_auth_asym_id_1)
	{
		this.atom_site_auth_asym_id_1 = atom_site_auth_asym_id_1;
	}

 	protected java.lang.String atom_site_auth_asym_id_2;


	/**
	 *  An optional identifier of the second of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_asym_id_2() 
	{
		return atom_site_auth_asym_id_2;
	}
 
	public void setAtom_site_auth_asym_id_2(java.lang.String atom_site_auth_asym_id_2)
	{
		this.atom_site_auth_asym_id_2 = atom_site_auth_asym_id_2;
	}

 	protected java.lang.String atom_site_auth_asym_id_3;


	/**
	 *  An optional identifier of the third of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_asym_id_3() 
	{
		return atom_site_auth_asym_id_3;
	}
 
	public void setAtom_site_auth_asym_id_3(java.lang.String atom_site_auth_asym_id_3)
	{
		this.atom_site_auth_asym_id_3 = atom_site_auth_asym_id_3;
	}

 	protected java.lang.String atom_site_auth_asym_id_4;


	/**
	 *  An optional identifier of the fourth of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_asym_id_4() 
	{
		return atom_site_auth_asym_id_4;
	}
 
	public void setAtom_site_auth_asym_id_4(java.lang.String atom_site_auth_asym_id_4)
	{
		this.atom_site_auth_asym_id_4 = atom_site_auth_asym_id_4;
	}

 	protected java.lang.String atom_site_auth_atom_id_1;


	/**
	 *  An optional identifier of the first of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute auth_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_atom_id_1() 
	{
		return atom_site_auth_atom_id_1;
	}
 
	public void setAtom_site_auth_atom_id_1(java.lang.String atom_site_auth_atom_id_1)
	{
		this.atom_site_auth_atom_id_1 = atom_site_auth_atom_id_1;
	}

 	protected java.lang.String atom_site_auth_atom_id_2;


	/**
	 *  An optional identifier of the second of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute auth_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_atom_id_2() 
	{
		return atom_site_auth_atom_id_2;
	}
 
	public void setAtom_site_auth_atom_id_2(java.lang.String atom_site_auth_atom_id_2)
	{
		this.atom_site_auth_atom_id_2 = atom_site_auth_atom_id_2;
	}

 	protected java.lang.String atom_site_auth_atom_id_3;


	/**
	 *  An optional identifier of the third of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute auth_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_atom_id_3() 
	{
		return atom_site_auth_atom_id_3;
	}
 
	public void setAtom_site_auth_atom_id_3(java.lang.String atom_site_auth_atom_id_3)
	{
		this.atom_site_auth_atom_id_3 = atom_site_auth_atom_id_3;
	}

 	protected java.lang.String atom_site_auth_atom_id_4;


	/**
	 *  An optional identifier of the fourth of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute auth_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_atom_id_4() 
	{
		return atom_site_auth_atom_id_4;
	}
 
	public void setAtom_site_auth_atom_id_4(java.lang.String atom_site_auth_atom_id_4)
	{
		this.atom_site_auth_atom_id_4 = atom_site_auth_atom_id_4;
	}

 	protected java.lang.String atom_site_auth_comp_id_1;


	/**
	 *  An optional identifier of the first of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_comp_id_1() 
	{
		return atom_site_auth_comp_id_1;
	}
 
	public void setAtom_site_auth_comp_id_1(java.lang.String atom_site_auth_comp_id_1)
	{
		this.atom_site_auth_comp_id_1 = atom_site_auth_comp_id_1;
	}

 	protected java.lang.String atom_site_auth_comp_id_2;


	/**
	 *  An optional identifier of the second of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_comp_id_2() 
	{
		return atom_site_auth_comp_id_2;
	}
 
	public void setAtom_site_auth_comp_id_2(java.lang.String atom_site_auth_comp_id_2)
	{
		this.atom_site_auth_comp_id_2 = atom_site_auth_comp_id_2;
	}

 	protected java.lang.String atom_site_auth_comp_id_3;


	/**
	 *  An optional identifier of the third of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_comp_id_3() 
	{
		return atom_site_auth_comp_id_3;
	}
 
	public void setAtom_site_auth_comp_id_3(java.lang.String atom_site_auth_comp_id_3)
	{
		this.atom_site_auth_comp_id_3 = atom_site_auth_comp_id_3;
	}

 	protected java.lang.String atom_site_auth_comp_id_4;


	/**
	 *  An optional identifier of the fourth of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_comp_id_4() 
	{
		return atom_site_auth_comp_id_4;
	}
 
	public void setAtom_site_auth_comp_id_4(java.lang.String atom_site_auth_comp_id_4)
	{
		this.atom_site_auth_comp_id_4 = atom_site_auth_comp_id_4;
	}

 	protected java.lang.String atom_site_auth_seq_id_1;


	/**
	 *  An optional identifier of the first of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_seq_id_1() 
	{
		return atom_site_auth_seq_id_1;
	}
 
	public void setAtom_site_auth_seq_id_1(java.lang.String atom_site_auth_seq_id_1)
	{
		this.atom_site_auth_seq_id_1 = atom_site_auth_seq_id_1;
	}

 	protected java.lang.String atom_site_auth_seq_id_2;


	/**
	 *  An optional identifier of the second of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_seq_id_2() 
	{
		return atom_site_auth_seq_id_2;
	}
 
	public void setAtom_site_auth_seq_id_2(java.lang.String atom_site_auth_seq_id_2)
	{
		this.atom_site_auth_seq_id_2 = atom_site_auth_seq_id_2;
	}

 	protected java.lang.String atom_site_auth_seq_id_3;


	/**
	 *  An optional identifier of the third of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_seq_id_3() 
	{
		return atom_site_auth_seq_id_3;
	}
 
	public void setAtom_site_auth_seq_id_3(java.lang.String atom_site_auth_seq_id_3)
	{
		this.atom_site_auth_seq_id_3 = atom_site_auth_seq_id_3;
	}

 	protected java.lang.String atom_site_auth_seq_id_4;


	/**
	 *  An optional identifier of the fourth of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_seq_id_4() 
	{
		return atom_site_auth_seq_id_4;
	}
 
	public void setAtom_site_auth_seq_id_4(java.lang.String atom_site_auth_seq_id_4)
	{
		this.atom_site_auth_seq_id_4 = atom_site_auth_seq_id_4;
	}

 	protected java.lang.String atom_site_id_1;


	/**
	 *  The identifier of the first of the four atom sites that define
	 *  the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_site in the ATOM_SITE
	 *  category.
	 */
	public java.lang.String getAtom_site_id_1() 
	{
		return atom_site_id_1;
	}
 
	public void setAtom_site_id_1(java.lang.String atom_site_id_1)
	{
		this.atom_site_id_1 = atom_site_id_1;
	}

 	protected java.lang.String atom_site_id_2;


	/**
	 *  The identifier of the second of the four atom sites that define
	 *  the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_site in the ATOM_SITE
	 *  category.
	 */
	public java.lang.String getAtom_site_id_2() 
	{
		return atom_site_id_2;
	}
 
	public void setAtom_site_id_2(java.lang.String atom_site_id_2)
	{
		this.atom_site_id_2 = atom_site_id_2;
	}

 	protected java.lang.String atom_site_id_3;


	/**
	 *  The identifier of the third of the four atom sites that define
	 *  the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_site in the ATOM_SITE
	 *  category.
	 */
	public java.lang.String getAtom_site_id_3() 
	{
		return atom_site_id_3;
	}
 
	public void setAtom_site_id_3(java.lang.String atom_site_id_3)
	{
		this.atom_site_id_3 = atom_site_id_3;
	}

 	protected java.lang.String atom_site_id_4;


	/**
	 *  The identifier of the fourth of the four atom sites that define
	 *  the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_site in the ATOM_SITE
	 *  category.
	 */
	public java.lang.String getAtom_site_id_4() 
	{
		return atom_site_id_4;
	}
 
	public void setAtom_site_id_4(java.lang.String atom_site_id_4)
	{
		this.atom_site_id_4 = atom_site_id_4;
	}

 	protected java.lang.String atom_site_label_alt_id_1;


	/**
	 *  An optional identifier of the first of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute label_alt_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_alt_id_1() 
	{
		return atom_site_label_alt_id_1;
	}
 
	public void setAtom_site_label_alt_id_1(java.lang.String atom_site_label_alt_id_1)
	{
		this.atom_site_label_alt_id_1 = atom_site_label_alt_id_1;
	}

 	protected java.lang.String atom_site_label_alt_id_2;


	/**
	 *  An optional identifier of the second of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute label_alt_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_alt_id_2() 
	{
		return atom_site_label_alt_id_2;
	}
 
	public void setAtom_site_label_alt_id_2(java.lang.String atom_site_label_alt_id_2)
	{
		this.atom_site_label_alt_id_2 = atom_site_label_alt_id_2;
	}

 	protected java.lang.String atom_site_label_alt_id_3;


	/**
	 *  An optional identifier of the third of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute label_alt_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_alt_id_3() 
	{
		return atom_site_label_alt_id_3;
	}
 
	public void setAtom_site_label_alt_id_3(java.lang.String atom_site_label_alt_id_3)
	{
		this.atom_site_label_alt_id_3 = atom_site_label_alt_id_3;
	}

 	protected java.lang.String atom_site_label_alt_id_4;


	/**
	 *  An optional identifier of the fourth of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute label_alt_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_alt_id_4() 
	{
		return atom_site_label_alt_id_4;
	}
 
	public void setAtom_site_label_alt_id_4(java.lang.String atom_site_label_alt_id_4)
	{
		this.atom_site_label_alt_id_4 = atom_site_label_alt_id_4;
	}

 	protected java.lang.String atom_site_label_asym_id_1;


	/**
	 *  An optional identifier of the first of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_asym_id_1() 
	{
		return atom_site_label_asym_id_1;
	}
 
	public void setAtom_site_label_asym_id_1(java.lang.String atom_site_label_asym_id_1)
	{
		this.atom_site_label_asym_id_1 = atom_site_label_asym_id_1;
	}

 	protected java.lang.String atom_site_label_asym_id_2;


	/**
	 *  An optional identifier of the second of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_asym_id_2() 
	{
		return atom_site_label_asym_id_2;
	}
 
	public void setAtom_site_label_asym_id_2(java.lang.String atom_site_label_asym_id_2)
	{
		this.atom_site_label_asym_id_2 = atom_site_label_asym_id_2;
	}

 	protected java.lang.String atom_site_label_asym_id_3;


	/**
	 *  An optional identifier of the third of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_asym_id_3() 
	{
		return atom_site_label_asym_id_3;
	}
 
	public void setAtom_site_label_asym_id_3(java.lang.String atom_site_label_asym_id_3)
	{
		this.atom_site_label_asym_id_3 = atom_site_label_asym_id_3;
	}

 	protected java.lang.String atom_site_label_asym_id_4;


	/**
	 *  An optional identifier of the fourth of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_asym_id_4() 
	{
		return atom_site_label_asym_id_4;
	}
 
	public void setAtom_site_label_asym_id_4(java.lang.String atom_site_label_asym_id_4)
	{
		this.atom_site_label_asym_id_4 = atom_site_label_asym_id_4;
	}

 	protected java.lang.String atom_site_label_atom_id_1;


	/**
	 *  An optional identifier of the first of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute label_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_atom_id_1() 
	{
		return atom_site_label_atom_id_1;
	}
 
	public void setAtom_site_label_atom_id_1(java.lang.String atom_site_label_atom_id_1)
	{
		this.atom_site_label_atom_id_1 = atom_site_label_atom_id_1;
	}

 	protected java.lang.String atom_site_label_atom_id_2;


	/**
	 *  An optional identifier of the second of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute label_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_atom_id_2() 
	{
		return atom_site_label_atom_id_2;
	}
 
	public void setAtom_site_label_atom_id_2(java.lang.String atom_site_label_atom_id_2)
	{
		this.atom_site_label_atom_id_2 = atom_site_label_atom_id_2;
	}

 	protected java.lang.String atom_site_label_atom_id_3;


	/**
	 *  An optional identifier of the third of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute label_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_atom_id_3() 
	{
		return atom_site_label_atom_id_3;
	}
 
	public void setAtom_site_label_atom_id_3(java.lang.String atom_site_label_atom_id_3)
	{
		this.atom_site_label_atom_id_3 = atom_site_label_atom_id_3;
	}

 	protected java.lang.String atom_site_label_atom_id_4;


	/**
	 *  An optional identifier of the fourth of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute label_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_atom_id_4() 
	{
		return atom_site_label_atom_id_4;
	}
 
	public void setAtom_site_label_atom_id_4(java.lang.String atom_site_label_atom_id_4)
	{
		this.atom_site_label_atom_id_4 = atom_site_label_atom_id_4;
	}

 	protected java.lang.String atom_site_label_comp_id_1;


	/**
	 *  An optional identifier of the first of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_comp_id_1() 
	{
		return atom_site_label_comp_id_1;
	}
 
	public void setAtom_site_label_comp_id_1(java.lang.String atom_site_label_comp_id_1)
	{
		this.atom_site_label_comp_id_1 = atom_site_label_comp_id_1;
	}

 	protected java.lang.String atom_site_label_comp_id_2;


	/**
	 *  An optional identifier of the second of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_comp_id_2() 
	{
		return atom_site_label_comp_id_2;
	}
 
	public void setAtom_site_label_comp_id_2(java.lang.String atom_site_label_comp_id_2)
	{
		this.atom_site_label_comp_id_2 = atom_site_label_comp_id_2;
	}

 	protected java.lang.String atom_site_label_comp_id_3;


	/**
	 *  An optional identifier of the third of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_comp_id_3() 
	{
		return atom_site_label_comp_id_3;
	}
 
	public void setAtom_site_label_comp_id_3(java.lang.String atom_site_label_comp_id_3)
	{
		this.atom_site_label_comp_id_3 = atom_site_label_comp_id_3;
	}

 	protected java.lang.String atom_site_label_comp_id_4;


	/**
	 *  An optional identifier of the fourth of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_comp_id_4() 
	{
		return atom_site_label_comp_id_4;
	}
 
	public void setAtom_site_label_comp_id_4(java.lang.String atom_site_label_comp_id_4)
	{
		this.atom_site_label_comp_id_4 = atom_site_label_comp_id_4;
	}

 	protected java.lang.Integer atom_site_label_seq_id_1;


	/**
	 *  An optional identifier of the first of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getAtom_site_label_seq_id_1() 
	{
		return atom_site_label_seq_id_1;
	}
 
	public void setAtom_site_label_seq_id_1(java.lang.Integer atom_site_label_seq_id_1)
	{
		this.atom_site_label_seq_id_1 = atom_site_label_seq_id_1;
	}

 	protected java.lang.Integer atom_site_label_seq_id_2;


	/**
	 *  An optional identifier of the second of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getAtom_site_label_seq_id_2() 
	{
		return atom_site_label_seq_id_2;
	}
 
	public void setAtom_site_label_seq_id_2(java.lang.Integer atom_site_label_seq_id_2)
	{
		this.atom_site_label_seq_id_2 = atom_site_label_seq_id_2;
	}

 	protected java.lang.Integer atom_site_label_seq_id_3;


	/**
	 *  An optional identifier of the third of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getAtom_site_label_seq_id_3() 
	{
		return atom_site_label_seq_id_3;
	}
 
	public void setAtom_site_label_seq_id_3(java.lang.Integer atom_site_label_seq_id_3)
	{
		this.atom_site_label_seq_id_3 = atom_site_label_seq_id_3;
	}

 	protected java.lang.Integer atom_site_label_seq_id_4;


	/**
	 *  An optional identifier of the fourth of the four atom sites that
	 *  define the torsion angle.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getAtom_site_label_seq_id_4() 
	{
		return atom_site_label_seq_id_4;
	}
 
	public void setAtom_site_label_seq_id_4(java.lang.Integer atom_site_label_seq_id_4)
	{
		this.atom_site_label_seq_id_4 = atom_site_label_seq_id_4;
	}

 	protected java.lang.Integer pdbx_PDB_model_num;


	/**
	 *  Pointer to  attribute pdbx_PDB_model_num in category atom_site
	 */
	public java.lang.Integer getPdbx_PDB_model_num() 
	{
		return pdbx_PDB_model_num;
	}
 
	public void setPdbx_PDB_model_num(java.lang.Integer pdbx_PDB_model_num)
	{
		this.pdbx_PDB_model_num = pdbx_PDB_model_num;
	}

 	protected java.lang.String pdbx_atom_site_PDB_ins_code_1;


	/**
	 *  Pointer to  attribute pdbx_PDB_ins_code in category atom_site.
	 */
	public java.lang.String getPdbx_atom_site_PDB_ins_code_1() 
	{
		return pdbx_atom_site_PDB_ins_code_1;
	}
 
	public void setPdbx_atom_site_PDB_ins_code_1(java.lang.String pdbx_atom_site_PDB_ins_code_1)
	{
		this.pdbx_atom_site_PDB_ins_code_1 = pdbx_atom_site_PDB_ins_code_1;
	}

 	protected java.lang.String pdbx_atom_site_PDB_ins_code_2;


	/**
	 *  Pointer to  attribute pdbx_PDB_ins_code in category atom_site.
	 */
	public java.lang.String getPdbx_atom_site_PDB_ins_code_2() 
	{
		return pdbx_atom_site_PDB_ins_code_2;
	}
 
	public void setPdbx_atom_site_PDB_ins_code_2(java.lang.String pdbx_atom_site_PDB_ins_code_2)
	{
		this.pdbx_atom_site_PDB_ins_code_2 = pdbx_atom_site_PDB_ins_code_2;
	}

 	protected java.lang.String pdbx_atom_site_PDB_ins_code_3;


	/**
	 *  Pointer to  attribute pdbx_PDB_ins_code in category atom_site.
	 */
	public java.lang.String getPdbx_atom_site_PDB_ins_code_3() 
	{
		return pdbx_atom_site_PDB_ins_code_3;
	}
 
	public void setPdbx_atom_site_PDB_ins_code_3(java.lang.String pdbx_atom_site_PDB_ins_code_3)
	{
		this.pdbx_atom_site_PDB_ins_code_3 = pdbx_atom_site_PDB_ins_code_3;
	}

 	protected java.lang.String pdbx_atom_site_PDB_ins_code_4;


	/**
	 *  Pointer to  attribute pdbx_PDB_ins_code in category atom_site.
	 */
	public java.lang.String getPdbx_atom_site_PDB_ins_code_4() 
	{
		return pdbx_atom_site_PDB_ins_code_4;
	}
 
	public void setPdbx_atom_site_PDB_ins_code_4(java.lang.String pdbx_atom_site_PDB_ins_code_4)
	{
		this.pdbx_atom_site_PDB_ins_code_4 = pdbx_atom_site_PDB_ins_code_4;
	}

 	protected java.lang.String publ_flag;


	/**
	 *  This code signals whether the torsion angle is referred to in a
	 *  publication or should be placed in a table of significant
	 *  torsion angles.
	 */
	public java.lang.String getPubl_flag() 
	{
		return publ_flag;
	}
 
	public void setPubl_flag(java.lang.String publ_flag)
	{
		this.publ_flag = publ_flag;
	}

 	protected java.lang.String site_symmetry_1;


	/**
	 *  The symmetry code of the first of the four atom sites that
	 *  define the torsion angle.
	 *  no symmetry or translation to site
	 *  4th symmetry operation applied
	 *  4
	 *  7th symm. posn.; +a on x; -b on y
	 *  7_645
	 */
	public java.lang.String getSite_symmetry_1() 
	{
		return site_symmetry_1;
	}
 
	public void setSite_symmetry_1(java.lang.String site_symmetry_1)
	{
		this.site_symmetry_1 = site_symmetry_1;
	}

 	protected java.lang.String site_symmetry_2;


	/**
	 *  The symmetry code of the second of the four atom sites that
	 *  define the torsion angle.
	 *  no symmetry or translation to site
	 *  4th symmetry operation applied
	 *  4
	 *  7th symm. posn.; +a on x; -b on y
	 *  7_645
	 */
	public java.lang.String getSite_symmetry_2() 
	{
		return site_symmetry_2;
	}
 
	public void setSite_symmetry_2(java.lang.String site_symmetry_2)
	{
		this.site_symmetry_2 = site_symmetry_2;
	}

 	protected java.lang.String site_symmetry_3;


	/**
	 *  The symmetry code of the third of the four atom sites that
	 *  define the torsion angle.
	 *  no symmetry or translation to site
	 *  4th symmetry operation applied
	 *  4
	 *  7th symm. posn.; +a on x; -b on y
	 *  7_645
	 */
	public java.lang.String getSite_symmetry_3() 
	{
		return site_symmetry_3;
	}
 
	public void setSite_symmetry_3(java.lang.String site_symmetry_3)
	{
		this.site_symmetry_3 = site_symmetry_3;
	}

 	protected java.lang.String site_symmetry_4;


	/**
	 *  The symmetry code of the fourth of the four atom sites that
	 *  define the torsion angle.
	 *  no symmetry or translation to site
	 *  4th symmetry operation applied
	 *  4
	 *  7th symm. posn.; +a on x; -b on y
	 *  7_645
	 */
	public java.lang.String getSite_symmetry_4() 
	{
		return site_symmetry_4;
	}
 
	public void setSite_symmetry_4(java.lang.String site_symmetry_4)
	{
		this.site_symmetry_4 = site_symmetry_4;
	}

 	protected java.lang.Float value;


	/**
	 *  The value of the torsion angle in degrees.
	 */
	public java.lang.Float getValue() 
	{
		return value;
	}
 
	public void setValue(java.lang.Float value)
	{
		this.value = value;
	}

 	protected java.lang.Float value_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute value in category geom_torsion.
	 */
	public java.lang.Float getValue_esd() 
	{
		return value_esd;
	}
 
	public void setValue_esd(java.lang.Float value_esd)
	{
		this.value_esd = value_esd;
	}

 }
