package org.pdb.beans;

/**
 *  Data items in the JOURNAL category record details about the
 *  book-keeping by the journal staff when processing
 *  a data block submitted for publication.
 *  
 *  The creator of a data block will not normally specify these data.
 *  The data names are not defined in the dictionary because they are
 *  for journal use only.
 *  
 * <pre>
 *  Example 1 - based on Acta Cryst. file for entry HL0007 [Willis, Beckwith
 *  & Tozer (1991). Acta Cryst. C47, 2276-2277].
 *  <PDBx:journalCategory>
 *  <PDBx:journal entry_id="TOZ">
 *  <PDBx:date_recd_electronic>1991-04-15</PDBx:date_recd_electronic>
 *  <PDBx:date_from_coeditor>1991-04-18</PDBx:date_from_coeditor>
 *  <PDBx:date_accepted>1991-04-18</PDBx:date_accepted>
 *  <PDBx:date_printers_first>1991-08-07</PDBx:date_printers_first>
 *  <PDBx:date_proofs_out>1991-08-07</PDBx:date_proofs_out>
 *  <PDBx:coeditor_code>HL0007</PDBx:coeditor_code>
 *  <PDBx:techeditor_code>C910963</PDBx:techeditor_code>
 *  <PDBx:coden_ASTM>ACSCEE</PDBx:coden_ASTM>
 *  <PDBx:name_full>Acta Crystallographica Section C</PDBx:name_full>
 *  <PDBx:year>1991</PDBx:year>
 *  <PDBx:volume>47</PDBx:volume>
 *  <PDBx:issue>NOV91</PDBx:issue>
 *  <PDBx:page_first>2276</PDBx:page_first>
 *  <PDBx:page_last>2277</PDBx:page_last>
 *  </PDBx:journal>
 *  </PDBx:journalCategory>
 * </pre>
 */
public class Journal 
{
		protected java.lang.String coden_ASTM;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getCoden_ASTM() 
	{
		return coden_ASTM;
	}
 
	public void setCoden_ASTM(java.lang.String coden_ASTM)
	{
		this.coden_ASTM = coden_ASTM;
	}

 	protected java.lang.String coden_Cambridge;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getCoden_Cambridge() 
	{
		return coden_Cambridge;
	}
 
	public void setCoden_Cambridge(java.lang.String coden_Cambridge)
	{
		this.coden_Cambridge = coden_Cambridge;
	}

 	protected java.lang.String coeditor_address;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getCoeditor_address() 
	{
		return coeditor_address;
	}
 
	public void setCoeditor_address(java.lang.String coeditor_address)
	{
		this.coeditor_address = coeditor_address;
	}

 	protected java.lang.String coeditor_code;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getCoeditor_code() 
	{
		return coeditor_code;
	}
 
	public void setCoeditor_code(java.lang.String coeditor_code)
	{
		this.coeditor_code = coeditor_code;
	}

 	protected java.lang.String coeditor_email;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getCoeditor_email() 
	{
		return coeditor_email;
	}
 
	public void setCoeditor_email(java.lang.String coeditor_email)
	{
		this.coeditor_email = coeditor_email;
	}

 	protected java.lang.String coeditor_fax;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getCoeditor_fax() 
	{
		return coeditor_fax;
	}
 
	public void setCoeditor_fax(java.lang.String coeditor_fax)
	{
		this.coeditor_fax = coeditor_fax;
	}

 	protected java.lang.String coeditor_name;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getCoeditor_name() 
	{
		return coeditor_name;
	}
 
	public void setCoeditor_name(java.lang.String coeditor_name)
	{
		this.coeditor_name = coeditor_name;
	}

 	protected java.lang.String coeditor_notes;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getCoeditor_notes() 
	{
		return coeditor_notes;
	}
 
	public void setCoeditor_notes(java.lang.String coeditor_notes)
	{
		this.coeditor_notes = coeditor_notes;
	}

 	protected java.lang.String coeditor_phone;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getCoeditor_phone() 
	{
		return coeditor_phone;
	}
 
	public void setCoeditor_phone(java.lang.String coeditor_phone)
	{
		this.coeditor_phone = coeditor_phone;
	}

 	protected java.lang.String data_validation_number;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getData_validation_number() 
	{
		return data_validation_number;
	}
 
	public void setData_validation_number(java.lang.String data_validation_number)
	{
		this.data_validation_number = data_validation_number;
	}

 	protected java.util.Date date_accepted;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.util.Date getDate_accepted() 
	{
		return date_accepted;
	}
 
	public void setDate_accepted(java.util.Date date_accepted)
	{
		this.date_accepted = date_accepted;
	}

 	protected java.util.Date date_from_coeditor;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.util.Date getDate_from_coeditor() 
	{
		return date_from_coeditor;
	}
 
	public void setDate_from_coeditor(java.util.Date date_from_coeditor)
	{
		this.date_from_coeditor = date_from_coeditor;
	}

 	protected java.util.Date date_printers_final;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.util.Date getDate_printers_final() 
	{
		return date_printers_final;
	}
 
	public void setDate_printers_final(java.util.Date date_printers_final)
	{
		this.date_printers_final = date_printers_final;
	}

 	protected java.util.Date date_printers_first;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.util.Date getDate_printers_first() 
	{
		return date_printers_first;
	}
 
	public void setDate_printers_first(java.util.Date date_printers_first)
	{
		this.date_printers_first = date_printers_first;
	}

 	protected java.util.Date date_proofs_in;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.util.Date getDate_proofs_in() 
	{
		return date_proofs_in;
	}
 
	public void setDate_proofs_in(java.util.Date date_proofs_in)
	{
		this.date_proofs_in = date_proofs_in;
	}

 	protected java.util.Date date_proofs_out;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.util.Date getDate_proofs_out() 
	{
		return date_proofs_out;
	}
 
	public void setDate_proofs_out(java.util.Date date_proofs_out)
	{
		this.date_proofs_out = date_proofs_out;
	}

 	protected java.util.Date date_recd_copyright;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.util.Date getDate_recd_copyright() 
	{
		return date_recd_copyright;
	}
 
	public void setDate_recd_copyright(java.util.Date date_recd_copyright)
	{
		this.date_recd_copyright = date_recd_copyright;
	}

 	protected java.util.Date date_recd_electronic;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.util.Date getDate_recd_electronic() 
	{
		return date_recd_electronic;
	}
 
	public void setDate_recd_electronic(java.util.Date date_recd_electronic)
	{
		this.date_recd_electronic = date_recd_electronic;
	}

 	protected java.util.Date date_recd_hard_copy;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.util.Date getDate_recd_hard_copy() 
	{
		return date_recd_hard_copy;
	}
 
	public void setDate_recd_hard_copy(java.util.Date date_recd_hard_copy)
	{
		this.date_recd_hard_copy = date_recd_hard_copy;
	}

 	protected java.util.Date date_to_coeditor;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.util.Date getDate_to_coeditor() 
	{
		return date_to_coeditor;
	}
 
	public void setDate_to_coeditor(java.util.Date date_to_coeditor)
	{
		this.date_to_coeditor = date_to_coeditor;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String issue;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getIssue() 
	{
		return issue;
	}
 
	public void setIssue(java.lang.String issue)
	{
		this.issue = issue;
	}

 	protected java.lang.String language;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getLanguage() 
	{
		return language;
	}
 
	public void setLanguage(java.lang.String language)
	{
		this.language = language;
	}

 	protected java.lang.String name_full;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getName_full() 
	{
		return name_full;
	}
 
	public void setName_full(java.lang.String name_full)
	{
		this.name_full = name_full;
	}

 	protected java.lang.String page_first;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getPage_first() 
	{
		return page_first;
	}
 
	public void setPage_first(java.lang.String page_first)
	{
		this.page_first = page_first;
	}

 	protected java.lang.String page_last;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getPage_last() 
	{
		return page_last;
	}
 
	public void setPage_last(java.lang.String page_last)
	{
		this.page_last = page_last;
	}

 	protected java.lang.String paper_category;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getPaper_category() 
	{
		return paper_category;
	}
 
	public void setPaper_category(java.lang.String paper_category)
	{
		this.paper_category = paper_category;
	}

 	protected java.lang.String suppl_publ_number;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getSuppl_publ_number() 
	{
		return suppl_publ_number;
	}
 
	public void setSuppl_publ_number(java.lang.String suppl_publ_number)
	{
		this.suppl_publ_number = suppl_publ_number;
	}

 	protected java.lang.String suppl_publ_pages;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getSuppl_publ_pages() 
	{
		return suppl_publ_pages;
	}
 
	public void setSuppl_publ_pages(java.lang.String suppl_publ_pages)
	{
		this.suppl_publ_pages = suppl_publ_pages;
	}

 	protected java.lang.String techeditor_address;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getTecheditor_address() 
	{
		return techeditor_address;
	}
 
	public void setTecheditor_address(java.lang.String techeditor_address)
	{
		this.techeditor_address = techeditor_address;
	}

 	protected java.lang.String techeditor_code;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getTecheditor_code() 
	{
		return techeditor_code;
	}
 
	public void setTecheditor_code(java.lang.String techeditor_code)
	{
		this.techeditor_code = techeditor_code;
	}

 	protected java.lang.String techeditor_email;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getTecheditor_email() 
	{
		return techeditor_email;
	}
 
	public void setTecheditor_email(java.lang.String techeditor_email)
	{
		this.techeditor_email = techeditor_email;
	}

 	protected java.lang.String techeditor_fax;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getTecheditor_fax() 
	{
		return techeditor_fax;
	}
 
	public void setTecheditor_fax(java.lang.String techeditor_fax)
	{
		this.techeditor_fax = techeditor_fax;
	}

 	protected java.lang.String techeditor_name;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getTecheditor_name() 
	{
		return techeditor_name;
	}
 
	public void setTecheditor_name(java.lang.String techeditor_name)
	{
		this.techeditor_name = techeditor_name;
	}

 	protected java.lang.String techeditor_notes;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getTecheditor_notes() 
	{
		return techeditor_notes;
	}
 
	public void setTecheditor_notes(java.lang.String techeditor_notes)
	{
		this.techeditor_notes = techeditor_notes;
	}

 	protected java.lang.String techeditor_phone;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getTecheditor_phone() 
	{
		return techeditor_phone;
	}
 
	public void setTecheditor_phone(java.lang.String techeditor_phone)
	{
		this.techeditor_phone = techeditor_phone;
	}

 	protected java.lang.String volume;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getVolume() 
	{
		return volume;
	}
 
	public void setVolume(java.lang.String volume)
	{
		this.volume = volume;
	}

 	protected java.lang.String year;


	/**
	 *  Journal data items are defined by the journal staff.
	 */
	public java.lang.String getYear() 
	{
		return year;
	}
 
	public void setYear(java.lang.String year)
	{
		this.year = year;
	}

 }
