package org.pdb.beans;

/**
 *  Data items in the JOURNAL_INDEX category are used to list terms
 *  used to generate the journal indexes.
 *  
 *  The creator of a data block will not normally specify these data
 *  items.
 *  
 * <pre>
 *  Example 1 - based on a paper by Zhu, Reynolds, Klein & Trudell
 *  [Acta Cryst. (1994), C50, 2067-2069].
 *  <PDBx:journal_indexCategory>
 *  <PDBx:journal_index type="S" term="alkaloids">
 *  <PDBx:subterm>(-)-norcocaine</PDBx:subterm>
 *  </PDBx:journal_index>
 *  </PDBx:journal_indexCategory>
 * </pre>
 */
public class Journal_index 
{
		protected java.lang.String subterm;


	/**
	 *  Journal index data items are defined by the journal staff.
	 */
	public java.lang.String getSubterm() 
	{
		return subterm;
	}
 
	public void setSubterm(java.lang.String subterm)
	{
		this.subterm = subterm;
	}

 	protected java.lang.String term;


	/**
	 *  Journal index data items are defined by the journal staff.
	 */
	public java.lang.String getTerm() 
	{
		return term;
	}
 
	public void setTerm(java.lang.String term)
	{
		this.term = term;
	}

 	protected java.lang.String type;


	/**
	 *  Journal index data items are defined by the journal staff.
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 }
