package org.pdb.beans;

/**
 *  Data items in the NDB_STRUCT_NA_BASE_PAIR category record details
 *  of base pairing interactions.
 *  <PDBx:ndb_struct_na_base_pairCategory>
 *  <PDBx:ndb_struct_na_base_pair model_number="1" i_label_comp_id="G" i_label_asym_id="A" i_label_seq_id="1" i_symmetry="1_555" j_label_comp_id="C" j_label_asym_id="A" j_label_seq_id="8" j_symmetry="7_555">
 *  <PDBx:shear>-0.396</PDBx:shear>
 *  <PDBx:stretch>-0.156</PDBx:stretch>
 *  <PDBx:stagger>-0.018</PDBx:stagger>
 *  <PDBx:buckle>-5.523</PDBx:buckle>
 *  <PDBx:propeller>-6.752</PDBx:propeller>
 *  <PDBx:opening>-3.291</PDBx:opening>
 *  </PDBx:ndb_struct_na_base_pair>
 *  <PDBx:ndb_struct_na_base_pair model_number="1" i_label_comp_id="G" i_label_asym_id="A" i_label_seq_id="2" i_symmetry="1_555" j_label_comp_id="C" j_label_asym_id="A" j_label_seq_id="7" j_symmetry="7_555">
 *  <PDBx:shear>-0.094</PDBx:shear>
 *  <PDBx:stretch>-0.220</PDBx:stretch>
 *  <PDBx:stagger>-0.334</PDBx:stagger>
 *  <PDBx:buckle>-4.727</PDBx:buckle>
 *  <PDBx:propeller>-9.765</PDBx:propeller>
 *  <PDBx:opening>2.311</PDBx:opening>
 *  </PDBx:ndb_struct_na_base_pair>
 *  <PDBx:ndb_struct_na_base_pair model_number="1" i_label_comp_id="G" i_label_asym_id="A" i_label_seq_id="3" i_symmetry="1_555" j_label_comp_id="C" j_label_asym_id="A" j_label_seq_id="6" j_symmetry="7_555">
 *  <PDBx:shear>-0.285</PDBx:shear>
 *  <PDBx:stretch>-0.239</PDBx:stretch>
 *  <PDBx:stagger>0.008</PDBx:stagger>
 *  <PDBx:buckle>-6.454</PDBx:buckle>
 *  <PDBx:propeller>-12.575</PDBx:propeller>
 *  <PDBx:opening>-1.181</PDBx:opening>
 *  </PDBx:ndb_struct_na_base_pair>
 *  </PDBx:ndb_struct_na_base_pairCategory>
 */
public class Ndb_struct_na_base_pair 
{
		protected java.lang.Float buckle;


	/**
	 *  The value of the base pair buckle parameter.
	 */
	public java.lang.Float getBuckle() 
	{
		return buckle;
	}
 
	public void setBuckle(java.lang.Float buckle)
	{
		this.buckle = buckle;
	}

 	protected java.lang.Integer hbond_type_12;


	/**
	 *  Base pair classification of Westhoff and Leontis.
	 */
	public java.lang.Integer getHbond_type_12() 
	{
		return hbond_type_12;
	}
 
	public void setHbond_type_12(java.lang.Integer hbond_type_12)
	{
		this.hbond_type_12 = hbond_type_12;
	}

 	protected java.lang.Integer hbond_type_28;


	/**
	 *  Base pair classification of Saenger
	 */
	public java.lang.Integer getHbond_type_28() 
	{
		return hbond_type_28;
	}
 
	public void setHbond_type_28(java.lang.Integer hbond_type_28)
	{
		this.hbond_type_28 = hbond_type_28;
	}

 	protected java.lang.String i_PDB_ins_code;


	/**
	 *  Describes the PDB insertion code of the i-th base in the base pair.
	 *  
	 *  This data item is a pointer to  attribute pdbx_PDB_ins_code in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getI_PDB_ins_code() 
	{
		return i_PDB_ins_code;
	}
 
	public void setI_PDB_ins_code(java.lang.String i_PDB_ins_code)
	{
		this.i_PDB_ins_code = i_PDB_ins_code;
	}

 	protected java.lang.String i_auth_asym_id;


	/**
	 *  Describes the asym id of the i-th base in the base pair.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getI_auth_asym_id() 
	{
		return i_auth_asym_id;
	}
 
	public void setI_auth_asym_id(java.lang.String i_auth_asym_id)
	{
		this.i_auth_asym_id = i_auth_asym_id;
	}

 	protected java.lang.String i_auth_seq_id;


	/**
	 *  Describes the sequence number of the i-th base in the base pair.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getI_auth_seq_id() 
	{
		return i_auth_seq_id;
	}
 
	public void setI_auth_seq_id(java.lang.String i_auth_seq_id)
	{
		this.i_auth_seq_id = i_auth_seq_id;
	}

 	protected java.lang.String i_label_asym_id;


	/**
	 *  Describes the asym id of the i-th base in the base pair.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getI_label_asym_id() 
	{
		return i_label_asym_id;
	}
 
	public void setI_label_asym_id(java.lang.String i_label_asym_id)
	{
		this.i_label_asym_id = i_label_asym_id;
	}

 	protected java.lang.String i_label_comp_id;


	/**
	 *  Describes the component id of the i-th base in the base pair.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getI_label_comp_id() 
	{
		return i_label_comp_id;
	}
 
	public void setI_label_comp_id(java.lang.String i_label_comp_id)
	{
		this.i_label_comp_id = i_label_comp_id;
	}

 	protected java.lang.Integer i_label_seq_id;


	/**
	 *  Describes the sequence number of the i-th base in the base pair.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getI_label_seq_id() 
	{
		return i_label_seq_id;
	}
 
	public void setI_label_seq_id(java.lang.Integer i_label_seq_id)
	{
		this.i_label_seq_id = i_label_seq_id;
	}

 	protected java.lang.String i_symmetry;


	/**
	 *  Describes the symmetry operation that should be applied to the
	 *  coordinates of the i-th base to generate the first partner
	 *  in the base pair.
	 *  no symmetry or translation to site
	 *  4th symmetry operation applied
	 *  4
	 *  7th symm. posn.; +a on x; -b on y
	 *  7_645
	 */
	public java.lang.String getI_symmetry() 
	{
		return i_symmetry;
	}
 
	public void setI_symmetry(java.lang.String i_symmetry)
	{
		this.i_symmetry = i_symmetry;
	}

 	protected java.lang.String j_PDB_ins_code;


	/**
	 *  Describes the PDB insertion code of the j-th base in the base pair.
	 *  
	 *  This data item is a pointer to  attribute pdbx_PDB_ins_code in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getJ_PDB_ins_code() 
	{
		return j_PDB_ins_code;
	}
 
	public void setJ_PDB_ins_code(java.lang.String j_PDB_ins_code)
	{
		this.j_PDB_ins_code = j_PDB_ins_code;
	}

 	protected java.lang.String j_auth_asym_id;


	/**
	 *  Describes the asym id of the j-th base in the base pair.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getJ_auth_asym_id() 
	{
		return j_auth_asym_id;
	}
 
	public void setJ_auth_asym_id(java.lang.String j_auth_asym_id)
	{
		this.j_auth_asym_id = j_auth_asym_id;
	}

 	protected java.lang.String j_auth_seq_id;


	/**
	 *  Describes the sequence number of the j-th base in the base pair.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getJ_auth_seq_id() 
	{
		return j_auth_seq_id;
	}
 
	public void setJ_auth_seq_id(java.lang.String j_auth_seq_id)
	{
		this.j_auth_seq_id = j_auth_seq_id;
	}

 	protected java.lang.String j_label_asym_id;


	/**
	 *  Describes the asym id of the j-th base in the base pair.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getJ_label_asym_id() 
	{
		return j_label_asym_id;
	}
 
	public void setJ_label_asym_id(java.lang.String j_label_asym_id)
	{
		this.j_label_asym_id = j_label_asym_id;
	}

 	protected java.lang.String j_label_comp_id;


	/**
	 *  Describes the component id of the j-th base in the base pair.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getJ_label_comp_id() 
	{
		return j_label_comp_id;
	}
 
	public void setJ_label_comp_id(java.lang.String j_label_comp_id)
	{
		this.j_label_comp_id = j_label_comp_id;
	}

 	protected java.lang.Integer j_label_seq_id;


	/**
	 *  Describes the sequence number of the j-th base in the base pair.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getJ_label_seq_id() 
	{
		return j_label_seq_id;
	}
 
	public void setJ_label_seq_id(java.lang.Integer j_label_seq_id)
	{
		this.j_label_seq_id = j_label_seq_id;
	}

 	protected java.lang.String j_symmetry;


	/**
	 *  Describes the symmetry operation that should be applied to the
	 *  coordinates of the j-th base to generate the second partner
	 *  in the base pair.
	 *  no symmetry or translation to site
	 *  4th symmetry operation applied
	 *  4
	 *  7th symm. posn.; +a on x; -b on y
	 *  7_645
	 */
	public java.lang.String getJ_symmetry() 
	{
		return j_symmetry;
	}
 
	public void setJ_symmetry(java.lang.String j_symmetry)
	{
		this.j_symmetry = j_symmetry;
	}

 	protected java.lang.Integer model_number;


	/**
	 *  Describes the model number of the the base pair.
	 *  
	 *  This data item is a pointer to  attribute pdbx_PDB_model_num in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getModel_number() 
	{
		return model_number;
	}
 
	public void setModel_number(java.lang.Integer model_number)
	{
		this.model_number = model_number;
	}

 	protected java.lang.Float opening;


	/**
	 *  The value of the base pair opening parameter.
	 */
	public java.lang.Float getOpening() 
	{
		return opening;
	}
 
	public void setOpening(java.lang.Float opening)
	{
		this.opening = opening;
	}

 	protected java.lang.String pair_name;


	/**
	 *  Text label for this base pair.
	 */
	public java.lang.String getPair_name() 
	{
		return pair_name;
	}
 
	public void setPair_name(java.lang.String pair_name)
	{
		this.pair_name = pair_name;
	}

 	protected java.lang.Integer pair_number;


	/**
	 *  Sequential number of pair in the pair sequence.
	 */
	public java.lang.Integer getPair_number() 
	{
		return pair_number;
	}
 
	public void setPair_number(java.lang.Integer pair_number)
	{
		this.pair_number = pair_number;
	}

 	protected java.lang.Float propeller;


	/**
	 *  The value of the base pair propeller parameter.
	 */
	public java.lang.Float getPropeller() 
	{
		return propeller;
	}
 
	public void setPropeller(java.lang.Float propeller)
	{
		this.propeller = propeller;
	}

 	protected java.lang.Float shear;


	/**
	 *  The value of the base pair shear parameter.
	 */
	public java.lang.Float getShear() 
	{
		return shear;
	}
 
	public void setShear(java.lang.Float shear)
	{
		this.shear = shear;
	}

 	protected java.lang.Float stagger;


	/**
	 *  The value of the base pair stagger parameter.
	 */
	public java.lang.Float getStagger() 
	{
		return stagger;
	}
 
	public void setStagger(java.lang.Float stagger)
	{
		this.stagger = stagger;
	}

 	protected java.lang.Float stretch;


	/**
	 *  The value of the base pair stretch parameter.
	 */
	public java.lang.Float getStretch() 
	{
		return stretch;
	}
 
	public void setStretch(java.lang.Float stretch)
	{
		this.stretch = stretch;
	}

 }
