package org.pdb.beans;

/**
 *  Data items in the PDBX_AUDIT_AUTHOR category record details about
 *  the author(s) of the data block.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP
 *  <PDBx:pdbx_audit_authorCategory>
 *  <PDBx:pdbx_audit_author ordinal="1">
 *  <PDBx:name>Fitzgerald, Paula M.D.</PDBx:name>
 *  <PDBx:address> Department of Biophysical Chemistry
 *  Merck Research Laboratories
 *  P. O. Box 2000, Ry80M203
 *  Rahway, New Jersey  07065
 *  USA</PDBx:address>
 *  </PDBx:pdbx_audit_author>
 *  <PDBx:pdbx_audit_author ordinal="2">
 *  <PDBx:name>McKeever, Brian M.</PDBx:name>
 *  <PDBx:address> Department of Biophysical Chemistry
 *  Merck Research Laboratories
 *  P. O. Box 2000, Ry80M203
 *  Rahway, New Jersey  07065
 *  USA</PDBx:address>
 *  </PDBx:pdbx_audit_author>
 *  <PDBx:pdbx_audit_author ordinal="3">
 *  <PDBx:name>Van Middlesworth, J.F.</PDBx:name>
 *  <PDBx:address> Department of Biophysical Chemistry
 *  Merck Research Laboratories
 *  P. O. Box 2000, Ry80M203
 *  Rahway, New Jersey  07065
 *  USA</PDBx:address>
 *  </PDBx:pdbx_audit_author>
 *  <PDBx:pdbx_audit_author ordinal="4">
 *  <PDBx:name>Springer, James P.</PDBx:name>
 *  <PDBx:address> Department of Biophysical Chemistry
 *  Merck Research Laboratories
 *  P. O. Box 2000, Ry80M203
 *  Rahway, New Jersey  07065
 *  USA</PDBx:address>
 *  </PDBx:pdbx_audit_author>
 *  </PDBx:pdbx_audit_authorCategory>
 * </pre>
 */
public class Pdbx_audit_author 
{
		protected java.lang.String address;


	/**
	 *  The address of an author of this data block. If there are
	 *  multiple authors,  attribute address in category pdbx_audit_author is looped with
	 *  attribute name in category pdbx_audit_author.
	 *  Department
	 *  Institute
	 *  Street
	 *  City and postcode
	 *  COUNTRY
	 */
	public java.lang.String getAddress() 
	{
		return address;
	}
 
	public void setAddress(java.lang.String address)
	{
		this.address = address;
	}

 	protected java.lang.String name;


	/**
	 *  The name of an author of this data block. If there are multiple
	 *  authors, _pdbx_audit_author.name is looped with _pdbx_audit_author.address.
	 *  The family name(s), followed by a comma and including any
	 *  dynastic compoents, precedes the first name(s) or initial(s).
	 *  Bleary, Percival R.
	 *  O'Neil, F.K.
	 *  Van den Bossche, G.
	 *  Yang, D.-L.
	 *  Simonov, Yu.A
	 */
	public java.lang.String getName() 
	{
		return name;
	}
 
	public void setName(java.lang.String name)
	{
		this.name = name;
	}

 	protected java.lang.Integer ordinal;


	/**
	 *  A unique sequential integer identifier for each author.
	 *  1
	 *  2
	 *  3
	 */
	public java.lang.Integer getOrdinal() 
	{
		return ordinal;
	}
 
	public void setOrdinal(java.lang.Integer ordinal)
	{
		this.ordinal = ordinal;
	}

 }
