package org.pdb.beans;

/**
 *  Constituents of buffer in sample
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:pdbx_buffer_componentsCategory>
 *  <PDBx:pdbx_buffer_components buffer_id="1" id="1">
 *  <PDBx:name>NaCl</PDBx:name>
 *  <PDBx:volume>0.200 </PDBx:volume>
 *  <PDBx:conc>4 </PDBx:conc>
 *  </PDBx:pdbx_buffer_components>
 *  <PDBx:pdbx_buffer_components buffer_id="1" id="2">
 *  <PDBx:name>Acetic Acid</PDBx:name>
 *  <PDBx:volume>0.047 </PDBx:volume>
 *  <PDBx:conc>100</PDBx:conc>
 *  </PDBx:pdbx_buffer_components>
 *  <PDBx:pdbx_buffer_components buffer_id="1" id="3">
 *  <PDBx:name>water</PDBx:name>
 *  <PDBx:volume>0.700 </PDBx:volume>
 *  <PDBx:conc>neat</PDBx:conc>
 *  </PDBx:pdbx_buffer_components>
 *  </PDBx:pdbx_buffer_componentsCategory>
 * </pre>
 */
public class Pdbx_buffer_components 
{
		protected java.lang.String buffer_id;


	/**
	 *  This data item is a pointer to  attribute id in category pdbx_buffer in the BUFFER category.
	 */
	public java.lang.String getBuffer_id() 
	{
		return buffer_id;
	}
 
	public void setBuffer_id(java.lang.String buffer_id)
	{
		this.buffer_id = buffer_id;
	}

 	protected java.lang.String conc;


	/**
	 *  The millimolar concentration of buffer component.
	 *  200
	 */
	public java.lang.String getConc() 
	{
		return conc;
	}
 
	public void setConc(java.lang.String conc)
	{
		this.conc = conc;
	}

 	protected java.lang.String conc_units;


	/**
	 *  The concentration units of the component.
	 *  mg/mL for mg per milliliter
	 *  mM for millimolar
	 *  % for percent by volume
	 */
	public java.lang.String getConc_units() 
	{
		return conc_units;
	}
 
	public void setConc_units(java.lang.String conc_units)
	{
		this.conc_units = conc_units;
	}

 	protected java.lang.String details;


	/**
	 *  Any additional details to do with buffer composition.
	 *  pH adjusted with NaOH
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category pdbx_buffer_components must
	 *  uniquely identify a component of the buffer.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String isotopic_labeling;


	/**
	 *  The isotopic composition of each component, including
	 *  the % labeling level, if known. For example:
	 *  1. Uniform (random) labeling with 15N: U-15N
	 *  2. Uniform (random) labeling with 13C, 15N at known labeling
	 *  levels: U-95% 13C;U-98% 15N
	 *  3. Residue selective labeling: U-95% 15N-Thymine
	 *  4. Site specific labeling: 95% 13C-Ala18,
	 *  5. Natural abundance labeling in an otherwise uniformly labled
	 *  biomolecule is designated by NA: U-13C; NA-K,H
	 *  U-15N
	 *  U-13C
	 *  U-15N,13C
	 *  U-2H
	 *  other
	 */
	public java.lang.String getIsotopic_labeling() 
	{
		return isotopic_labeling;
	}
 
	public void setIsotopic_labeling(java.lang.String isotopic_labeling)
	{
		this.isotopic_labeling = isotopic_labeling;
	}

 	protected java.lang.String name;


	/**
	 *  The name of each buffer component.
	 *  Acetic acid
	 */
	public java.lang.String getName() 
	{
		return name;
	}
 
	public void setName(java.lang.String name)
	{
		this.name = name;
	}

 	protected java.lang.String volume;


	/**
	 *  The volume of buffer component.
	 *  0.200
	 */
	public java.lang.String getVolume() 
	{
		return volume;
	}
 
	public void setVolume(java.lang.String volume)
	{
		this.volume = volume;
	}

 }
