package org.pdb.beans;

/**
 *  Data items in the PDBX_CHEM_COMP_BOND_EDIT category provide
 *  bond level editing instructions to be applied to imported
 *  chemical components.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_chem_comp_bond_editCategory>
 *  <PDBx:pdbx_chem_comp_bond_edit comp_id="LYS" edit_op="DELETE" atom_id_1="OXT" atom_id_2="HXT">
 *  <PDBx:ordinal>1</PDBx:ordinal>
 *  </PDBx:pdbx_chem_comp_bond_edit>
 *  </PDBx:pdbx_chem_comp_bond_editCategory>
 * </pre>
 */
public class Pdbx_chem_comp_bond_edit 
{
		protected java.lang.String atom_id_1;


	/**
	 *  The identifier for the first atom in the target bond
	 *  in imported component.
	 */
	public java.lang.String getAtom_id_1() 
	{
		return atom_id_1;
	}
 
	public void setAtom_id_1(java.lang.String atom_id_1)
	{
		this.atom_id_1 = atom_id_1;
	}

 	protected java.lang.String atom_id_2;


	/**
	 *  The identifier for the second atom in the target bond
	 *  in imported component.
	 */
	public java.lang.String getAtom_id_2() 
	{
		return atom_id_2;
	}
 
	public void setAtom_id_2(java.lang.String atom_id_2)
	{
		this.atom_id_2 = atom_id_2;
	}

 	protected java.lang.String comp_id;


	/**
	 *  This data item is a pointer to  attribute comp_id in category pdbx_chem_comp_import in the CHEM_COMP
	 *  category.
	 */
	public java.lang.String getComp_id() 
	{
		return comp_id;
	}
 
	public void setComp_id(java.lang.String comp_id)
	{
		this.comp_id = comp_id;
	}

 	protected java.lang.String edit_bond_value;


	/**
	 *  The value for the edited bond property value in the generated component.
	 */
	public java.lang.String getEdit_bond_value() 
	{
		return edit_bond_value;
	}
 
	public void setEdit_bond_value(java.lang.String edit_bond_value)
	{
		this.edit_bond_value = edit_bond_value;
	}

 	protected java.lang.String edit_op;


	/**
	 *  The operation or assignment applied to the named imported component.
	 */
	public java.lang.String getEdit_op() 
	{
		return edit_op;
	}
 
	public void setEdit_op(java.lang.String edit_op)
	{
		this.edit_op = edit_op;
	}

 	protected java.lang.Integer ordinal;


	/**
	 *  This data item uniquely identifies and orders each bond edit instruction.
	 */
	public java.lang.Integer getOrdinal() 
	{
		return ordinal;
	}
 
	public void setOrdinal(java.lang.Integer ordinal)
	{
		this.ordinal = ordinal;
	}

 }
