package org.pdb.beans;

/**
 *  Data items in the PDBX_CONSTRUCT_FEATURE category may be used to
 *  specify various properties of a nucleic acid sequence used during
 *  protein production.
 *  
 * <pre>
 *  Example 1 - vector pUC28
 *  <PDBx:pdbx_construct_featureCategory>
 *  <PDBx:pdbx_construct_feature id="1" construct_id="1">
 *  <PDBx:entry_id>111000111</PDBx:entry_id>
 *  <PDBx:details>pKK84-1 ClaI 5260bp 5247..5247 ptac11 TaqI-TaqI 192bp, -35 trp promoter -&gt; pEA300 5452bp</PDBx:details>
 *  </PDBx:pdbx_construct_feature>
 *  <PDBx:pdbx_construct_feature id="2" construct_id="1">
 *  <PDBx:entry_id>111000111</PDBx:entry_id>
 *  <PDBx:details>pKK84-1 1..5246 5246bp ClaI = AT^CGAT TaqI =  T^CGA cgact...</PDBx:details>
 *  </PDBx:pdbx_construct_feature>
 *  <PDBx:pdbx_construct_feature id="3" construct_id="1">
 *  <PDBx:entry_id>111000111</PDBx:entry_id>
 *  <PDBx:start_seq>5247</PDBx:start_seq>
 *  <PDBx:end_seq>5436</PDBx:end_seq>
 *  <PDBx:details>ptac11 190bp ...cat TaqI =  T^CGA ClaI = AT^CGAT</PDBx:details>
 *  </PDBx:pdbx_construct_feature>
 *  <PDBx:pdbx_construct_feature id="4" construct_id="1">
 *  <PDBx:entry_id>111000111</PDBx:entry_id>
 *  <PDBx:start_seq>5437</PDBx:start_seq>
 *  <PDBx:end_seq>5450</PDBx:end_seq>
 *  <PDBx:details>pKK84-1 5247..5260 14bp</PDBx:details>
 *  </PDBx:pdbx_construct_feature>
 *  <PDBx:pdbx_construct_feature id="5" construct_id="1">
 *  <PDBx:entry_id>111000111</PDBx:entry_id>
 *  <PDBx:type>misc_binding</PDBx:type>
 *  <PDBx:details>SIT unique EcoRI-ClaI-HindIII-BamHI-PvuII</PDBx:details>
 *  </PDBx:pdbx_construct_feature>
 *  <PDBx:pdbx_construct_feature id="6" construct_id="1">
 *  <PDBx:entry_id>111000111</PDBx:entry_id>
 *  <PDBx:type>rep_origin</PDBx:type>
 *  <PDBx:details>ORI E. coli pMB1 (ColE1 and pBR322)</PDBx:details>
 *  </PDBx:pdbx_construct_feature>
 *  <PDBx:pdbx_construct_feature id="7" construct_id="1">
 *  <PDBx:entry_id>111000111</PDBx:entry_id>
 *  <PDBx:type>promoter</PDBx:type>
 *  <PDBx:details>PRO E. coli trp</PDBx:details>
 *  </PDBx:pdbx_construct_feature>
 *  <PDBx:pdbx_construct_feature id="8" construct_id="1">
 *  <PDBx:entry_id>111000111</PDBx:entry_id>
 *  <PDBx:type>CDS</PDBx:type>
 *  <PDBx:details>ANT E. coli beta-lactamase gene (bla) ampicillin resistance gene (apr/amp)</PDBx:details>
 *  </PDBx:pdbx_construct_feature>
 *  </PDBx:pdbx_construct_featureCategory>
 * </pre>
 */
public class Pdbx_construct_feature 
{
		protected java.lang.String construct_id;


	/**
	 *  The value of  attribute construct_id in category pdbx_construct_feature uniquely
	 *  identifies the construct with which the feature is
	 *  associated. This is a pointer to  attribute id
	 *  in category pdbx_construct This item may be a site dependent bar code.
	 */
	public java.lang.String getConstruct_id() 
	{
		return construct_id;
	}
 
	public void setConstruct_id(java.lang.String construct_id)
	{
		this.construct_id = construct_id;
	}

 	protected java.lang.String details;


	/**
	 *  Details that describe the feature
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.Integer end_seq;


	/**
	 *  The sequence position at which the feature ends
	 */
	public java.lang.Integer getEnd_seq() 
	{
		return end_seq;
	}
 
	public void setEnd_seq(java.lang.Integer end_seq)
	{
		this.end_seq = end_seq;
	}

 	protected java.lang.String entry_id;


	/**
	 *  The value of  attribute entry_id in category pdbx_construct_feature uniquely identifies
	 *  a sample consisting of one or more proteins whose structure is
	 *  to be determined. This is a pointer to  attribute id in category entry.  This item may
	 *  be a site dependent bar code.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category pdbx_construct_feature must uniquely
	 *  identify a record in the PDBX_CONSTRUCT_FEATURE list.
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Integer start_seq;


	/**
	 *  The sequence position at which the feature begins
	 */
	public java.lang.Integer getStart_seq() 
	{
		return start_seq;
	}
 
	public void setStart_seq(java.lang.Integer start_seq)
	{
		this.start_seq = start_seq;
	}

 	protected java.lang.String type;


	/**
	 *  The type of the feature
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 }
