package org.pdb.beans;

/**
 *  Data items in PDBX_DATABASE_RELATED contain references to entries
 *  that are related to the this entry.
 *  <PDBx:pdbx_database_relatedCategory>
 *  <PDBx:pdbx_database_related db_name="PDB" db_id="1ABC"></PDBx:pdbx_database_related>
 *  </PDBx:pdbx_database_relatedCategory>
 */
public class Pdbx_database_related 
{
		protected java.lang.String content_type;


	/**
	 *  The identifying content type of the related entry.
	 *  minimized average structure
	 *  representative structure
	 *  ensemble
	 *  derivative structure
	 *  native structure
	 *  associated EM volume
	 *  associated NMR restraints
	 *  associated structure factors
	 *  protein target sequence and/or protocol data
	 *  other
	 */
	public java.lang.String getContent_type() 
	{
		return content_type;
	}
 
	public void setContent_type(java.lang.String content_type)
	{
		this.content_type = content_type;
	}

 	protected java.lang.String db_id;


	/**
	 *  The identifying code in the related database.
	 *  1ABC
	 *  BDL001
	 */
	public java.lang.String getDb_id() 
	{
		return db_id;
	}
 
	public void setDb_id(java.lang.String db_id)
	{
		this.db_id = db_id;
	}

 	protected java.lang.String db_name;


	/**
	 *  The name of the database containing the related entry.
	 *  
	 *  PDB  - Protein Databank
	 *  NDB  - Nucleic Acid Database
	 *  BMRB - BioMagResBank
	 *  EMDB - Electron Microscopy Database
	 *  BMCD - Biological Macromolecule Crystallization Database
	 *  TARGETDB -  Target Registration Database
	 *  PEPCDB   -  Protein Expression Purification and Crystalization Database
	 */
	public java.lang.String getDb_name() 
	{
		return db_name;
	}
 
	public void setDb_name(java.lang.String db_name)
	{
		this.db_name = db_name;
	}

 	protected java.lang.String details;


	/**
	 *  A description of the related entry.
	 *  
	 *  1ABC contains the same protein complexed with Netropsin.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 }
