package org.pdb.beans;

/**
 *  Data items in the PDBX_DATABASE_REMARK category record keep additional
 *  information about the entry.  They are mostly used to create
 *  'non-standard' PDB REMARK annotations (6-99).
 *  
 * <pre>
 *  Example 1 - based on PDB entry 1ABC
 *  <PDBx:pdbx_database_remarkCategory>
 *  <PDBx:pdbx_database_remark id="1">
 *  <PDBx:text> THE NON-CRYSTALLOGRAPHIC RELATIONSHIP BETWEEN THE THREE
 *  DOUBLE HELICES IN THE ASYMMETRIC UNIT IS DESCRIBED
 *  IN THE MTRIX1-3 RECORDS.</PDBx:text>
 *  </PDBx:pdbx_database_remark>
 *  </PDBx:pdbx_database_remarkCategory>
 * </pre>
 */
public class Pdbx_database_remark 
{
		protected java.lang.Integer id_;


	/**
	 *  A unique identifier for the PDB remark record.
	 */
	public java.lang.Integer getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.Integer id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String text;


	/**
	 *  The full text of the PDB remark record.
	 */
	public java.lang.String getText() 
	{
		return text;
	}
 
	public void setText(java.lang.String text)
	{
		this.text = text;
	}

 }
