package org.pdb.beans;

/**
 *  These are internal RCSB records to keep track of data processing
 *  and status of the entry.
 *  <PDBx:pdbx_database_statusCategory>
 *  <PDBx:pdbx_database_status entry_id="1ABC">
 *  <PDBx:status_code>REL</PDBx:status_code>
 *  <PDBx:deposit_site>RCSB</PDBx:deposit_site>
 *  <PDBx:process_site>RCSB</PDBx:process_site>
 *  </PDBx:pdbx_database_status>
 *  </PDBx:pdbx_database_statusCategory>
 */
public class Pdbx_database_status 
{
		protected java.lang.String SG_entry;


	/**
	 *  This code indicates whether the entry belongs to
	 *  Structural Genomics Project.
	 *  Y
	 */
	public java.lang.String getSG_entry() 
	{
		return SG_entry;
	}
 
	public void setSG_entry(java.lang.String SG_entry)
	{
		this.SG_entry = SG_entry;
	}

 	protected java.lang.String author_approval_type;


	/**
	 *  This code indicates whether the author's approval for
	 *  an entry was received explicitly or implicitly.  The
	 *  latter is automatically implied by failure to respond
	 *  to the validation summary within the prescribed period.
	 *  
	 *  implicit = automatic approval by failure to acknowledge
	 *  explicit = approval via depositor acknowledgement
	 */
	public java.lang.String getAuthor_approval_type() 
	{
		return author_approval_type;
	}
 
	public void setAuthor_approval_type(java.lang.String author_approval_type)
	{
		this.author_approval_type = author_approval_type;
	}

 	protected java.lang.String author_release_status_code;


	/**
	 *  The release status authorized by the depositor.
	 *  
	 *  REL   = Release
	 *  HOLD  = On hold until yyyy-mm-dd
	 *  HPUB  = On hold until publication
	 *  OBS   = Entry has been obsoleted and replaced by another entry
	 *  WDRN  = Entry has been withdrawn by depositor
	 */
	public java.lang.String getAuthor_release_status_code() 
	{
		return author_release_status_code;
	}
 
	public void setAuthor_release_status_code(java.lang.String author_release_status_code)
	{
		this.author_release_status_code = author_release_status_code;
	}

 	protected java.lang.String date_author_approval;


	/**
	 *  The date the author's approval is received.
	 *  1983-02-20
	 */
	public java.lang.String getDate_author_approval() 
	{
		return date_author_approval;
	}
 
	public void setDate_author_approval(java.lang.String date_author_approval)
	{
		this.date_author_approval = date_author_approval;
	}

 	protected java.lang.String date_coordinates;


	/**
	 *  The date the coordinates are received.
	 *  1983-02-21
	 */
	public java.lang.String getDate_coordinates() 
	{
		return date_coordinates;
	}
 
	public void setDate_coordinates(java.lang.String date_coordinates)
	{
		this.date_coordinates = date_coordinates;
	}

 	protected java.lang.String date_deposition_form;


	/**
	 *  The date the deposition form is received.
	 *  1982-02-21
	 */
	public java.lang.String getDate_deposition_form() 
	{
		return date_deposition_form;
	}
 
	public void setDate_deposition_form(java.lang.String date_deposition_form)
	{
		this.date_deposition_form = date_deposition_form;
	}

 	protected java.lang.String date_hold_coordinates;


	/**
	 *  At an author's request, a coordinate entry may be held after
	 *  processing for some period of time.
	 *  1983-02-28
	 */
	public java.lang.String getDate_hold_coordinates() 
	{
		return date_hold_coordinates;
	}
 
	public void setDate_hold_coordinates(java.lang.String date_hold_coordinates)
	{
		this.date_hold_coordinates = date_hold_coordinates;
	}

 	protected java.lang.String date_hold_nmr_constraints;


	/**
	 *  At an author's request, the NMR constraint data may be held after
	 *  processing for some period of time.
	 *  1983-02-28
	 */
	public java.lang.String getDate_hold_nmr_constraints() 
	{
		return date_hold_nmr_constraints;
	}
 
	public void setDate_hold_nmr_constraints(java.lang.String date_hold_nmr_constraints)
	{
		this.date_hold_nmr_constraints = date_hold_nmr_constraints;
	}

 	protected java.lang.String date_hold_struct_fact;


	/**
	 *  At an author's request, the structure factors may be held after
	 *  processing for some period of time.
	 *  1983-02-28
	 */
	public java.lang.String getDate_hold_struct_fact() 
	{
		return date_hold_struct_fact;
	}
 
	public void setDate_hold_struct_fact(java.lang.String date_hold_struct_fact)
	{
		this.date_hold_struct_fact = date_hold_struct_fact;
	}

 	protected java.lang.String date_manuscript;


	/**
	 *  The date the manuscript is received.
	 *  1983-02-28
	 */
	public java.lang.String getDate_manuscript() 
	{
		return date_manuscript;
	}
 
	public void setDate_manuscript(java.lang.String date_manuscript)
	{
		this.date_manuscript = date_manuscript;
	}

 	protected java.lang.String date_nmr_constraints;


	/**
	 *  The date the structure factors are received.
	 *  1983-02-28
	 */
	public java.lang.String getDate_nmr_constraints() 
	{
		return date_nmr_constraints;
	}
 
	public void setDate_nmr_constraints(java.lang.String date_nmr_constraints)
	{
		this.date_nmr_constraints = date_nmr_constraints;
	}

 	protected java.lang.String date_of_PDB_release;


	/**
	 *  PDB release date.  This is the date that appears in the PDB
	 *  REVDAT record.
	 *  
	 *  1983-02-28
	 */
	public java.lang.String getDate_of_PDB_release() 
	{
		return date_of_PDB_release;
	}
 
	public void setDate_of_PDB_release(java.lang.String date_of_PDB_release)
	{
		this.date_of_PDB_release = date_of_PDB_release;
	}

 	protected java.util.Date date_of_mr_release;


	/**
	 *  The date of PDB/RCSB release.  This corresponds to the date
	 *  at which the entry is placed into the public archive.
	 *  1999-02-28
	 */
	public java.util.Date getDate_of_mr_release() 
	{
		return date_of_mr_release;
	}
 
	public void setDate_of_mr_release(java.util.Date date_of_mr_release)
	{
		this.date_of_mr_release = date_of_mr_release;
	}

 	protected java.util.Date date_of_sf_release;


	/**
	 *  The date of PDB/RCSB release.  This corresponds to the date
	 *  at which the entry is placed into the public archive.
	 *  1999-02-28
	 */
	public java.util.Date getDate_of_sf_release() 
	{
		return date_of_sf_release;
	}
 
	public void setDate_of_sf_release(java.util.Date date_of_sf_release)
	{
		this.date_of_sf_release = date_of_sf_release;
	}

 	protected java.lang.String date_struct_fact;


	/**
	 *  The date the structure factors are received.
	 *  1983-02-28
	 */
	public java.lang.String getDate_struct_fact() 
	{
		return date_struct_fact;
	}
 
	public void setDate_struct_fact(java.lang.String date_struct_fact)
	{
		this.date_struct_fact = date_struct_fact;
	}

 	protected java.lang.String date_submitted;


	/**
	 *  The date of complete deposition.  This corresponds to the date
	 *  at which the PDB identifier is assigned.
	 *  1983-02-20
	 */
	public java.lang.String getDate_submitted() 
	{
		return date_submitted;
	}
 
	public void setDate_submitted(java.lang.String date_submitted)
	{
		this.date_submitted = date_submitted;
	}

 	protected java.lang.String dep_release_code_coordinates;


	/**
	 *  The deposited coordinates for this deposition will be released according
	 *  the value of this item.
	 *  
	 *  RELEASE NOW          =    Release immediately
	 *  HOLD FOR PUBLICATION =    Hold until the primary citation is published
	 *  HOLD FOR 4 WEEKS     =    Hold for 4 weeks
	 *  HOLD FOR 6 WEEKS     =    Hold for 6 weeks
	 *  HOLD FOR 8 WEEKS     =    Hold for 8 weeks
	 *  HOLD FOR 6 MONTHS    =    Hold for 6 months
	 *  HOLD FOR 1 YEAR      =    Hold for 1 year
	 */
	public java.lang.String getDep_release_code_coordinates() 
	{
		return dep_release_code_coordinates;
	}
 
	public void setDep_release_code_coordinates(java.lang.String dep_release_code_coordinates)
	{
		this.dep_release_code_coordinates = dep_release_code_coordinates;
	}

 	protected java.lang.String dep_release_code_nmr_constraints;


	/**
	 *  The deposited NMR constrait data for this deposition will be released according
	 *  the value of this item.
	 *  
	 *  RELEASE NOW          =    Release immediately
	 *  HOLD FOR PUBLICATION =    Hold until the primary citation is published
	 *  HOLD FOR 6 WEEKS     =    Hold for 6 weeks
	 *  HOLD FOR 6 MONTHS    =    Hold for 6 months
	 *  HOLD FOR 1 YEAR      =    Hold for 1 year
	 */
	public java.lang.String getDep_release_code_nmr_constraints() 
	{
		return dep_release_code_nmr_constraints;
	}
 
	public void setDep_release_code_nmr_constraints(java.lang.String dep_release_code_nmr_constraints)
	{
		this.dep_release_code_nmr_constraints = dep_release_code_nmr_constraints;
	}

 	protected java.lang.String dep_release_code_sequence;


	/**
	 *  The sequence information for this deposition will be released according
	 *  the value of this item.  Setting this status code to "RELEASE NOW" indicates
	 *  that the macromolecular sequence(s) for this entry may be displayed in PDB
	 *  status reports prior to the release of the entry.   Setting this status
	 *  code to "HOLD FOR RELEASE" conceals the sequence information in PDB status
	 *  reports until the coordinate data for this entry are released.
	 *  
	 *  RELEASE NOW =      Release sequence information in status reports immediately
	 *  HOLD FOR RELEASE = Conceal sequence information in status reports until
	 *  coordinate data is release
	 */
	public java.lang.String getDep_release_code_sequence() 
	{
		return dep_release_code_sequence;
	}
 
	public void setDep_release_code_sequence(java.lang.String dep_release_code_sequence)
	{
		this.dep_release_code_sequence = dep_release_code_sequence;
	}

 	protected java.lang.String dep_release_code_struct_fact;


	/**
	 *  The deposited structure factors for this deposition will be released according
	 *  the value of this item.
	 *  
	 *  RELEASE NOW          =    Release immediately
	 *  HOLD FOR PUBLICATION =    Hold until the primary citation is published
	 *  HOLD FOR 4 WEEKS     =    Hold for 4 weeks
	 *  HOLD FOR 6 WEEKS     =    Hold for 6 weeks
	 *  HOLD FOR 6 MONTHS    =    Hold for 6 months
	 *  HOLD FOR 1 YEAR      =    Hold for 1 year
	 */
	public java.lang.String getDep_release_code_struct_fact() 
	{
		return dep_release_code_struct_fact;
	}
 
	public void setDep_release_code_struct_fact(java.lang.String dep_release_code_struct_fact)
	{
		this.dep_release_code_struct_fact = dep_release_code_struct_fact;
	}

 	protected java.lang.String deposit_site;


	/**
	 *  The site where the file was deposited.
	 *  
	 *  NDB
	 *  RCSB
	 *  PDB
	 *  EBI
	 *  OSAKA
	 *  BMRB
	 *  BNL
	 */
	public java.lang.String getDeposit_site() 
	{
		return deposit_site;
	}
 
	public void setDeposit_site(java.lang.String deposit_site)
	{
		this.deposit_site = deposit_site;
	}

 	protected java.lang.String entry_id;


	/**
	 *  The value of  attribute entry_id in category pdbx_database_status identifies the data block.
	 *  
	 *  BDL001
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String hold_for_publication;


	/**
	 *  At an author's request, an entry is to be held until
	 *  publication.
	 *  Y
	 */
	public java.lang.String getHold_for_publication() 
	{
		return hold_for_publication;
	}
 
	public void setHold_for_publication(java.lang.String hold_for_publication)
	{
		this.hold_for_publication = hold_for_publication;
	}

 	protected java.lang.String name_depositor;


	/**
	 *  The last name of the depositor to be used in correspondance.
	 *  
	 *  Smith
	 */
	public java.lang.String getName_depositor() 
	{
		return name_depositor;
	}
 
	public void setName_depositor(java.lang.String name_depositor)
	{
		this.name_depositor = name_depositor;
	}

 	protected java.lang.String pdb_date_of_author_approval;


	/**
	 *  This is the date when PDB received the author's approval for an
	 *  entry which has been processed by NDB.  (This is a place holder
	 *  for entries processed before Jan. 1, 1996.)
	 *  
	 *  1983-02-27
	 */
	public java.lang.String getPdb_date_of_author_approval() 
	{
		return pdb_date_of_author_approval;
	}
 
	public void setPdb_date_of_author_approval(java.lang.String pdb_date_of_author_approval)
	{
		this.pdb_date_of_author_approval = pdb_date_of_author_approval;
	}

 	protected java.lang.String process_site;


	/**
	 *  The site where the file was deposited.
	 *  
	 *  NDB
	 *  RCSB
	 *  EBI
	 *  OSAKA
	 *  PDB
	 *  PRAGUE
	 */
	public java.lang.String getProcess_site() 
	{
		return process_site;
	}
 
	public void setProcess_site(java.lang.String process_site)
	{
		this.process_site = process_site;
	}

 	protected java.lang.String rcsb_annotator;


	/**
	 *  The initials of the annotator processing this entry.
	 *  BS
	 *  SJ
	 *  KB
	 */
	public java.lang.String getRcsb_annotator() 
	{
		return rcsb_annotator;
	}
 
	public void setRcsb_annotator(java.lang.String rcsb_annotator)
	{
		this.rcsb_annotator = rcsb_annotator;
	}

 	protected java.lang.String recvd_author_approval;


	/**
	 *  This code indicates whether the author's approval for
	 *  an entry has been received.
	 *  Y
	 */
	public java.lang.String getRecvd_author_approval() 
	{
		return recvd_author_approval;
	}
 
	public void setRecvd_author_approval(java.lang.String recvd_author_approval)
	{
		this.recvd_author_approval = recvd_author_approval;
	}

 	protected java.lang.String recvd_coordinates;


	/**
	 *  This code indicates whether the coordinates for an entry
	 *  have been received.
	 *  Y
	 */
	public java.lang.String getRecvd_coordinates() 
	{
		return recvd_coordinates;
	}
 
	public void setRecvd_coordinates(java.lang.String recvd_coordinates)
	{
		this.recvd_coordinates = recvd_coordinates;
	}

 	protected java.lang.String recvd_deposit_form;


	/**
	 *  This code indicates whether the deposition form for an entry
	 *  has been received.
	 *  Y
	 */
	public java.lang.String getRecvd_deposit_form() 
	{
		return recvd_deposit_form;
	}
 
	public void setRecvd_deposit_form(java.lang.String recvd_deposit_form)
	{
		this.recvd_deposit_form = recvd_deposit_form;
	}

 	protected java.lang.String recvd_initial_deposition_date;


	/**
	 *  The date of initial deposition.  (The first message for
	 *  deposition has been received.)
	 *  1983-02-21
	 */
	public java.lang.String getRecvd_initial_deposition_date() 
	{
		return recvd_initial_deposition_date;
	}
 
	public void setRecvd_initial_deposition_date(java.lang.String recvd_initial_deposition_date)
	{
		this.recvd_initial_deposition_date = recvd_initial_deposition_date;
	}

 	protected java.lang.String recvd_internal_approval;


	/**
	 *  This code indicates whether the internal approval for an entry
	 *  have been received.
	 *  Y
	 */
	public java.lang.String getRecvd_internal_approval() 
	{
		return recvd_internal_approval;
	}
 
	public void setRecvd_internal_approval(java.lang.String recvd_internal_approval)
	{
		this.recvd_internal_approval = recvd_internal_approval;
	}

 	protected java.lang.String recvd_manuscript;


	/**
	 *  This code indicates whether the manuscript for an entry
	 *  has been received.
	 *  Y
	 */
	public java.lang.String getRecvd_manuscript() 
	{
		return recvd_manuscript;
	}
 
	public void setRecvd_manuscript(java.lang.String recvd_manuscript)
	{
		this.recvd_manuscript = recvd_manuscript;
	}

 	protected java.lang.String recvd_nmr_constraints;


	/**
	 *  This code indicates whether the NMR contraint data for an entry
	 *  have been received.
	 *  Y
	 */
	public java.lang.String getRecvd_nmr_constraints() 
	{
		return recvd_nmr_constraints;
	}
 
	public void setRecvd_nmr_constraints(java.lang.String recvd_nmr_constraints)
	{
		this.recvd_nmr_constraints = recvd_nmr_constraints;
	}

 	protected java.lang.String recvd_struct_fact;


	/**
	 *  This code indicates whether the structure factors for an entry
	 *  have been received.
	 *  Y
	 */
	public java.lang.String getRecvd_struct_fact() 
	{
		return recvd_struct_fact;
	}
 
	public void setRecvd_struct_fact(java.lang.String recvd_struct_fact)
	{
		this.recvd_struct_fact = recvd_struct_fact;
	}

 	protected java.lang.String status_code;


	/**
	 *  Code for status of file.
	 *  REL
	 *  HPUB
	 */
	public java.lang.String getStatus_code() 
	{
		return status_code;
	}
 
	public void setStatus_code(java.lang.String status_code)
	{
		this.status_code = status_code;
	}

 	protected java.lang.String status_code_mr;


	/**
	 *  Code for status of NMR constraints file.
	 *  
	 *  PROC  = To be processed
	 *  REL   = Release
	 *  HOLD  = On hold until yyyy-mm-dd
	 *  HPUB  = On hold until publication
	 *  OBS   = Entry has been obsoleted and replaced by another entry
	 *  WDRN  = Entry has been withdrawn by depositor
	 *  WAIT  = Awaiting author approval
	 */
	public java.lang.String getStatus_code_mr() 
	{
		return status_code_mr;
	}
 
	public void setStatus_code_mr(java.lang.String status_code_mr)
	{
		this.status_code_mr = status_code_mr;
	}

 	protected java.lang.String status_code_sf;


	/**
	 *  Code for status of structure factor file.
	 *  
	 *  PROC  = To be processed
	 *  REL   = Released
	 *  HOLD  = On hold until yyyy-mm-dd
	 *  HPUB  = On hold until publication
	 *  OBS   = Entry has been obsoleted and replaced by another entry
	 *  WDRN  = Entry has been withdrawn by depositor
	 *  WAIT  = Awaiting author approval
	 */
	public java.lang.String getStatus_code_sf() 
	{
		return status_code_sf;
	}
 
	public void setStatus_code_sf(java.lang.String status_code_sf)
	{
		this.status_code_sf = status_code_sf;
	}

 }
