package org.pdb.beans;

/**
 *  This category contains details for the ligation-based cloning steps used in
 *  the overall protein production process.
 *  attribute clone_step_id in category pdbx_entity_src_gen_clone_ligation in this category
 *  must point at a defined  attribute step_id in category pdbx_entity_src_gen_clone.  The details in
 *  PDBX_ENTITY_SRC_GEN_CLONE_LIGATION extend the details in PDBX_ENTITY_SRC_GEN_CLONE
 *  to cover ligation dependent cloning steps.
 */
public class Pdbx_entity_src_gen_clone_ligation 
{
		protected java.lang.String cleavage_enzymes;


	/**
	 *  The names of the enzymes used to cleave the vector. In addition an enzyme
	 *  used to blunt the cut ends, etc., should be named here.
	 */
	public java.lang.String getCleavage_enzymes() 
	{
		return cleavage_enzymes;
	}
 
	public void setCleavage_enzymes(java.lang.String cleavage_enzymes)
	{
		this.cleavage_enzymes = cleavage_enzymes;
	}

 	protected java.lang.String details;


	/**
	 *  Any details to be associated with this ligation step, e.g. the protocol.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entity_id;


	/**
	 *  This item is a pointer to  attribute entity_id in category pdbx_entity_src_gen_clone in the
	 *  PDBX_ENTITY_SRC_GEN_CLONE category.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This item is a pointer to  attribute entry_id in category pdbx_entity_src_gen_clone in the
	 *  PDBX_ENTITY_SRC_GEN_CLONE category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String ligation_enzymes;


	/**
	 *  The names of the enzymes used to ligate the gene into the cleaved vector.
	 */
	public java.lang.String getLigation_enzymes() 
	{
		return ligation_enzymes;
	}
 
	public void setLigation_enzymes(java.lang.String ligation_enzymes)
	{
		this.ligation_enzymes = ligation_enzymes;
	}

 	protected java.lang.Integer step_id;


	/**
	 *  This item is a pointer to  attribute step_id in category pdbx_entity_src_gen_clone in the
	 *  PDBX_ENTITY_SRC_GEN_CLONE category.
	 */
	public java.lang.Integer getStep_id() 
	{
		return step_id;
	}
 
	public void setStep_id(java.lang.Integer step_id)
	{
		this.step_id = step_id;
	}

 	protected java.lang.Float temperature;


	/**
	 *  The temperature at which the ligation experiment was performed, in degrees
	 *  celsius.
	 */
	public java.lang.Float getTemperature() 
	{
		return temperature;
	}
 
	public void setTemperature(java.lang.Float temperature)
	{
		this.temperature = temperature;
	}

 	protected java.lang.Float time;


	/**
	 *  The duration of the ligation reaction in minutes.
	 */
	public java.lang.Float getTime() 
	{
		return time;
	}
 
	public void setTime(java.lang.Float time)
	{
		this.time = time;
	}

 }
