package org.pdb.beans;

/**
 *  This category contains details for the protein purification
 *  tag removal steps used in the overall protein production process
 */
public class Pdbx_entity_src_gen_proteolysis 
{
		protected java.lang.String cleavage_buffer_id;


	/**
	 *  This item is a pointer to pdbx_buffer.id in the PDBX_BUFFER category.
	 *  The referenced buffer is that in which the cleavage was performed.
	 */
	public java.lang.String getCleavage_buffer_id() 
	{
		return cleavage_buffer_id;
	}
 
	public void setCleavage_buffer_id(java.lang.String cleavage_buffer_id)
	{
		this.cleavage_buffer_id = cleavage_buffer_id;
	}

 	protected java.lang.Float cleavage_temperature;


	/**
	 *  The temperature in degrees celsius at which the cleavage was performed.
	 */
	public java.lang.Float getCleavage_temperature() 
	{
		return cleavage_temperature;
	}
 
	public void setCleavage_temperature(java.lang.Float cleavage_temperature)
	{
		this.cleavage_temperature = cleavage_temperature;
	}

 	protected java.lang.Float cleavage_time;


	/**
	 *  The time in minutes for the cleavage reaction
	 */
	public java.lang.Float getCleavage_time() 
	{
		return cleavage_time;
	}
 
	public void setCleavage_time(java.lang.Float cleavage_time)
	{
		this.cleavage_time = cleavage_time;
	}

 	protected java.lang.String date;


	/**
	 *  The date of production step.
	 *  2003-12-25
	 *  2003-12-25:09:00
	 */
	public java.lang.String getDate() 
	{
		return date;
	}
 
	public void setDate(java.lang.String date)
	{
		this.date = date;
	}

 	protected java.lang.String details;


	/**
	 *  Details of this tag removal step.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String end_construct_id;


	/**
	 *  This item is a pointer to pdbx_construct.id in the PDBX_CONSTRUCT
	 *  category. The referenced sequence is expected to be the amino
	 *  acid sequence of the expressed product after the proteolysis
	 *  step.
	 */
	public java.lang.String getEnd_construct_id() 
	{
		return end_construct_id;
	}
 
	public void setEnd_construct_id(java.lang.String end_construct_id)
	{
		this.end_construct_id = end_construct_id;
	}

 	protected java.lang.String entity_id;


	/**
	 *  The value of  attribute entity_id in category pdbx_entity_src_gen_proteolysis uniquely identifies
	 *  each protein contained in the project target complex proteins whose
	 *  structure is to be determined. This data item is a pointer to  attribute id
	 *  in category entity in the ENTITY category.  This item may be a site dependent bar code.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String entry_id;


	/**
	 *  The value of  attribute entry_id in category pdbx_entity_src_gen_proteolysis uniquely identifies
	 *  a sample consisting of one or more proteins whose structure is
	 *  to be determined. This is a pointer to  attribute id in category entry.  This item may
	 *  be a site dependent bar code.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.Integer next_step_id;


	/**
	 *  This item unique identifier for the next production step. This allows
	 *  a workflow to have multiple entry points leading to a single product.
	 */
	public java.lang.Integer getNext_step_id() 
	{
		return next_step_id;
	}
 
	public void setNext_step_id(java.lang.Integer next_step_id)
	{
		this.next_step_id = next_step_id;
	}

 	protected java.lang.String protease;


	/**
	 *  The name of the protease used for cleavage.
	 */
	public java.lang.String getProtease() 
	{
		return protease;
	}
 
	public void setProtease(java.lang.String protease)
	{
		this.protease = protease;
	}

 	protected java.lang.Float protein_protease_ratio;


	/**
	 *  The ratio of protein to protease used for the cleavage.
	 *  = mol protein / mol protease
	 */
	public java.lang.Float getProtein_protease_ratio() 
	{
		return protein_protease_ratio;
	}
 
	public void setProtein_protease_ratio(java.lang.Float protein_protease_ratio)
	{
		this.protein_protease_ratio = protein_protease_ratio;
	}

 	protected java.lang.String robot_id;


	/**
	 *  This data item is a pointer to pdbx_robot_system.id
	 *  in the PDBX_ROBOT_SYSTEM category.
	 */
	public java.lang.String getRobot_id() 
	{
		return robot_id;
	}
 
	public void setRobot_id(java.lang.String robot_id)
	{
		this.robot_id = robot_id;
	}

 	protected java.lang.Integer step_id;


	/**
	 *  This item is the unique identifier for this tag removal step.
	 */
	public java.lang.Integer getStep_id() 
	{
		return step_id;
	}
 
	public void setStep_id(java.lang.Integer step_id)
	{
		this.step_id = step_id;
	}

 }
