package org.pdb.beans;

/**
 *  This category contains details for the final purified protein product. Note
 *  that this category does not contain the amino acid sequence of the protein.
 *  The sequence will be found in the ENTITY_POLY_SEQ entry with matching
 *  entity_id.
 *  Only one PDBX_ENTITY_SRC_GEN_PURE category is allowed per entity, hence there is
 *  no step_id for this category.
 */
public class Pdbx_entity_src_gen_pure 
{
		protected java.lang.String conc_assay_method;


	/**
	 *  The method used to measure the protein concentration
	 */
	public java.lang.String getConc_assay_method() 
	{
		return conc_assay_method;
	}
 
	public void setConc_assay_method(java.lang.String conc_assay_method)
	{
		this.conc_assay_method = conc_assay_method;
	}

 	protected java.lang.String conc_details;


	/**
	 *  Details of the protein concentration procedure
	 */
	public java.lang.String getConc_details() 
	{
		return conc_details;
	}
 
	public void setConc_details(java.lang.String conc_details)
	{
		this.conc_details = conc_details;
	}

 	protected java.lang.String conc_device_id;


	/**
	 *  This data item is a pointer to pdbx_robot_system.id
	 *  in the PDBX_ROBOT_SYSTEM category.
	 */
	public java.lang.String getConc_device_id() 
	{
		return conc_device_id;
	}
 
	public void setConc_device_id(java.lang.String conc_device_id)
	{
		this.conc_device_id = conc_device_id;
	}

 	protected java.lang.String date;


	/**
	 *  The date of production step.
	 *  2003-12-25
	 *  2003-12-25:09:00
	 */
	public java.lang.String getDate() 
	{
		return date;
	}
 
	public void setDate(java.lang.String date)
	{
		this.date = date;
	}

 	protected java.lang.String entity_id;


	/**
	 *  The value of  attribute entity_id in category pdbx_entity_src_gen_pure uniquely identifies
	 *  each protein contained in the project target complex proteins whose
	 *  structure is to be determined. This data item is a pointer to  attribute id
	 *  in category entity in the ENTITY category.  This item may be a site dependent bar code.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String entry_id;


	/**
	 *  The value of  attribute entry_id in category pdbx_entity_src_gen_pure uniquely identifies
	 *  a sample consisting of one or more proteins whose structure is
	 *  to be determined. This is a pointer to  attribute id in category entry.  This item may
	 *  be a site dependent bar code.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String product_id;


	/**
	 *  When present, this item should be a globally unique identifier
	 *  that identifies the final product. It is envisaged that this
	 *  should be the same as and product code associated with the
	 *  sample and would provide the key by which information about
	 *  the production process may be extracted from the protein
	 *  production facility. For files describing the protein
	 *  production process (i.e. where  attribute type in category entity is 'P' or 'E')
	 *  this should have the same value as  attribute id in category entry
	 */
	public java.lang.String getProduct_id() 
	{
		return product_id;
	}
 
	public void setProduct_id(java.lang.String product_id)
	{
		this.product_id = product_id;
	}

 	protected java.lang.Float protein_concentration;


	/**
	 *  The final concentration of the protein.
	 */
	public java.lang.Float getProtein_concentration() 
	{
		return protein_concentration;
	}
 
	public void setProtein_concentration(java.lang.Float protein_concentration)
	{
		this.protein_concentration = protein_concentration;
	}

 	protected java.lang.Integer protein_oligomeric_state;


	/**
	 *  The oligomeric state of the protein. Monomeric is 1, dimeric 2, etc.
	 */
	public java.lang.Integer getProtein_oligomeric_state() 
	{
		return protein_oligomeric_state;
	}
 
	public void setProtein_oligomeric_state(java.lang.Integer protein_oligomeric_state)
	{
		this.protein_oligomeric_state = protein_oligomeric_state;
	}

 	protected java.lang.Float protein_purity;


	/**
	 *  The purity of the protein (percent).
	 */
	public java.lang.Float getProtein_purity() 
	{
		return protein_purity;
	}
 
	public void setProtein_purity(java.lang.Float protein_purity)
	{
		this.protein_purity = protein_purity;
	}

 	protected java.lang.Float protein_yield;


	/**
	 *  The yield of protein in milligrams.
	 */
	public java.lang.Float getProtein_yield() 
	{
		return protein_yield;
	}
 
	public void setProtein_yield(java.lang.Float protein_yield)
	{
		this.protein_yield = protein_yield;
	}

 	protected java.lang.Integer step_id;


	/**
	 *  This item unique identifier the production step.
	 */
	public java.lang.Integer getStep_id() 
	{
		return step_id;
	}
 
	public void setStep_id(java.lang.Integer step_id)
	{
		this.step_id = step_id;
	}

 	protected java.lang.String storage_buffer_id;


	/**
	 *  This item is a pointer to pdbx_buffer.id in the PDBX_BUFFER category.
	 *  The referenced buffer is that in which the protein was stored.
	 */
	public java.lang.String getStorage_buffer_id() 
	{
		return storage_buffer_id;
	}
 
	public void setStorage_buffer_id(java.lang.String storage_buffer_id)
	{
		this.storage_buffer_id = storage_buffer_id;
	}

 	protected java.lang.Float storage_temperature;


	/**
	 *  The temperature in degrees celsius at which the protein was stored.
	 */
	public java.lang.Float getStorage_temperature() 
	{
		return storage_temperature;
	}
 
	public void setStorage_temperature(java.lang.Float storage_temperature)
	{
		this.storage_temperature = storage_temperature;
	}

 	protected java.lang.String summary;


	/**
	 *  Summary of the details of protein purification method used to obtain the final
	 *  protein product.  This description should include any lysis, fractionation,
	 *  proteolysis, refolding, chromatography used as well as the method used the
	 *  characterize the final product.
	 */
	public java.lang.String getSummary() 
	{
		return summary;
	}
 
	public void setSummary(java.lang.String summary)
	{
		this.summary = summary;
	}

 }
