package org.pdb.beans;

/**
 *  Data items in the PDBX_EXPTL_CRYSTAL_CRYO_TREATMENT category
 *  record details cryogenic treatments applied to this crystal.
 *  
 * <pre>
 *  Example 1
 *  <PDBx:pdbx_exptl_crystal_cryo_treatmentCategory>
 *  <PDBx:pdbx_exptl_crystal_cryo_treatment crystal_id="4">
 *  <PDBx:final_solution_details>  25&#37; (v/v) glycerol in precipitant solution</PDBx:final_solution_details>
 *  <PDBx:soaking_details>  A series of 1 min soaks beginning at 5&#37; (v/v) glycerol in precipitant,
 *  transiting to 20&#37; (v/v) glycerol, and finally to 25&#37; glycerol</PDBx:soaking_details>
 *  <PDBx:cooling_details>  Direct immersion in liquid nitrogen</PDBx:cooling_details>
 *  </PDBx:pdbx_exptl_crystal_cryo_treatment>
 *  </PDBx:pdbx_exptl_crystal_cryo_treatmentCategory>
 * </pre>
 */
public class Pdbx_exptl_crystal_cryo_treatment 
{
		protected java.lang.String annealing_details;


	/**
	 *  Details of the annealing treatment applied to this crystal.
	 *  10 sec interruption of cold stream with plastic ruler.
	 *  Performed twice.
	 */
	public java.lang.String getAnnealing_details() 
	{
		return annealing_details;
	}
 
	public void setAnnealing_details(java.lang.String annealing_details)
	{
		this.annealing_details = annealing_details;
	}

 	protected java.lang.String cooling_details;


	/**
	 *  Details of the cooling treatment applied to this crystal.
	 *  Direct immersion in liquid nitrogen
	 */
	public java.lang.String getCooling_details() 
	{
		return cooling_details;
	}
 
	public void setCooling_details(java.lang.String cooling_details)
	{
		this.cooling_details = cooling_details;
	}

 	protected java.lang.String crystal_id;


	/**
	 *  This data item is a pointer to  attribute id in category exptl_crystal in the
	 *  EXPTL_CRYSTAL category.
	 */
	public java.lang.String getCrystal_id() 
	{
		return crystal_id;
	}
 
	public void setCrystal_id(java.lang.String crystal_id)
	{
		this.crystal_id = crystal_id;
	}

 	protected java.lang.String final_solution_details;


	/**
	 *  Details of the final solution used in the treatment of this crystal
	 *  25% (v/v) glycerol in precipitant solution
	 */
	public java.lang.String getFinal_solution_details() 
	{
		return final_solution_details;
	}
 
	public void setFinal_solution_details(java.lang.String final_solution_details)
	{
		this.final_solution_details = final_solution_details;
	}

 	protected java.lang.String soaking_details;


	/**
	 *  Details of the soaking treatment applied to this crystal.
	 *  A series of 1 min soaks beginning at 5% (v/v) glycerol in precipitant,
	 *  transiting to 20% (v/v) glycerol, and finally to 25% glycerol
	 */
	public java.lang.String getSoaking_details() 
	{
		return soaking_details;
	}
 
	public void setSoaking_details(java.lang.String soaking_details)
	{
		this.soaking_details = soaking_details;
	}

 }
