package org.pdb.beans;

/**
 *  Data items in the PDBX_EXPTL_CRYSTAL_GROW_SOL category record
 *  details about the solutions that were 'mixed'
 *  to produce the crystal.
 *  
 * <pre>
 *  Example 1
 *  <PDBx:pdbx_exptl_crystal_grow_solCategory>
 *  <PDBx:pdbx_exptl_crystal_grow_sol crystal_id="1" sol_id="protein">
 *  <PDBx:volume>0.5</PDBx:volume>
 *  <PDBx:volume_units>microliter</PDBx:volume_units>
 *  <PDBx:pH>7.5</PDBx:pH>
 *  </PDBx:pdbx_exptl_crystal_grow_sol>
 *  <PDBx:pdbx_exptl_crystal_grow_sol crystal_id="1" sol_id="precipitant">
 *  <PDBx:volume>0.5</PDBx:volume>
 *  <PDBx:volume_units>microliter</PDBx:volume_units>
 *  <PDBx:pH>7.3</PDBx:pH>
 *  </PDBx:pdbx_exptl_crystal_grow_sol>
 *  <PDBx:pdbx_exptl_crystal_grow_sol crystal_id="1" sol_id="reservoir">
 *  <PDBx:volume>0.5</PDBx:volume>
 *  <PDBx:volume_units>milliliter</PDBx:volume_units>
 *  <PDBx:pH>7.3</PDBx:pH>
 *  </PDBx:pdbx_exptl_crystal_grow_sol>
 *  </PDBx:pdbx_exptl_crystal_grow_solCategory>
 * </pre>
 */
public class Pdbx_exptl_crystal_grow_sol 
{
		protected java.lang.String crystal_id;


	/**
	 *  This data item is a pointer to  attribute id in category exptl_crystal in the
	 *  EXPTL_CRYSTAL category.
	 */
	public java.lang.String getCrystal_id() 
	{
		return crystal_id;
	}
 
	public void setCrystal_id(java.lang.String crystal_id)
	{
		this.crystal_id = crystal_id;
	}

 	protected java.lang.Float pH;


	/**
	 *  The pH of the solution.
	 *  7.2
	 */
	public java.lang.Float getPH() 
	{
		return pH;
	}
 
	public void setPH(java.lang.Float pH)
	{
		this.pH = pH;
	}

 	protected java.lang.String sol_id;


	/**
	 *  An identifier for this solution (e.g. precipitant, reservoir, macromolecule)
	 */
	public java.lang.String getSol_id() 
	{
		return sol_id;
	}
 
	public void setSol_id(java.lang.String sol_id)
	{
		this.sol_id = sol_id;
	}

 	protected java.lang.Float volume;


	/**
	 *  The volume of the solution.
	 *  200.
	 *  0.1
	 */
	public java.lang.Float getVolume() 
	{
		return volume;
	}
 
	public void setVolume(java.lang.Float volume)
	{
		this.volume = volume;
	}

 	protected java.lang.String volume_units;


	/**
	 *  The volume units of the solution.
	 *  milliliter
	 *  micoliter
	 */
	public java.lang.String getVolume_units() 
	{
		return volume_units;
	}
 
	public void setVolume_units(java.lang.String volume_units)
	{
		this.volume_units = volume_units;
	}

 }
