package org.pdb.beans;

/**
 *  Data items in the PDBX_FEATURE_DOMAIN category records
 *  information about properties pertaining to this structure
 *  domain.
 *  
 * <pre>
 *  Example 1 - SCOP data for PDB Entry 1KIP domain d1kipa_
 *  <PDBx:pdbx_feature_domainCategory>
 *  <PDBx:pdbx_feature_domain id="1">
 *  <PDBx:domain_id>d1kipa_</PDBx:domain_id>
 *  <PDBx:feature_name>class</PDBx:feature_name>
 *  <PDBx:feature>All beta proteins</PDBx:feature>
 *  <PDBx:feature_type>value</PDBx:feature_type>
 *  <PDBx:feature_assigned_by>SCOP</PDBx:feature_assigned_by>
 *  <PDBx:feature_citation_id>scop</PDBx:feature_citation_id>
 *  </PDBx:pdbx_feature_domain>
 *  <PDBx:pdbx_feature_domain id="2">
 *  <PDBx:domain_id>d1kipa_</PDBx:domain_id>
 *  <PDBx:feature_name>fold</PDBx:feature_name>
 *  <PDBx:feature>Immunoglobulin-like beta-sandwich</PDBx:feature>
 *  <PDBx:feature_type>value</PDBx:feature_type>
 *  <PDBx:feature_assigned_by>SCOP</PDBx:feature_assigned_by>
 *  <PDBx:feature_citation_id>scop</PDBx:feature_citation_id>
 *  </PDBx:pdbx_feature_domain>
 *  <PDBx:pdbx_feature_domain id="3">
 *  <PDBx:domain_id>d1kipa_</PDBx:domain_id>
 *  <PDBx:feature_name>superfamily</PDBx:feature_name>
 *  <PDBx:feature>Immunoglobulin</PDBx:feature>
 *  <PDBx:feature_type>value</PDBx:feature_type>
 *  <PDBx:feature_assigned_by>SCOP</PDBx:feature_assigned_by>
 *  <PDBx:feature_citation_id>scop</PDBx:feature_citation_id>
 *  </PDBx:pdbx_feature_domain>
 *  <PDBx:pdbx_feature_domain id="4">
 *  <PDBx:domain_id>d1kipa_</PDBx:domain_id>
 *  <PDBx:feature_name>family</PDBx:feature_name>
 *  <PDBx:feature>V set domains (antibody variable domain-like)</PDBx:feature>
 *  <PDBx:feature_type>value</PDBx:feature_type>
 *  <PDBx:feature_assigned_by>SCOP</PDBx:feature_assigned_by>
 *  <PDBx:feature_citation_id>scop</PDBx:feature_citation_id>
 *  </PDBx:pdbx_feature_domain>
 *  <PDBx:pdbx_feature_domain id="5">
 *  <PDBx:domain_id>d1kipa_</PDBx:domain_id>
 *  <PDBx:feature_name>domain</PDBx:feature_name>
 *  <PDBx:feature>Immunoglobulin light chain kappa variable domain</PDBx:feature>
 *  <PDBx:feature_type>value</PDBx:feature_type>
 *  <PDBx:feature_assigned_by>SCOP</PDBx:feature_assigned_by>
 *  <PDBx:feature_citation_id>scop</PDBx:feature_citation_id>
 *  </PDBx:pdbx_feature_domain>
 *  <PDBx:pdbx_feature_domain id="6">
 *  <PDBx:domain_id>d1kipa_</PDBx:domain_id>
 *  <PDBx:feature_name>species</PDBx:feature_name>
 *  <PDBx:feature>Mouse (Mus musculus), cluster 4</PDBx:feature>
 *  <PDBx:feature_type>value</PDBx:feature_type>
 *  <PDBx:feature_assigned_by>SCOP</PDBx:feature_assigned_by>
 *  <PDBx:feature_citation_id>scop</PDBx:feature_citation_id>
 *  </PDBx:pdbx_feature_domain>
 *  </PDBx:pdbx_feature_domainCategory>
 * </pre>
 */
public class Pdbx_feature_domain 
{
		protected java.lang.String domain_id;


	/**
	 *  The value of  attribute id in category pdbx_feature_domain references a domain
	 *  definition in category PDBX_DOMAIN.
	 */
	public java.lang.String getDomain_id() 
	{
		return domain_id;
	}
 
	public void setDomain_id(java.lang.String domain_id)
	{
		this.domain_id = domain_id;
	}

 	protected java.lang.String feature;


	/**
	 *  The value of  attribute feature_name in category pdbx_feature_domain.
	 */
	public java.lang.String getFeature() 
	{
		return feature;
	}
 
	public void setFeature(java.lang.String feature)
	{
		this.feature = feature;
	}

 	protected java.lang.String feature_assigned_by;


	/**
	 *  attribute feature_assigned_by in category pdbx_feature_domain identifies
	 *  the individual, organization or program that
	 *  assigned the feature.
	 */
	public java.lang.String getFeature_assigned_by() 
	{
		return feature_assigned_by;
	}
 
	public void setFeature_assigned_by(java.lang.String feature_assigned_by)
	{
		this.feature_assigned_by = feature_assigned_by;
	}

 	protected java.lang.String feature_citation_id;


	/**
	 *  attribute feature_citation_id in category pdbx_feature_domain is a
	 *  reference to a citation in the CITATION category.
	 */
	public java.lang.String getFeature_citation_id() 
	{
		return feature_citation_id;
	}
 
	public void setFeature_citation_id(java.lang.String feature_citation_id)
	{
		this.feature_citation_id = feature_citation_id;
	}

 	protected java.lang.String feature_identifier;


	/**
	 *  attribute feature_identifier in category pdbx_feature_domain is an
	 *  additional identifier used to identify or
	 *  accession this feature.
	 */
	public java.lang.String getFeature_identifier() 
	{
		return feature_identifier;
	}
 
	public void setFeature_identifier(java.lang.String feature_identifier)
	{
		this.feature_identifier = feature_identifier;
	}

 	protected java.lang.String feature_name;


	/**
	 *  attribute feature_name in category pdbx_feature_domain identifies a feature
	 *  by name.
	 */
	public java.lang.String getFeature_name() 
	{
		return feature_name;
	}
 
	public void setFeature_name(java.lang.String feature_name)
	{
		this.feature_name = feature_name;
	}

 	protected java.lang.String feature_software_id;


	/**
	 *  attribute feature_software_id in category pdbx_feature_domain is a
	 *  reference to an application described in the
	 *  SOFTWARE category.
	 */
	public java.lang.String getFeature_software_id() 
	{
		return feature_software_id;
	}
 
	public void setFeature_software_id(java.lang.String feature_software_id)
	{
		this.feature_software_id = feature_software_id;
	}

 	protected java.lang.String feature_type;


	/**
	 *  attribute feature_type in category pdbx_feature_domain identifies the
	 *  type of feature.
	 */
	public java.lang.String getFeature_type() 
	{
		return feature_type;
	}
 
	public void setFeature_type(java.lang.String feature_type)
	{
		this.feature_type = feature_type;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category pdbx_feature_domain uniquely identifies
	 *  a feature in the PDBX_FEATURE_DOMAIN category.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 }
