package org.pdb.beans;

/**
 *  Data items in the PDBX_HELICAL_SYMMETRY category record details about the
 *  helical symmetry group associated with this entry.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_helical_symmetryCategory>
 *  <PDBx:pdbx_helical_symmetry entry_id="1ABC">
 *  <PDBx:number_of_operations>35</PDBx:number_of_operations>
 *  <PDBx:rotation_per_n_subunits>131.84</PDBx:rotation_per_n_subunits>
 *  <PDBx:rise_per_n_subunits>6.10</PDBx:rise_per_n_subunits>
 *  <PDBx:n_subunits_divisor>1</PDBx:n_subunits_divisor>
 *  <PDBx:dyad_axis>no</PDBx:dyad_axis>
 *  <PDBx:circular_symmetry>1</PDBx:circular_symmetry>
 *  </PDBx:pdbx_helical_symmetry>
 *  </PDBx:pdbx_helical_symmetryCategory>
 * </pre>
 */
public class Pdbx_helical_symmetry 
{
		protected java.lang.Integer circular_symmetry;


	/**
	 *  Rotational n-fold symmetry about the helical axis.
	 */
	public java.lang.Integer getCircular_symmetry() 
	{
		return circular_symmetry;
	}
 
	public void setCircular_symmetry(java.lang.Integer circular_symmetry)
	{
		this.circular_symmetry = circular_symmetry;
	}

 	protected java.lang.String dyad_axis;


	/**
	 *  Two-fold symmetry perpendicular to the helical axis.
	 */
	public java.lang.String getDyad_axis() 
	{
		return dyad_axis;
	}
 
	public void setDyad_axis(java.lang.String dyad_axis)
	{
		this.dyad_axis = dyad_axis;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.Integer n_subunits_divisor;


	/**
	 *  Number of subunits used in the calculation of rise and
	 *  rotation.
	 */
	public java.lang.Integer getN_subunits_divisor() 
	{
		return n_subunits_divisor;
	}
 
	public void setN_subunits_divisor(java.lang.Integer n_subunits_divisor)
	{
		this.n_subunits_divisor = n_subunits_divisor;
	}

 	protected java.lang.Integer number_of_operations;


	/**
	 *  Number of operations.
	 */
	public java.lang.Integer getNumber_of_operations() 
	{
		return number_of_operations;
	}
 
	public void setNumber_of_operations(java.lang.Integer number_of_operations)
	{
		this.number_of_operations = number_of_operations;
	}

 	protected java.lang.Float rise_per_n_subunits;


	/**
	 *  Angular rotation (degrees) in N subunits
	 */
	public java.lang.Float getRise_per_n_subunits() 
	{
		return rise_per_n_subunits;
	}
 
	public void setRise_per_n_subunits(java.lang.Float rise_per_n_subunits)
	{
		this.rise_per_n_subunits = rise_per_n_subunits;
	}

 	protected java.lang.Float rotation_per_n_subunits;


	/**
	 *  Angular rotation (degrees) in N subunits
	 */
	public java.lang.Float getRotation_per_n_subunits() 
	{
		return rotation_per_n_subunits;
	}
 
	public void setRotation_per_n_subunits(java.lang.Float rotation_per_n_subunits)
	{
		this.rotation_per_n_subunits = rotation_per_n_subunits;
	}

 }
