package org.pdb.beans;

/**
 *  This section provides a tabulation of constraint data.
 *  This example uses the data from the MCP-1 structure determination. Remember
 *  this is a dimer so there are intersubunit constraints as well as intrasubunit
 *  constraints.
 *  <PDBx:pdbx_nmr_constraintsCategory>
 *  <PDBx:pdbx_nmr_constraints entry_id="1ABC">
 *  <PDBx:NOE_constraints_total>4458</PDBx:NOE_constraints_total>
 *  <PDBx:NOE_intraresidue_total_count>1144</PDBx:NOE_intraresidue_total_count>
 *  <PDBx:NOE_sequential_total_count>272</PDBx:NOE_sequential_total_count>
 *  <PDBx:NOE_medium_range_total_count>1004</PDBx:NOE_medium_range_total_count>
 *  <PDBx:NOE_long_range_total_count>1356</PDBx:NOE_long_range_total_count>
 *  <PDBx:protein_phi_angle_constraints_total_count>96</PDBx:protein_phi_angle_constraints_total_count>
 *  </PDBx:pdbx_nmr_constraints>
 *  </PDBx:pdbx_nmr_constraintsCategory>
 */
public class Pdbx_nmr_constraints 
{
		protected java.lang.Integer NA_alpha_angle_constraints_total_count;


	/**
	 *  The total number of nucleic acid alpha-angle constraints used in
	 *  the final structure calculation.
	 *  18
	 */
	public java.lang.Integer getNA_alpha_angle_constraints_total_count() 
	{
		return NA_alpha_angle_constraints_total_count;
	}
 
	public void setNA_alpha_angle_constraints_total_count(java.lang.Integer NA_alpha_angle_constraints_total_count)
	{
		this.NA_alpha_angle_constraints_total_count = NA_alpha_angle_constraints_total_count;
	}

 	protected java.lang.Integer NA_beta_angle_constraints_total_count;


	/**
	 *  The total number of nucleic acid beta-angle constraints used in
	 *  the final structure calculation.
	 *  24
	 */
	public java.lang.Integer getNA_beta_angle_constraints_total_count() 
	{
		return NA_beta_angle_constraints_total_count;
	}
 
	public void setNA_beta_angle_constraints_total_count(java.lang.Integer NA_beta_angle_constraints_total_count)
	{
		this.NA_beta_angle_constraints_total_count = NA_beta_angle_constraints_total_count;
	}

 	protected java.lang.Integer NA_chi_angle_constraints_total_count;


	/**
	 *  The total number of nucleic acid chi-angle constraints used
	 *  in the final structure calculation.
	 *  15
	 */
	public java.lang.Integer getNA_chi_angle_constraints_total_count() 
	{
		return NA_chi_angle_constraints_total_count;
	}
 
	public void setNA_chi_angle_constraints_total_count(java.lang.Integer NA_chi_angle_constraints_total_count)
	{
		this.NA_chi_angle_constraints_total_count = NA_chi_angle_constraints_total_count;
	}

 	protected java.lang.Integer NA_delta_angle_constraints_total_count;


	/**
	 *  The total number of nucleic acid delta-angle constraints used in
	 *  the final structure calculation.
	 *  15
	 */
	public java.lang.Integer getNA_delta_angle_constraints_total_count() 
	{
		return NA_delta_angle_constraints_total_count;
	}
 
	public void setNA_delta_angle_constraints_total_count(java.lang.Integer NA_delta_angle_constraints_total_count)
	{
		this.NA_delta_angle_constraints_total_count = NA_delta_angle_constraints_total_count;
	}

 	protected java.lang.Integer NA_epsilon_angle_constraints_total_count;


	/**
	 *  The total number of nucleic acid epsilon-angle constraints used
	 *  in the final structure calculation.
	 *  31
	 */
	public java.lang.Integer getNA_epsilon_angle_constraints_total_count() 
	{
		return NA_epsilon_angle_constraints_total_count;
	}
 
	public void setNA_epsilon_angle_constraints_total_count(java.lang.Integer NA_epsilon_angle_constraints_total_count)
	{
		this.NA_epsilon_angle_constraints_total_count = NA_epsilon_angle_constraints_total_count;
	}

 	protected java.lang.Integer NA_gamma_angle_constraints_total_count;


	/**
	 *  The total number of nucleic acid gamma-angle constraints used in
	 *  the final structure calculation.
	 *  12
	 */
	public java.lang.Integer getNA_gamma_angle_constraints_total_count() 
	{
		return NA_gamma_angle_constraints_total_count;
	}
 
	public void setNA_gamma_angle_constraints_total_count(java.lang.Integer NA_gamma_angle_constraints_total_count)
	{
		this.NA_gamma_angle_constraints_total_count = NA_gamma_angle_constraints_total_count;
	}

 	protected java.lang.Integer NA_other_angle_constraints_total_count;


	/**
	 *  The total number of nucleic acid other-angle constraints used
	 *  in the final structure calculation.
	 *  5
	 */
	public java.lang.Integer getNA_other_angle_constraints_total_count() 
	{
		return NA_other_angle_constraints_total_count;
	}
 
	public void setNA_other_angle_constraints_total_count(java.lang.Integer NA_other_angle_constraints_total_count)
	{
		this.NA_other_angle_constraints_total_count = NA_other_angle_constraints_total_count;
	}

 	protected java.lang.Integer NA_sugar_pucker_constraints_total_count;


	/**
	 *  The total number of nucleic acid sugar pucker constraints used
	 *  in the final structure calculation.
	 *  10
	 */
	public java.lang.Integer getNA_sugar_pucker_constraints_total_count() 
	{
		return NA_sugar_pucker_constraints_total_count;
	}
 
	public void setNA_sugar_pucker_constraints_total_count(java.lang.Integer NA_sugar_pucker_constraints_total_count)
	{
		this.NA_sugar_pucker_constraints_total_count = NA_sugar_pucker_constraints_total_count;
	}

 	protected java.lang.Integer NOE_constraints_total;


	/**
	 *  The total number of all NOE constraints used in the final
	 *  structure calculation.
	 *  4458
	 */
	public java.lang.Integer getNOE_constraints_total() 
	{
		return NOE_constraints_total;
	}
 
	public void setNOE_constraints_total(java.lang.Integer NOE_constraints_total)
	{
		this.NOE_constraints_total = NOE_constraints_total;
	}

 	protected java.lang.Integer NOE_interentity_total_count;


	/**
	 *  The total number of interentity, NOE constraints
	 *  used in the final structure calculation. This field should only be
	 *  if system is complex -i.e more than one entity e.g. a dimer or ligand-protein
	 *  complex
	 *  272
	 */
	public java.lang.Integer getNOE_interentity_total_count() 
	{
		return NOE_interentity_total_count;
	}
 
	public void setNOE_interentity_total_count(java.lang.Integer NOE_interentity_total_count)
	{
		this.NOE_interentity_total_count = NOE_interentity_total_count;
	}

 	protected java.lang.String NOE_interproton_distance_evaluation;


	/**
	 *  Describe the method used to quantify the NOE and ROE values.
	 *  
	 *  NOE buildup curves with 50, 75, 150 ms mixing times were
	 *  analyzed.
	 *  
	 *  Noesy cross peak intensities were classified into three different
	 *  catagories with distances of 1.8-2.7 A, 1.8-3.5 A, 1.8- 5.0 A for strong,
	 *  medium and weak NOEs.
	 */
	public java.lang.String getNOE_interproton_distance_evaluation() 
	{
		return NOE_interproton_distance_evaluation;
	}
 
	public void setNOE_interproton_distance_evaluation(java.lang.String NOE_interproton_distance_evaluation)
	{
		this.NOE_interproton_distance_evaluation = NOE_interproton_distance_evaluation;
	}

 	protected java.lang.Integer NOE_intraresidue_total_count;


	/**
	 *  The total number of all intraresidue, [i-j]=0, NOE constraints
	 *  used in the final structure calculation.
	 *  1144
	 */
	public java.lang.Integer getNOE_intraresidue_total_count() 
	{
		return NOE_intraresidue_total_count;
	}
 
	public void setNOE_intraresidue_total_count(java.lang.Integer NOE_intraresidue_total_count)
	{
		this.NOE_intraresidue_total_count = NOE_intraresidue_total_count;
	}

 	protected java.lang.Integer NOE_long_range_total_count;


	/**
	 *  The total number of long range [i-j]>5 NOE constraints used
	 *  in the final structure calculation.
	 *  1356
	 */
	public java.lang.Integer getNOE_long_range_total_count() 
	{
		return NOE_long_range_total_count;
	}
 
	public void setNOE_long_range_total_count(java.lang.Integer NOE_long_range_total_count)
	{
		this.NOE_long_range_total_count = NOE_long_range_total_count;
	}

 	protected java.lang.Integer NOE_medium_range_total_count;


	/**
	 *  The total number of medium range 1<[i-j]<=5 NOE constraints used
	 *  in the final structure calculation.
	 *  682
	 */
	public java.lang.Integer getNOE_medium_range_total_count() 
	{
		return NOE_medium_range_total_count;
	}
 
	public void setNOE_medium_range_total_count(java.lang.Integer NOE_medium_range_total_count)
	{
		this.NOE_medium_range_total_count = NOE_medium_range_total_count;
	}

 	protected java.lang.String NOE_motional_averaging_correction;


	/**
	 *  Describe any corrections that were made to the NOE data for motional averaging.
	 *  Replace with item example text
	 */
	public java.lang.String getNOE_motional_averaging_correction() 
	{
		return NOE_motional_averaging_correction;
	}
 
	public void setNOE_motional_averaging_correction(java.lang.String NOE_motional_averaging_correction)
	{
		this.NOE_motional_averaging_correction = NOE_motional_averaging_correction;
	}

 	protected java.lang.String NOE_pseudoatom_corrections;


	/**
	 *  Describe any corrections made for pseudoatoms
	 *  
	 *  Pseudo-atoms nomenclature and corrections according to Wuethrich, Billeter,
	 *  and Braun, J. Mol.Biol.(1983) 169, 949-961.
	 *  
	 *  Pseudoatoms were not used.
	 */
	public java.lang.String getNOE_pseudoatom_corrections() 
	{
		return NOE_pseudoatom_corrections;
	}
 
	public void setNOE_pseudoatom_corrections(java.lang.String NOE_pseudoatom_corrections)
	{
		this.NOE_pseudoatom_corrections = NOE_pseudoatom_corrections;
	}

 	protected java.lang.Integer NOE_sequential_total_count;


	/**
	 *  The total number of sequential, [i-j]=1, NOE constraints used
	 *  in the final structure calculation.
	 *  1004
	 */
	public java.lang.Integer getNOE_sequential_total_count() 
	{
		return NOE_sequential_total_count;
	}
 
	public void setNOE_sequential_total_count(java.lang.Integer NOE_sequential_total_count)
	{
		this.NOE_sequential_total_count = NOE_sequential_total_count;
	}

 	protected java.lang.Integer disulfide_bond_constraints_total_count;


	/**
	 *  The total number of disulfide bond constraints used in the final
	 *  structure calculation.
	 *  3
	 */
	public java.lang.Integer getDisulfide_bond_constraints_total_count() 
	{
		return disulfide_bond_constraints_total_count;
	}
 
	public void setDisulfide_bond_constraints_total_count(java.lang.Integer disulfide_bond_constraints_total_count)
	{
		this.disulfide_bond_constraints_total_count = disulfide_bond_constraints_total_count;
	}

 	protected java.lang.String entry_id;


	/**
	 *  You can leave this blank as an ID will be assigned by the MSD
	 *  to the constraint file.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.Integer hydrogen_bond_constraints_total_count;


	/**
	 *  The total number of hydrogen bond constraints used in the final
	 *  structure calculation.
	 *  6
	 */
	public java.lang.Integer getHydrogen_bond_constraints_total_count() 
	{
		return hydrogen_bond_constraints_total_count;
	}
 
	public void setHydrogen_bond_constraints_total_count(java.lang.Integer hydrogen_bond_constraints_total_count)
	{
		this.hydrogen_bond_constraints_total_count = hydrogen_bond_constraints_total_count;
	}

 	protected java.lang.Integer protein_chi_angle_constraints_total_count;


	/**
	 *  The total number of chi angle constraints used in the final structure
	 *  calculation.
	 *  66
	 */
	public java.lang.Integer getProtein_chi_angle_constraints_total_count() 
	{
		return protein_chi_angle_constraints_total_count;
	}
 
	public void setProtein_chi_angle_constraints_total_count(java.lang.Integer protein_chi_angle_constraints_total_count)
	{
		this.protein_chi_angle_constraints_total_count = protein_chi_angle_constraints_total_count;
	}

 	protected java.lang.Integer protein_other_angle_constraints_total_count;


	/**
	 *  The total number of other angle constraints used in the final structure
	 *  calculation.
	 *  0
	 */
	public java.lang.Integer getProtein_other_angle_constraints_total_count() 
	{
		return protein_other_angle_constraints_total_count;
	}
 
	public void setProtein_other_angle_constraints_total_count(java.lang.Integer protein_other_angle_constraints_total_count)
	{
		this.protein_other_angle_constraints_total_count = protein_other_angle_constraints_total_count;
	}

 	protected java.lang.Integer protein_phi_angle_constraints_total_count;


	/**
	 *  The total number of phi angle constraints used in the final structure
	 *  calculation
	 *  96
	 */
	public java.lang.Integer getProtein_phi_angle_constraints_total_count() 
	{
		return protein_phi_angle_constraints_total_count;
	}
 
	public void setProtein_phi_angle_constraints_total_count(java.lang.Integer protein_phi_angle_constraints_total_count)
	{
		this.protein_phi_angle_constraints_total_count = protein_phi_angle_constraints_total_count;
	}

 	protected java.lang.Integer protein_psi_angle_constraints_total_count;


	/**
	 *  The total number of psi angle constraints used in the final structure
	 *  calculation.
	 *  0
	 */
	public java.lang.Integer getProtein_psi_angle_constraints_total_count() 
	{
		return protein_psi_angle_constraints_total_count;
	}
 
	public void setProtein_psi_angle_constraints_total_count(java.lang.Integer protein_psi_angle_constraints_total_count)
	{
		this.protein_psi_angle_constraints_total_count = protein_psi_angle_constraints_total_count;
	}

 }
