package org.pdb.beans;

/**
 *  This category contains the information that describes the
 *  ensemble of deposited structures. If only an average structure
 *  has been deposited skip this section.
 *  This example uses the data from the MCP-1 study.
 *  <PDBx:pdbx_nmr_ensembleCategory>
 *  <PDBx:pdbx_nmr_ensemble entry_id="1ABC">
 *  <PDBx:conformers_calculated_total_number>40</PDBx:conformers_calculated_total_number>
 *  <PDBx:conformers_submitted_total_number>20</PDBx:conformers_submitted_total_number>
 *  <PDBx:conformer_selection_criteria>structures with the least restraint violations</PDBx:conformer_selection_criteria>
 *  <PDBx:representative_conformer>1</PDBx:representative_conformer>
 *  </PDBx:pdbx_nmr_ensemble>
 *  </PDBx:pdbx_nmr_ensembleCategory>
 */
public class Pdbx_nmr_ensemble 
{
		protected java.lang.Integer average_constraint_violations_per_residue;


	/**
	 *  The average number of constraint violations on a per residue basis for
	 *  the ensemble.
	 *  0.25
	 */
	public java.lang.Integer getAverage_constraint_violations_per_residue() 
	{
		return average_constraint_violations_per_residue;
	}
 
	public void setAverage_constraint_violations_per_residue(java.lang.Integer average_constraint_violations_per_residue)
	{
		this.average_constraint_violations_per_residue = average_constraint_violations_per_residue;
	}

 	protected java.lang.Integer average_constraints_per_residue;


	/**
	 *  The average number of constraints per residue for the ensemble
	 *  30.2
	 */
	public java.lang.Integer getAverage_constraints_per_residue() 
	{
		return average_constraints_per_residue;
	}
 
	public void setAverage_constraints_per_residue(java.lang.Integer average_constraints_per_residue)
	{
		this.average_constraints_per_residue = average_constraints_per_residue;
	}

 	protected java.lang.Float average_distance_constraint_violation;


	/**
	 *  The average distance restraint violation for the ensemble.
	 *  0.11
	 */
	public java.lang.Float getAverage_distance_constraint_violation() 
	{
		return average_distance_constraint_violation;
	}
 
	public void setAverage_distance_constraint_violation(java.lang.Float average_distance_constraint_violation)
	{
		this.average_distance_constraint_violation = average_distance_constraint_violation;
	}

 	protected java.lang.Float average_torsion_angle_constraint_violation;


	/**
	 *  The average torsion angle constraint violation for the ensemble.
	 *  2.4
	 */
	public java.lang.Float getAverage_torsion_angle_constraint_violation() 
	{
		return average_torsion_angle_constraint_violation;
	}
 
	public void setAverage_torsion_angle_constraint_violation(java.lang.Float average_torsion_angle_constraint_violation)
	{
		this.average_torsion_angle_constraint_violation = average_torsion_angle_constraint_violation;
	}

 	protected java.lang.String conformer_selection_criteria;


	/**
	 *  By highlighting the appropriate choice(s), describe how the submitted
	 *  conformer (models) were selected.
	 *  structures with the lowest energy
	 *  structures with the least restraint violations
	 *  structures with acceptable covalent geometry
	 *  structures with favorable non-bond energy
	 *  target function
	 *  back calculated data agree with experimental NOESY spectrum
	 *  all calculated structures submitted
	 *  The submitted conformer models are the 25 structures with the lowest
	 *  energy.
	 *  The submitted conformer models are those with the fewest number of
	 *  constraint violations.
	 */
	public java.lang.String getConformer_selection_criteria() 
	{
		return conformer_selection_criteria;
	}
 
	public void setConformer_selection_criteria(java.lang.String conformer_selection_criteria)
	{
		this.conformer_selection_criteria = conformer_selection_criteria;
	}

 	protected java.lang.Integer conformers_calculated_total_number;


	/**
	 *  The total number of conformer (models) that were calculated in the final round.
	 *  40
	 */
	public java.lang.Integer getConformers_calculated_total_number() 
	{
		return conformers_calculated_total_number;
	}
 
	public void setConformers_calculated_total_number(java.lang.Integer conformers_calculated_total_number)
	{
		this.conformers_calculated_total_number = conformers_calculated_total_number;
	}

 	protected java.lang.Integer conformers_submitted_total_number;


	/**
	 *  The number of conformer (models) that are submitted for the ensemble.
	 *  20
	 */
	public java.lang.Integer getConformers_submitted_total_number() 
	{
		return conformers_submitted_total_number;
	}
 
	public void setConformers_submitted_total_number(java.lang.Integer conformers_submitted_total_number)
	{
		this.conformers_submitted_total_number = conformers_submitted_total_number;
	}

 	protected java.lang.String distance_constraint_violation_method;


	/**
	 *  Describe the method used to calculate the distance constraint violation statistics,
	 *  i.e. are they calculated over all the distance constraints or calculated for
	 *  violations only?
	 *  Statistics were calculated over all of the distance constraints.
	 *  Statistics were calculated for violations only
	 */
	public java.lang.String getDistance_constraint_violation_method() 
	{
		return distance_constraint_violation_method;
	}
 
	public void setDistance_constraint_violation_method(java.lang.String distance_constraint_violation_method)
	{
		this.distance_constraint_violation_method = distance_constraint_violation_method;
	}

 	protected java.lang.String entry_id;


	/**
	 *  Leave this blank as the ID is provided by the MSD
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.Float maximum_distance_constraint_violation;


	/**
	 *  The maximum distance constraint violation for the ensemble.
	 *  0.4
	 */
	public java.lang.Float getMaximum_distance_constraint_violation() 
	{
		return maximum_distance_constraint_violation;
	}
 
	public void setMaximum_distance_constraint_violation(java.lang.Float maximum_distance_constraint_violation)
	{
		this.maximum_distance_constraint_violation = maximum_distance_constraint_violation;
	}

 	protected java.lang.Float maximum_lower_distance_constraint_violation;


	/**
	 *  The maximum lower distance constraint violation for the ensemble.
	 *  0.3
	 */
	public java.lang.Float getMaximum_lower_distance_constraint_violation() 
	{
		return maximum_lower_distance_constraint_violation;
	}
 
	public void setMaximum_lower_distance_constraint_violation(java.lang.Float maximum_lower_distance_constraint_violation)
	{
		this.maximum_lower_distance_constraint_violation = maximum_lower_distance_constraint_violation;
	}

 	protected java.lang.Float maximum_torsion_angle_constraint_violation;


	/**
	 *  The maximum torsion angle constraint violation for the ensemble.
	 *  4
	 */
	public java.lang.Float getMaximum_torsion_angle_constraint_violation() 
	{
		return maximum_torsion_angle_constraint_violation;
	}
 
	public void setMaximum_torsion_angle_constraint_violation(java.lang.Float maximum_torsion_angle_constraint_violation)
	{
		this.maximum_torsion_angle_constraint_violation = maximum_torsion_angle_constraint_violation;
	}

 	protected java.lang.Float maximum_upper_distance_constraint_violation;


	/**
	 *  The maximum upper distance constraint violation for the ensemble.
	 *  0.4
	 */
	public java.lang.Float getMaximum_upper_distance_constraint_violation() 
	{
		return maximum_upper_distance_constraint_violation;
	}
 
	public void setMaximum_upper_distance_constraint_violation(java.lang.Float maximum_upper_distance_constraint_violation)
	{
		this.maximum_upper_distance_constraint_violation = maximum_upper_distance_constraint_violation;
	}

 	protected java.lang.Integer representative_conformer;


	/**
	 *  The number of the conformer identified as most representative.
	 *  20
	 */
	public java.lang.Integer getRepresentative_conformer() 
	{
		return representative_conformer;
	}
 
	public void setRepresentative_conformer(java.lang.Integer representative_conformer)
	{
		this.representative_conformer = representative_conformer;
	}

 	protected java.lang.String torsion_angle_constraint_violation_method;


	/**
	 *  This item describes the method used to calculate the torsion angle constraint violation statistics.
	 *  i.e. are the entered values based on all torsion angle or calculated for violations only?
	 *  Statistics were calculated over all the torsion angle constraints.
	 *  Statistics were calculated for torsion angle constraints violations only.
	 */
	public java.lang.String getTorsion_angle_constraint_violation_method() 
	{
		return torsion_angle_constraint_violation_method;
	}
 
	public void setTorsion_angle_constraint_violation_method(java.lang.String torsion_angle_constraint_violation_method)
	{
		this.torsion_angle_constraint_violation_method = torsion_angle_constraint_violation_method;
	}

 }
