package org.pdb.beans;

/**
 *  Complete description of each NMR sample, including the solvent
 *  system used.
 *  
 *  This example was taken from the study of MCP-1 which is a dimer under the
 *  conditions studied.  Three solutions with different isotope compositions were
 *  studied.
 *  
 *  <PDBx:pdbx_nmr_sample_detailsCategory>
 *  <PDBx:pdbx_nmr_sample_details solution_id="1">
 *  <PDBx:solvent_system>MCP-1</PDBx:solvent_system>
 *  <PDBx:contents>2 mM U-15N,13C, H2O 90 &#37;, D2O 10 &#37;</PDBx:contents>
 *  </PDBx:pdbx_nmr_sample_details>
 *  <PDBx:pdbx_nmr_sample_details solution_id="2">
 *  <PDBx:solvent_system>MCP-1</PDBx:solvent_system>
 *  <PDBx:contents>1 mM U-50&#37; 15N, MCP-1 1 mM U-50&#37; 13C, H2O 90 &#37;, D2O 10 &#37;</PDBx:contents>
 *  </PDBx:pdbx_nmr_sample_details>
 *  <PDBx:pdbx_nmr_sample_details solution_id="3">
 *  <PDBx:solvent_system>MCP-1</PDBx:solvent_system>
 *  <PDBx:contents>2 mM U-15N, H2O 90 &#37;, D2O 10 &#37;</PDBx:contents>
 *  </PDBx:pdbx_nmr_sample_details>
 *  </PDBx:pdbx_nmr_sample_detailsCategory>
 */
public class Pdbx_nmr_sample_details 
{
		protected java.lang.String contents;


	/**
	 *  A complete description of each NMR sample. Include the concentration
	 *  and concentration units for each component (include buffers, etc.). For each
	 *  component describe the isotopic composition, including the % labeling level,
	 *  if known.
	 *  
	 *  For example:
	 *  1. Uniform (random) labeling with 15N: U-15N
	 *  2. Uniform (random) labeling with 13C, 15N at known labeling
	 *  levels: U-95% 13C;U-98% 15N
	 *  3. Residue selective labeling: U-95% 15N-Thymine
	 *  4. Site specific labeling: 95% 13C-Ala18,
	 *  5. Natural abundance labeling in an otherwise uniformly labeled
	 *  biomolecule is designated by NA: U-13C; NA-K,H
	 *  
	 *  
	 *  
	 *  2mM Ribonuclease  U-15N,13C; 50mM phosphate buffer NA; 90% H2O, 10% D2O
	 */
	public java.lang.String getContents() 
	{
		return contents;
	}
 
	public void setContents(java.lang.String contents)
	{
		this.contents = contents;
	}

 	protected java.lang.String solution_id;


	/**
	 *  The name (number) of the sample.
	 *  1
	 *  2
	 *  3
	 */
	public java.lang.String getSolution_id() 
	{
		return solution_id;
	}
 
	public void setSolution_id(java.lang.String solution_id)
	{
		this.solution_id = solution_id;
	}

 	protected java.lang.String solvent_system;


	/**
	 *  The solvent system used for this sample.
	 *  
	 *  90% H2O, 10% D2O
	 */
	public java.lang.String getSolvent_system() 
	{
		return solvent_system;
	}
 
	public void setSolvent_system(java.lang.String solvent_system)
	{
		this.solvent_system = solvent_system;
	}

 }
