package org.pdb.beans;

/**
 *  Record details about each phasing set: (Note: the phasing
 *  set is different from data set. for example: if there are
 *  three data sets, the inflection point (IP), the peak (PK)
 *  and the high remote (HR), the combination of the phasing
 *  set will be IP_iso, PK_iso (the isomorphous repleacement
 *  with HR as 'native'), IP_ano, PK_ano and HR_ano (the
 *  anomalous difference with itself). Therefore, there are
 *  five set used for phasing.
 *  
 *  
 * <pre>
 *  Example 1 -  three wavelengths
 *  <PDBx:pdbx_phasing_MAD_setCategory>
 *  <PDBx:pdbx_phasing_MAD_set id="ISO_1">
 *  <PDBx:d_res_low>22.60</PDBx:d_res_low>
 *  <PDBx:d_res_high>2.00</PDBx:d_res_high>
 *  <PDBx:reflns_acentric>5387</PDBx:reflns_acentric>
 *  <PDBx:reflns_centric>471</PDBx:reflns_centric>
 *  <PDBx:R_cullis_acentric>0.000</PDBx:R_cullis_acentric>
 *  <PDBx:R_cullis_centric>0.000</PDBx:R_cullis_centric>
 *  </PDBx:pdbx_phasing_MAD_set>
 *  <PDBx:pdbx_phasing_MAD_set id="ISO_2">
 *  <PDBx:d_res_low>22.60</PDBx:d_res_low>
 *  <PDBx:d_res_high>2.00</PDBx:d_res_high>
 *  <PDBx:reflns_acentric>5365</PDBx:reflns_acentric>
 *  <PDBx:reflns_centric>469</PDBx:reflns_centric>
 *  <PDBx:R_cullis_acentric>0.803</PDBx:R_cullis_acentric>
 *  <PDBx:R_cullis_centric>0.718</PDBx:R_cullis_centric>
 *  </PDBx:pdbx_phasing_MAD_set>
 *  <PDBx:pdbx_phasing_MAD_set id="ISO_3">
 *  <PDBx:d_res_low>22.60</PDBx:d_res_low>
 *  <PDBx:d_res_high>2.00</PDBx:d_res_high>
 *  <PDBx:reflns_acentric>5317</PDBx:reflns_acentric>
 *  <PDBx:reflns_centric>460</PDBx:reflns_centric>
 *  <PDBx:R_cullis_acentric>0.658</PDBx:R_cullis_acentric>
 *  <PDBx:R_cullis_centric>0.500</PDBx:R_cullis_centric>
 *  </PDBx:pdbx_phasing_MAD_set>
 *  <PDBx:pdbx_phasing_MAD_set id="ANO_1">
 *  <PDBx:d_res_low>22.60</PDBx:d_res_low>
 *  <PDBx:d_res_high>2.00</PDBx:d_res_high>
 *  <PDBx:reflns_acentric>5278</PDBx:reflns_acentric>
 *  <PDBx:reflns_centric>0</PDBx:reflns_centric>
 *  <PDBx:R_cullis_acentric>0.841</PDBx:R_cullis_acentric>
 *  <PDBx:R_cullis_centric>0.000</PDBx:R_cullis_centric>
 *  </PDBx:pdbx_phasing_MAD_set>
 *  <PDBx:pdbx_phasing_MAD_set id="ANO_2">
 *  <PDBx:d_res_low>22.60</PDBx:d_res_low>
 *  <PDBx:d_res_high>2.00</PDBx:d_res_high>
 *  <PDBx:reflns_acentric>5083</PDBx:reflns_acentric>
 *  <PDBx:reflns_centric>0</PDBx:reflns_centric>
 *  <PDBx:R_cullis_acentric>0.649</PDBx:R_cullis_acentric>
 *  <PDBx:R_cullis_centric>0.000</PDBx:R_cullis_centric>
 *  </PDBx:pdbx_phasing_MAD_set>
 *  <PDBx:pdbx_phasing_MAD_set id="ANO_3">
 *  <PDBx:d_res_low>22.60</PDBx:d_res_low>
 *  <PDBx:d_res_high>2.00</PDBx:d_res_high>
 *  <PDBx:reflns_acentric>5329</PDBx:reflns_acentric>
 *  <PDBx:reflns_centric>0</PDBx:reflns_centric>
 *  <PDBx:R_cullis_acentric>0.829</PDBx:R_cullis_acentric>
 *  <PDBx:R_cullis_centric>0.000</PDBx:R_cullis_centric>
 *  </PDBx:pdbx_phasing_MAD_set>
 *  </PDBx:pdbx_phasing_MAD_setCategory>
 * </pre>
 */
public class Pdbx_phasing_MAD_set 
{
		protected java.lang.Float R_cullis;


	/**
	 *  attribute R_cullis in category pdbx_phasing_MAD_set records R_cullis
	 *  for MAD phasing.
	 */
	public java.lang.Float getR_cullis() 
	{
		return R_cullis;
	}
 
	public void setR_cullis(java.lang.Float R_cullis)
	{
		this.R_cullis = R_cullis;
	}

 	protected java.lang.Float R_cullis_acentric;


	/**
	 *  attribute R_cullis_acentric in category pdbx_phasing_MAD_set records R_cullis
	 *  using acentric data for MAD phasing.
	 */
	public java.lang.Float getR_cullis_acentric() 
	{
		return R_cullis_acentric;
	}
 
	public void setR_cullis_acentric(java.lang.Float R_cullis_acentric)
	{
		this.R_cullis_acentric = R_cullis_acentric;
	}

 	protected java.lang.Float R_cullis_centric;


	/**
	 *  attribute R_cullis_centric in category pdbx_phasing_MAD_set records R_cullis
	 *  using centric data for MAD phasing.
	 */
	public java.lang.Float getR_cullis_centric() 
	{
		return R_cullis_centric;
	}
 
	public void setR_cullis_centric(java.lang.Float R_cullis_centric)
	{
		this.R_cullis_centric = R_cullis_centric;
	}

 	protected java.lang.Float R_kraut;


	/**
	 *  attribute R_kraut in category pdbx_phasing_MAD_set records R_kraut
	 *  for MAD phasing.
	 */
	public java.lang.Float getR_kraut() 
	{
		return R_kraut;
	}
 
	public void setR_kraut(java.lang.Float R_kraut)
	{
		this.R_kraut = R_kraut;
	}

 	protected java.lang.Float R_kraut_acentric;


	/**
	 *  attribute r_kraut_acentric in category pdbx_phasing_MAD_set records r_kraut
	 *  using acentric data for MAD phasing.
	 */
	public java.lang.Float getR_kraut_acentric() 
	{
		return R_kraut_acentric;
	}
 
	public void setR_kraut_acentric(java.lang.Float R_kraut_acentric)
	{
		this.R_kraut_acentric = R_kraut_acentric;
	}

 	protected java.lang.Float R_kraut_centric;


	/**
	 *  attribute R_kraut_centric in category pdbx_phasing_MAD_set records r_kraut
	 *  using centric data for MAD phasing.
	 */
	public java.lang.Float getR_kraut_centric() 
	{
		return R_kraut_centric;
	}
 
	public void setR_kraut_centric(java.lang.Float R_kraut_centric)
	{
		this.R_kraut_centric = R_kraut_centric;
	}

 	protected java.lang.Float d_res_high;


	/**
	 *  attribute d_res_high in category pdbx_phasing_MAD_set records the highest resolution
	 *  for the phasing set.
	 */
	public java.lang.Float getD_res_high() 
	{
		return d_res_high;
	}
 
	public void setD_res_high(java.lang.Float d_res_high)
	{
		this.d_res_high = d_res_high;
	}

 	protected java.lang.Float d_res_low;


	/**
	 *  attribute d_res_low in category pdbx_phasing_MAD_set records the lowerest
	 *  resolution for phasing set.
	 */
	public java.lang.Float getD_res_low() 
	{
		return d_res_low;
	}
 
	public void setD_res_low(java.lang.Float d_res_low)
	{
		this.d_res_low = d_res_low;
	}

 	protected java.lang.Float fom;


	/**
	 *  attribute fom in category pdbx_phasing_MAD_set records the figure of merit
	 *  for MAD phasing.
	 */
	public java.lang.Float getFom() 
	{
		return fom;
	}
 
	public void setFom(java.lang.Float fom)
	{
		this.fom = fom;
	}

 	protected java.lang.Float fom_acentric;


	/**
	 *  attribute fom_acentric in category pdbx_phasing_MAD_set records the figure of merit
	 *  using acentric data for MAD phasing.
	 */
	public java.lang.Float getFom_acentric() 
	{
		return fom_acentric;
	}
 
	public void setFom_acentric(java.lang.Float fom_acentric)
	{
		this.fom_acentric = fom_acentric;
	}

 	protected java.lang.Float fom_centric;


	/**
	 *  attribute fom_centric in category pdbx_phasing_MAD_set records the figure of merit
	 *  using centric data for MAD phasing.
	 */
	public java.lang.Float getFom_centric() 
	{
		return fom_centric;
	}
 
	public void setFom_centric(java.lang.Float fom_centric)
	{
		this.fom_centric = fom_centric;
	}

 	protected java.lang.String id_;


	/**
	 *  attribute id in category pdbx_phasing_MAD_set records phase set name
	 *  for MAD phasing.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Float loc;


	/**
	 *  attribute loc in category pdbx_phasing_MAD_set records lack of closure
	 *  for MAD phasing.
	 */
	public java.lang.Float getLoc() 
	{
		return loc;
	}
 
	public void setLoc(java.lang.Float loc)
	{
		this.loc = loc;
	}

 	protected java.lang.Float loc_acentric;


	/**
	 *  attribute loc_acentric in category pdbx_phasing_MAD_set records lack of closure
	 *  using acentric data for MAD phasing.
	 */
	public java.lang.Float getLoc_acentric() 
	{
		return loc_acentric;
	}
 
	public void setLoc_acentric(java.lang.Float loc_acentric)
	{
		this.loc_acentric = loc_acentric;
	}

 	protected java.lang.Float loc_centric;


	/**
	 *  attribute loc_centric in category pdbx_phasing_MAD_set records lack of closure
	 *  using centric data for MAD phasing.
	 */
	public java.lang.Float getLoc_centric() 
	{
		return loc_centric;
	}
 
	public void setLoc_centric(java.lang.Float loc_centric)
	{
		this.loc_centric = loc_centric;
	}

 	protected java.lang.Integer number_of_sites;


	/**
	 *  attribute number_of_sites in category pdbx_phasing_MAD_set records the number of site
	 *  refined for the phasing set.
	 */
	public java.lang.Integer getNumber_of_sites() 
	{
		return number_of_sites;
	}
 
	public void setNumber_of_sites(java.lang.Integer number_of_sites)
	{
		this.number_of_sites = number_of_sites;
	}

 	protected java.lang.Float power;


	/**
	 *  attribute power in category pdbx_phasing_MAD_set records phasing power
	 *  for MAD phasing.
	 */
	public java.lang.Float getPower() 
	{
		return power;
	}
 
	public void setPower(java.lang.Float power)
	{
		this.power = power;
	}

 	protected java.lang.Float power_acentric;


	/**
	 *  attribute power_acentric in category pdbx_phasing_MAD_set records phasing powe
	 *  using acentric data for MAD phasing.
	 */
	public java.lang.Float getPower_acentric() 
	{
		return power_acentric;
	}
 
	public void setPower_acentric(java.lang.Float power_acentric)
	{
		this.power_acentric = power_acentric;
	}

 	protected java.lang.Float power_centric;


	/**
	 *  attribute power_centric in category pdbx_phasing_MAD_set records phasing powe
	 *  using centric data for MAD phasing.
	 */
	public java.lang.Float getPower_centric() 
	{
		return power_centric;
	}
 
	public void setPower_centric(java.lang.Float power_centric)
	{
		this.power_centric = power_centric;
	}

 	protected java.lang.Integer reflns;


	/**
	 *  attribute reflns in category pdbx_phasing_MAD_set records the number of
	 *  reflections used for MAD phasing.
	 */
	public java.lang.Integer getReflns() 
	{
		return reflns;
	}
 
	public void setReflns(java.lang.Integer reflns)
	{
		this.reflns = reflns;
	}

 	protected java.lang.Integer reflns_acentric;


	/**
	 *  attribute reflns_acentric in category pdbx_phasing_MAD_set records the number of
	 *  acentric reflections for MAD phasing.
	 */
	public java.lang.Integer getReflns_acentric() 
	{
		return reflns_acentric;
	}
 
	public void setReflns_acentric(java.lang.Integer reflns_acentric)
	{
		this.reflns_acentric = reflns_acentric;
	}

 	protected java.lang.Integer reflns_centric;


	/**
	 *  attribute reflns_centric in category pdbx_phasing_MAD_set records the number of
	 *  centric reflections for MAD phasing.
	 */
	public java.lang.Integer getReflns_centric() 
	{
		return reflns_centric;
	}
 
	public void setReflns_centric(java.lang.Integer reflns_centric)
	{
		this.reflns_centric = reflns_centric;
	}

 }
