package org.pdb.beans;

/**
 *  Data items in the PDBX_PHASING_MR category record details about
 *  molecular replacement.
 *  
 * <pre>
 *  Example 1 - molecular replacement example from program CNS.
 *  <PDBx:pdbx_phasing_MRCategory>
 *  <PDBx:pdbx_phasing_MR entry_id="ABC001">
 *  <PDBx:method_rotation>real-space rotation search</PDBx:method_rotation>
 *  <PDBx:d_res_high_rotation>3.8</PDBx:d_res_high_rotation>
 *  <PDBx:d_res_low_rotation>13.0</PDBx:d_res_low_rotation>
 *  <PDBx:sigma_F_rotation>1.0</PDBx:sigma_F_rotation>
 *  <PDBx:reflns_percent_rotation>97.8</PDBx:reflns_percent_rotation>
 *  <PDBx:method_translation>gerneral using PC-refinement= e2e2</PDBx:method_translation>
 *  <PDBx:d_res_high_translation>4.0</PDBx:d_res_high_translation>
 *  <PDBx:d_res_low_translation>15.0</PDBx:d_res_low_translation>
 *  <PDBx:sigma_F_translation>0.</PDBx:sigma_F_translation>
 *  <PDBx:reflns_percent_translation>97.7</PDBx:reflns_percent_translation>
 *  <PDBx:correlation_coeff_Fo_to_Fc>0.586</PDBx:correlation_coeff_Fo_to_Fc>
 *  <PDBx:packing>0.3086</PDBx:packing>
 *  </PDBx:pdbx_phasing_MR>
 *  </PDBx:pdbx_phasing_MRCategory>
 * </pre>
 */
public class Pdbx_phasing_MR 
{
		protected java.lang.Float R_factor;


	/**
	 *  The value of  attribute R_factor in category pdbx_phasing_MR identifies the R factor
	 *  (defined as uasual) after rotation and translation.
	 */
	public java.lang.Float getR_factor() 
	{
		return R_factor;
	}
 
	public void setR_factor(java.lang.Float R_factor)
	{
		this.R_factor = R_factor;
	}

 	protected java.lang.Float R_rigid_body;


	/**
	 *  The value of  attribute R_rigid_body in category pdbx_phasing_MR identifies the R factor
	 *  for rigid body refinement after rotation and translation.(In general,
	 *  rigid body refinement has to be carried out after molecular
	 *  replacement.
	 */
	public java.lang.Float getR_rigid_body() 
	{
		return R_rigid_body;
	}
 
	public void setR_rigid_body(java.lang.Float R_rigid_body)
	{
		this.R_rigid_body = R_rigid_body;
	}

 	protected java.lang.Float correlation_coeff_Fo_to_Fc;


	/**
	 *  The value of  attribute correlation_coeff_Fo_to_Fc in category pdbx_phasing_MR identifies
	 *  the correlation between the observed and the calculated structure
	 *  factor after rotation and translation.
	 */
	public java.lang.Float getCorrelation_coeff_Fo_to_Fc() 
	{
		return correlation_coeff_Fo_to_Fc;
	}
 
	public void setCorrelation_coeff_Fo_to_Fc(java.lang.Float correlation_coeff_Fo_to_Fc)
	{
		this.correlation_coeff_Fo_to_Fc = correlation_coeff_Fo_to_Fc;
	}

 	protected java.lang.Float correlation_coeff_Io_to_Ic;


	/**
	 *  The value of  attribute correlation_coeff_Io_to_Ic in category pdbx_phasing_MR identifies
	 *  the correlation between the observed and the calculated intensity
	 *  (~|F|^2) after rotation and translation.
	 */
	public java.lang.Float getCorrelation_coeff_Io_to_Ic() 
	{
		return correlation_coeff_Io_to_Ic;
	}
 
	public void setCorrelation_coeff_Io_to_Ic(java.lang.Float correlation_coeff_Io_to_Ic)
	{
		this.correlation_coeff_Io_to_Ic = correlation_coeff_Io_to_Ic;
	}

 	protected java.lang.Float d_res_high_rotation;


	/**
	 *  The value of  attribute d_res_high_rotation in category pdbx_phasing_MR identifies
	 *  the highest resolution used for rotation search.
	 */
	public java.lang.Float getD_res_high_rotation() 
	{
		return d_res_high_rotation;
	}
 
	public void setD_res_high_rotation(java.lang.Float d_res_high_rotation)
	{
		this.d_res_high_rotation = d_res_high_rotation;
	}

 	protected java.lang.Float d_res_high_translation;


	/**
	 *  The value of  attribute d_res_high_translation in category pdbx_phasing_MR identifies
	 *  the highest resolution used for translation search.
	 */
	public java.lang.Float getD_res_high_translation() 
	{
		return d_res_high_translation;
	}
 
	public void setD_res_high_translation(java.lang.Float d_res_high_translation)
	{
		this.d_res_high_translation = d_res_high_translation;
	}

 	protected java.lang.Float d_res_low_rotation;


	/**
	 *  The value of  attribute d_res_low_rotation in category pdbx_phasing_MR identifies
	 *  the lowest resolution used for rotation search.
	 */
	public java.lang.Float getD_res_low_rotation() 
	{
		return d_res_low_rotation;
	}
 
	public void setD_res_low_rotation(java.lang.Float d_res_low_rotation)
	{
		this.d_res_low_rotation = d_res_low_rotation;
	}

 	protected java.lang.Float d_res_low_translation;


	/**
	 *  The value of  attribute d_res_low_translation in category pdbx_phasing_MR identifies
	 *  the lowest resolution used for translation search.
	 */
	public java.lang.Float getD_res_low_translation() 
	{
		return d_res_low_translation;
	}
 
	public void setD_res_low_translation(java.lang.Float d_res_low_translation)
	{
		this.d_res_low_translation = d_res_low_translation;
	}

 	protected java.lang.String entry_id;


	/**
	 *  The value of  attribute entry_id in category pdbx_phasing_MR identifies the data block.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String method_rotation;


	/**
	 *  The value of  attribute method_rotation in category pdbx_phasing_MR identifies the method
	 *  used for rotation search. For example, the rotation method may be
	 *  realspace,  fastdirect, or direct.
	 *  .
	 */
	public java.lang.String getMethod_rotation() 
	{
		return method_rotation;
	}
 
	public void setMethod_rotation(java.lang.String method_rotation)
	{
		this.method_rotation = method_rotation;
	}

 	protected java.lang.String method_translation;


	/**
	 *  The value of  attribute method_translation in category pdbx_phasing_MR identifies the method
	 *  used for translation search. For example in CNS, the translation method
	 *  may be "general" or "phased" with PC refinement target using
	 *  "fastf2f2" "e2e2" "e1e1" "f2f2" "f1f1" "residual" "vector".
	 *  
	 *  .
	 */
	public java.lang.String getMethod_translation() 
	{
		return method_translation;
	}
 
	public void setMethod_translation(java.lang.String method_translation)
	{
		this.method_translation = method_translation;
	}

 	protected java.lang.String model_details;


	/**
	 *  The value of  attribute model_details in category pdbx_phasing_MR records the details of
	 *  model used. For example, the original model can be truncated by
	 *  deleting side chains,  doubtful parts, using the monomer if the
	 *  original model was an oligomer. The search model may be one
	 *  domain of a large molecule. What is the pdb IDs.
	 */
	public java.lang.String getModel_details() 
	{
		return model_details;
	}
 
	public void setModel_details(java.lang.String model_details)
	{
		this.model_details = model_details;
	}

 	protected java.lang.String native_set_id;


	/**
	 *  The data set that was treated as the native in this
	 *  experiment.
	 *  
	 *  This data item is a pointer to  attribute id in category phasing_set in the
	 *  PHASING_SET category.
	 */
	public java.lang.String getNative_set_id() 
	{
		return native_set_id;
	}
 
	public void setNative_set_id(java.lang.String native_set_id)
	{
		this.native_set_id = native_set_id;
	}

 	protected java.lang.Float packing;


	/**
	 *  The value of  attribute packing in category pdbx_phasing_MR identifies the packing of
	 *  search model in the unit cell. Too many crystallographic contacts
	 *  may indicate a bad search.
	 */
	public java.lang.Float getPacking() 
	{
		return packing;
	}
 
	public void setPacking(java.lang.Float packing)
	{
		this.packing = packing;
	}

 	protected java.lang.Float reflns_percent_rotation;


	/**
	 *  The value of  attribute reflns_percent_rotation in category pdbx_phasing_MR identifies the
	 *  completness of data used for rotation search.
	 */
	public java.lang.Float getReflns_percent_rotation() 
	{
		return reflns_percent_rotation;
	}
 
	public void setReflns_percent_rotation(java.lang.Float reflns_percent_rotation)
	{
		this.reflns_percent_rotation = reflns_percent_rotation;
	}

 	protected java.lang.Float reflns_percent_translation;


	/**
	 *  The value of  attribute reflns_percent_translation in category pdbx_phasing_MR identifies the
	 *  completness of data used for translation search.
	 */
	public java.lang.Float getReflns_percent_translation() 
	{
		return reflns_percent_translation;
	}
 
	public void setReflns_percent_translation(java.lang.Float reflns_percent_translation)
	{
		this.reflns_percent_translation = reflns_percent_translation;
	}

 	protected java.lang.Float sigma_F_rotation;


	/**
	 *  The value of  attribute sigma_F_rotation in category pdbx_phasing_MR identifies the
	 *  sigma cut off of structure factor used for rotation search.
	 */
	public java.lang.Float getSigma_F_rotation() 
	{
		return sigma_F_rotation;
	}
 
	public void setSigma_F_rotation(java.lang.Float sigma_F_rotation)
	{
		this.sigma_F_rotation = sigma_F_rotation;
	}

 	protected java.lang.Float sigma_F_translation;


	/**
	 *  The value of  attribute sigma_F_translation in category pdbx_phasing_MR identifies the
	 *  sigma cut off of structure factor used for translation search.
	 */
	public java.lang.Float getSigma_F_translation() 
	{
		return sigma_F_translation;
	}
 
	public void setSigma_F_translation(java.lang.Float sigma_F_translation)
	{
		this.sigma_F_translation = sigma_F_translation;
	}

 	protected java.lang.Float sigma_I_rotation;


	/**
	 *  The value of  attribute sigma_I_rotation in category pdbx_phasing_MR identifies the
	 *  sigma cut off of intensity used for rotation search.
	 */
	public java.lang.Float getSigma_I_rotation() 
	{
		return sigma_I_rotation;
	}
 
	public void setSigma_I_rotation(java.lang.Float sigma_I_rotation)
	{
		this.sigma_I_rotation = sigma_I_rotation;
	}

 	protected java.lang.Float sigma_I_translation;


	/**
	 *  The value of  attribute sigma_I_translation in category pdbx_phasing_MR identifies the
	 *  sigma cut off of intensity used for translation search.
	 */
	public java.lang.Float getSigma_I_translation() 
	{
		return sigma_I_translation;
	}
 
	public void setSigma_I_translation(java.lang.Float sigma_I_translation)
	{
		this.sigma_I_translation = sigma_I_translation;
	}

 }
