package org.pdb.beans;

/**
 *  Data items in the PDBX_PHASING_DM_SHELL category record details about
 *  density modification in resolution shell.
 *  
 * <pre>
 *  Example 1 - density modification with shells
 *  <PDBx:pdbx_phasing_dm_shellCategory>
 *  <PDBx:pdbx_phasing_dm_shell d_res_low="100.00" d_res_high="7.73">
 *  <PDBx:reflns>502</PDBx:reflns>
 *  <PDBx:fom>0.879</PDBx:fom>
 *  <PDBx:delta_phi_final>24.7</PDBx:delta_phi_final>
 *  </PDBx:pdbx_phasing_dm_shell>
 *  <PDBx:pdbx_phasing_dm_shell d_res_low="7.73" d_res_high="6.24">
 *  <PDBx:reflns>506</PDBx:reflns>
 *  <PDBx:fom>0.857</PDBx:fom>
 *  <PDBx:delta_phi_final>29.2</PDBx:delta_phi_final>
 *  </PDBx:pdbx_phasing_dm_shell>
 *  <PDBx:pdbx_phasing_dm_shell d_res_low="6.24" d_res_high="5.50">
 *  <PDBx:reflns>504</PDBx:reflns>
 *  <PDBx:fom>0.838</PDBx:fom>
 *  <PDBx:delta_phi_final>29.2</PDBx:delta_phi_final>
 *  </PDBx:pdbx_phasing_dm_shell>
 *  <PDBx:pdbx_phasing_dm_shell d_res_low="5.50" d_res_high="5.02">
 *  <PDBx:reflns>502</PDBx:reflns>
 *  <PDBx:fom>0.851</PDBx:fom>
 *  <PDBx:delta_phi_final>25.3</PDBx:delta_phi_final>
 *  </PDBx:pdbx_phasing_dm_shell>
 *  <PDBx:pdbx_phasing_dm_shell d_res_low="5.02" d_res_high="4.67">
 *  <PDBx:reflns>503</PDBx:reflns>
 *  <PDBx:fom>0.831</PDBx:fom>
 *  <PDBx:delta_phi_final>22.7</PDBx:delta_phi_final>
 *  </PDBx:pdbx_phasing_dm_shell>
 *  </PDBx:pdbx_phasing_dm_shellCategory>
 * </pre>
 */
public class Pdbx_phasing_dm_shell 
{
		protected java.lang.Float d_res_high;


	/**
	 *  The value of  attribute d_res_high in category pdbx_phasing_dm_shell identifies high resolution
	 */
	public java.lang.Float getD_res_high() 
	{
		return d_res_high;
	}
 
	public void setD_res_high(java.lang.Float d_res_high)
	{
		this.d_res_high = d_res_high;
	}

 	protected java.lang.Float d_res_low;


	/**
	 *  The value of  attribute d_res_low in category pdbx_phasing_dm_shell identifies low resolution
	 */
	public java.lang.Float getD_res_low() 
	{
		return d_res_low;
	}
 
	public void setD_res_low(java.lang.Float d_res_low)
	{
		this.d_res_low = d_res_low;
	}

 	protected java.lang.Float delta_phi_final;


	/**
	 *  The value of  attribute delta_phi_final in category pdbx_phasing_dm_shell identifies phase difference
	 *  after density modification with resolution shells.
	 */
	public java.lang.Float getDelta_phi_final() 
	{
		return delta_phi_final;
	}
 
	public void setDelta_phi_final(java.lang.Float delta_phi_final)
	{
		this.delta_phi_final = delta_phi_final;
	}

 	protected java.lang.Float delta_phi_initial;


	/**
	 *  The value of  attribute delta_phi_initial in category pdbx_phasing_dm_shell identifies phase difference
	 *  before density modification with resolution shells.
	 */
	public java.lang.Float getDelta_phi_initial() 
	{
		return delta_phi_initial;
	}
 
	public void setDelta_phi_initial(java.lang.Float delta_phi_initial)
	{
		this.delta_phi_initial = delta_phi_initial;
	}

 	protected java.lang.Float fom;


	/**
	 *  The value of  attribute fom in category pdbx_phasing_dm_shell identifies the figure of merit
	 *  for all the data with resolution shells.
	 */
	public java.lang.Float getFom() 
	{
		return fom;
	}
 
	public void setFom(java.lang.Float fom)
	{
		this.fom = fom;
	}

 	protected java.lang.Float fom_acentric;


	/**
	 *  The value of  attribute fom_acentric in category pdbx_phasing_dm_shell identifies the figure of merit
	 *  for acentric data with resolution shells
	 */
	public java.lang.Float getFom_acentric() 
	{
		return fom_acentric;
	}
 
	public void setFom_acentric(java.lang.Float fom_acentric)
	{
		this.fom_acentric = fom_acentric;
	}

 	protected java.lang.Float fom_centric;


	/**
	 *  The value of  attribute fom_centric in category pdbx_phasing_dm_shell identifies the figure of merit
	 *  for centric data with resolution shells.
	 */
	public java.lang.Float getFom_centric() 
	{
		return fom_centric;
	}
 
	public void setFom_centric(java.lang.Float fom_centric)
	{
		this.fom_centric = fom_centric;
	}

 	protected java.lang.Integer reflns;


	/**
	 *  The value of  attribute reflns in category pdbx_phasing_dm_shell identifies the number
	 *  of centric and acentric reflections with resolution shells.
	 */
	public java.lang.Integer getReflns() 
	{
		return reflns;
	}
 
	public void setReflns(java.lang.Integer reflns)
	{
		this.reflns = reflns;
	}

 	protected java.lang.Integer reflns_acentric;


	/**
	 *  The value of  attribute reflns_acentric in category pdbx_phasing_dm_shell identifies the number
	 *  of acentric reflections with resolution shells.
	 */
	public java.lang.Integer getReflns_acentric() 
	{
		return reflns_acentric;
	}
 
	public void setReflns_acentric(java.lang.Integer reflns_acentric)
	{
		this.reflns_acentric = reflns_acentric;
	}

 	protected java.lang.Integer reflns_centric;


	/**
	 *  The value of  attribute reflns_centric in category pdbx_phasing_dm_shell identifies the number
	 *  of centric reflections with resolution shells.
	 */
	public java.lang.Integer getReflns_centric() 
	{
		return reflns_centric;
	}
 
	public void setReflns_centric(java.lang.Integer reflns_centric)
	{
		this.reflns_centric = reflns_centric;
	}

 }
