package org.pdb.beans;

/**
 *  Describes the origin of the experimental data used in this
 *  entry.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_re_refinementCategory>
 *  <PDBx:pdbx_re_refinement entry_id="1ABC">
 *  <PDBx:citation_id>2</PDBx:citation_id>
 *  <PDBx:details>Re-refinement of data from entry 1ABC</PDBx:details>
 *  </PDBx:pdbx_re_refinement>
 *  </PDBx:pdbx_re_refinementCategory>
 * </pre>
 */
public class Pdbx_re_refinement 
{
		protected java.lang.String citation_id;


	/**
	 *  A pointer to  attribute id in category citation in category CITATION describing the
	 *  the citation of the entry from from which the experimental data
	 *  was obtained.
	 */
	public java.lang.String getCitation_id() 
	{
		return citation_id;
	}
 
	public void setCitation_id(java.lang.String citation_id)
	{
		this.citation_id = citation_id;
	}

 	protected java.lang.String details;


	/**
	 *  Additional details about this re-refinement.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entry_id;


	/**
	 *  The identifier for entry where the experimental data was obtained.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 }
