package org.pdb.beans;

/**
 *  Data items in the PDBX_REFINE category record details about
 *  additional structure refinement parameters which are needed
 *  to complete legacy REMARK 3 refinement templates in PDB
 *  format files.
 *  
 * <pre>
 *  Example 1 - PDB placeholders for refinement program SHELX
 *  <PDBx:pdbx_refineCategory>
 *  <PDBx:pdbx_refine entry_id="ABC001">
 *  <PDBx:R_factor_all_4sig_cutoff>0.174</PDBx:R_factor_all_4sig_cutoff>
 *  <PDBx:R_factor_obs_4sig_cutoff>0.169</PDBx:R_factor_obs_4sig_cutoff>
 *  <PDBx:number_reflns_obs_4sig_cutoff>1263.</PDBx:number_reflns_obs_4sig_cutoff>
 *  <PDBx:free_R_factor_4sig_cutoff>0.216</PDBx:free_R_factor_4sig_cutoff>
 *  <PDBx:free_R_val_test_set_ct_4sig_cutoff>164.</PDBx:free_R_val_test_set_ct_4sig_cutoff>
 *  <PDBx:free_R_val_test_set_size_perc_4sig_cutoff>1.29</PDBx:free_R_val_test_set_size_perc_4sig_cutoff>
 *  </PDBx:pdbx_refine>
 *  </PDBx:pdbx_refineCategory>
 * </pre>
 */
public class Pdbx_refine 
{
		protected java.lang.Float R_factor_all_4sig_cutoff;


	/**
	 *  R-value (all reflections, 4 sigma cutoff)
	 *  Placeholder for PDB mapping of SHELXL refinement data.
	 *  0.174
	 */
	public java.lang.Float getR_factor_all_4sig_cutoff() 
	{
		return R_factor_all_4sig_cutoff;
	}
 
	public void setR_factor_all_4sig_cutoff(java.lang.Float R_factor_all_4sig_cutoff)
	{
		this.R_factor_all_4sig_cutoff = R_factor_all_4sig_cutoff;
	}

 	protected java.lang.Float R_factor_all_no_cutoff;


	/**
	 *  R-value (all reflections, no cutoff)
	 *  Placeholder for PDB mapping of SHELXL refinement data.
	 */
	public java.lang.Float getR_factor_all_no_cutoff() 
	{
		return R_factor_all_no_cutoff;
	}
 
	public void setR_factor_all_no_cutoff(java.lang.Float R_factor_all_no_cutoff)
	{
		this.R_factor_all_no_cutoff = R_factor_all_no_cutoff;
	}

 	protected java.lang.Float R_factor_obs_4sig_cutoff;


	/**
	 *  R-value (working set, 4 sigma cutoff)
	 *  Placeholder for PDB mapping of SHELXL refinement data.
	 *  0.169
	 */
	public java.lang.Float getR_factor_obs_4sig_cutoff() 
	{
		return R_factor_obs_4sig_cutoff;
	}
 
	public void setR_factor_obs_4sig_cutoff(java.lang.Float R_factor_obs_4sig_cutoff)
	{
		this.R_factor_obs_4sig_cutoff = R_factor_obs_4sig_cutoff;
	}

 	protected java.lang.Float R_factor_obs_no_cutoff;


	/**
	 *  R-value (working set reflections, no cutoff)
	 *  Placeholder for PDB mapping of SHELXL refinement data.
	 */
	public java.lang.Float getR_factor_obs_no_cutoff() 
	{
		return R_factor_obs_no_cutoff;
	}
 
	public void setR_factor_obs_no_cutoff(java.lang.Float R_factor_obs_no_cutoff)
	{
		this.R_factor_obs_no_cutoff = R_factor_obs_no_cutoff;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.Float free_R_error_no_cutoff;


	/**
	 *  Free R-value error(no cutoff)
	 */
	public java.lang.Float getFree_R_error_no_cutoff() 
	{
		return free_R_error_no_cutoff;
	}
 
	public void setFree_R_error_no_cutoff(java.lang.Float free_R_error_no_cutoff)
	{
		this.free_R_error_no_cutoff = free_R_error_no_cutoff;
	}

 	protected java.lang.Float free_R_factor_4sig_cutoff;


	/**
	 *  R free value (4 sigma cutoff).
	 *  Placeholder for PDB mapping of SHELXL refinement data.
	 *  0.216
	 */
	public java.lang.Float getFree_R_factor_4sig_cutoff() 
	{
		return free_R_factor_4sig_cutoff;
	}
 
	public void setFree_R_factor_4sig_cutoff(java.lang.Float free_R_factor_4sig_cutoff)
	{
		this.free_R_factor_4sig_cutoff = free_R_factor_4sig_cutoff;
	}

 	protected java.lang.Float free_R_factor_no_cutoff;


	/**
	 *  Free R-value (no cutoff)
	 *  Placeholder for PDB mapping of SHELXL refinement data.
	 */
	public java.lang.Float getFree_R_factor_no_cutoff() 
	{
		return free_R_factor_no_cutoff;
	}
 
	public void setFree_R_factor_no_cutoff(java.lang.Float free_R_factor_no_cutoff)
	{
		this.free_R_factor_no_cutoff = free_R_factor_no_cutoff;
	}

 	protected java.lang.Float free_R_val_4sig_cutoff;


	/**
	 *  Free R-value (4 sigma cutoff)
	 *  Placeholder for PDB mapping of SHELXL refinement data.
	 */
	public java.lang.Float getFree_R_val_4sig_cutoff() 
	{
		return free_R_val_4sig_cutoff;
	}
 
	public void setFree_R_val_4sig_cutoff(java.lang.Float free_R_val_4sig_cutoff)
	{
		this.free_R_val_4sig_cutoff = free_R_val_4sig_cutoff;
	}

 	protected java.lang.Float free_R_val_test_set_ct_4sig_cutoff;


	/**
	 *  Free R-value test set count (4 sigma cutoff)
	 *  Placeholder for PDB mapping of SHELXL refinement data.
	 *  164
	 */
	public java.lang.Float getFree_R_val_test_set_ct_4sig_cutoff() 
	{
		return free_R_val_test_set_ct_4sig_cutoff;
	}
 
	public void setFree_R_val_test_set_ct_4sig_cutoff(java.lang.Float free_R_val_test_set_ct_4sig_cutoff)
	{
		this.free_R_val_test_set_ct_4sig_cutoff = free_R_val_test_set_ct_4sig_cutoff;
	}

 	protected java.lang.Float free_R_val_test_set_ct_no_cutoff;


	/**
	 *  Free R-value test set count (no cutoff)
	 *  Placeholder for PDB mapping of SHELXL refinement data.
	 */
	public java.lang.Float getFree_R_val_test_set_ct_no_cutoff() 
	{
		return free_R_val_test_set_ct_no_cutoff;
	}
 
	public void setFree_R_val_test_set_ct_no_cutoff(java.lang.Float free_R_val_test_set_ct_no_cutoff)
	{
		this.free_R_val_test_set_ct_no_cutoff = free_R_val_test_set_ct_no_cutoff;
	}

 	protected java.lang.Float free_R_val_test_set_size_perc_4sig_cutoff;


	/**
	 *  Free R-value test set size (in percent, 4 sigma cutoff)
	 *  Placeholder for PDB mapping of SHELXL refinement data.
	 *  1.29
	 */
	public java.lang.Float getFree_R_val_test_set_size_perc_4sig_cutoff() 
	{
		return free_R_val_test_set_size_perc_4sig_cutoff;
	}
 
	public void setFree_R_val_test_set_size_perc_4sig_cutoff(java.lang.Float free_R_val_test_set_size_perc_4sig_cutoff)
	{
		this.free_R_val_test_set_size_perc_4sig_cutoff = free_R_val_test_set_size_perc_4sig_cutoff;
	}

 	protected java.lang.Float free_R_val_test_set_size_perc_no_cutoff;


	/**
	 *  Free R-value test set size (in percent, no cutoff)
	 *  Placeholder for PDB mapping of SHELXL refinement data.
	 */
	public java.lang.Float getFree_R_val_test_set_size_perc_no_cutoff() 
	{
		return free_R_val_test_set_size_perc_no_cutoff;
	}
 
	public void setFree_R_val_test_set_size_perc_no_cutoff(java.lang.Float free_R_val_test_set_size_perc_no_cutoff)
	{
		this.free_R_val_test_set_size_perc_no_cutoff = free_R_val_test_set_size_perc_no_cutoff;
	}

 	protected java.lang.Float number_reflns_obs_4sig_cutoff;


	/**
	 *  Total number of reflections (4 sigma cutoff).
	 *  Placeholder for PDB mapping of SHELXL refinement data.
	 *  1263
	 */
	public java.lang.Float getNumber_reflns_obs_4sig_cutoff() 
	{
		return number_reflns_obs_4sig_cutoff;
	}
 
	public void setNumber_reflns_obs_4sig_cutoff(java.lang.Float number_reflns_obs_4sig_cutoff)
	{
		this.number_reflns_obs_4sig_cutoff = number_reflns_obs_4sig_cutoff;
	}

 	protected java.lang.Float number_reflns_obs_no_cutoff;


	/**
	 *  Total number of reflections (no cutoff).
	 *  Placeholder for PDB mapping of SHELXL refinement data.
	 */
	public java.lang.Float getNumber_reflns_obs_no_cutoff() 
	{
		return number_reflns_obs_no_cutoff;
	}
 
	public void setNumber_reflns_obs_no_cutoff(java.lang.Float number_reflns_obs_no_cutoff)
	{
		this.number_reflns_obs_no_cutoff = number_reflns_obs_no_cutoff;
	}

 }
