package org.pdb.beans;

/**
 *  Data items in the PDBX_REFINE_COMPONENT category record
 *  statistics of the final model relative to the density map.
 *  
 * <pre>
 *  Example 1 -
 * </pre>
 */
public class Pdbx_refine_component 
{
		protected java.lang.Float B_iso;


	/**
	 *  The average isotropic B factors for the group of atoms
	 *  (e.g. residue or ligand, side chain, main chain).
	 *  The B factors for each atom is given by  attribute B_iso_or_equiv in category atom_site
	 */
	public java.lang.Float getB_iso() 
	{
		return B_iso;
	}
 
	public void setB_iso(java.lang.Float B_iso)
	{
		this.B_iso = B_iso;
	}

 	protected java.lang.Float B_iso_main_chain;


	/**
	 *  The average isotropic B factors for the group of atoms
	 *  (e.g. residue or ligand, side chain, main chain).
	 *  The B factors for each atom is given by  attribute B_iso_or_equiv in category atom_site
	 */
	public java.lang.Float getB_iso_main_chain() 
	{
		return B_iso_main_chain;
	}
 
	public void setB_iso_main_chain(java.lang.Float B_iso_main_chain)
	{
		this.B_iso_main_chain = B_iso_main_chain;
	}

 	protected java.lang.Float B_iso_side_chain;


	/**
	 *  The average isotropic B factors for the group of atoms
	 *  (e.g. residue or ligand, side chain, main chain).
	 *  The B factors for each atom is given by  attribute B_iso_or_equiv in category atom_site
	 */
	public java.lang.Float getB_iso_side_chain() 
	{
		return B_iso_side_chain;
	}
 
	public void setB_iso_side_chain(java.lang.Float B_iso_side_chain)
	{
		this.B_iso_side_chain = B_iso_side_chain;
	}

 	protected java.lang.String auth_asym_id;


	/**
	 *  A component of the identifier for the component.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAuth_asym_id() 
	{
		return auth_asym_id;
	}
 
	public void setAuth_asym_id(java.lang.String auth_asym_id)
	{
		this.auth_asym_id = auth_asym_id;
	}

 	protected java.lang.String auth_comp_id;


	/**
	 *  A component of the identifier for the component.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAuth_comp_id() 
	{
		return auth_comp_id;
	}
 
	public void setAuth_comp_id(java.lang.String auth_comp_id)
	{
		this.auth_comp_id = auth_comp_id;
	}

 	protected java.lang.String auth_seq_id;


	/**
	 *  A component of the identifier for the component.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAuth_seq_id() 
	{
		return auth_seq_id;
	}
 
	public void setAuth_seq_id(java.lang.String auth_seq_id)
	{
		this.auth_seq_id = auth_seq_id;
	}

 	protected java.lang.Float connect;


	/**
	 *  The index of connectivity is the product of the (2Fobs-Fcal) electron
	 *  density values for the backbone atoms (N, CA and C) divided by the
	 *  average value for the structure. Low values (less than 1.0) of this
	 *  index indicate breaks in the backbone electron density which may be
	 *  due to flexibility of the chain or incorrect tracing.
	 *  
	 *  connect = [(D(xi)...D(xi))^(1/N)] /<D>_all
	 *  
	 *  Where:
	 *  D(xi) = (2*Fobs - Fcal)
	 *  <D>_all is the averaged value of density for the structure.
	 *  The product is for N atoms of group.
	 *  
	 *  Ref: Vaguine, A.A., Richelle, J. & Wodak, S.J. (1999). Acta Cryst. D55,199-205
	 */
	public java.lang.Float getConnect() 
	{
		return connect;
	}
 
	public void setConnect(java.lang.Float connect)
	{
		this.connect = connect;
	}

 	protected java.lang.Float correlation;


	/**
	 *  Correlation coefficient of electron density for each residue or ligand,
	 *  side chain, main chain
	 *  
	 *  The density correlation coefficient is calculated for each component
	 *  from atomic densities of (2Fobs-Fcalc) map - "Robs" and the model
	 *  map (Fcalc) - "Rcalc" :
	 *  
	 *  D_corr =  <Robs><Rcalc>/sqrt(<Robs**2><Rcalc**2>)
	 *  
	 *  where <Robs> is the mean of "observed" densities of atoms of the
	 *  component (backbone or side chain).
	 *  
	 *  <Rcalc> is the mean of "calculated" densities of
	 *  component atoms.
	 *  
	 *  The value of density for some atom from map R(x) is:
	 *  
	 *  sum_i ( R(xi) * Ratom(xi - xa) )
	 *  Dens =  ----------------------------------
	 *  sum_i ( Ratom(xi - xa) )
	 *  
	 *  where  Ratom(x) is atomic electron density for the x-th grid point.
	 *  xa - vector of the centre of atom.
	 *  xi - vector of the i-th point of grid.
	 *  Sum is taken over all grid points which have distance
	 *  from the center of the atom less than the Radius_limit.
	 *  For all atoms Radius_limit = 2.5 A.
	 *  
	 *  Ref: Vaguine, A.A., Richelle, J. & Wodak, S.J. (1999). Acta Cryst. D55,199-205
	 */
	public java.lang.Float getCorrelation() 
	{
		return correlation;
	}
 
	public void setCorrelation(java.lang.Float correlation)
	{
		this.correlation = correlation;
	}

 	protected java.lang.Float correlation_main_chain;


	/**
	 *  Correlation coefficient of electron density for each residue or ligand,
	 *  side chain, main chain
	 *  
	 *  The density correlation coefficient is calculated for each component
	 *  from atomic densities of (2Fobs-Fcalc) map - "Robs" and the model
	 *  map (Fcalc) - "Rcalc" :
	 *  
	 *  D_corr =  <Robs><Rcalc>/sqrt(<Robs**2><Rcalc**2>)
	 *  
	 *  where <Robs> is the mean of "observed" densities of atoms of the
	 *  component (backbone or side chain).
	 *  
	 *  <Rcalc> is the mean of "calculated" densities of
	 *  component atoms.
	 *  
	 *  The value of density for some atom from map R(x) is:
	 *  
	 *  sum_i ( R(xi) * Ratom(xi - xa) )
	 *  Dens =  ----------------------------------
	 *  sum_i ( Ratom(xi - xa) )
	 *  
	 *  where  Ratom(x) is atomic electron density for the x-th grid point.
	 *  xa - vector of the centre of atom.
	 *  xi - vector of the i-th point of grid.
	 *  Sum is taken over all grid points which have distance
	 *  from the center of the atom less than the Radius_limit.
	 *  For all atoms Radius_limit = 2.5 A.
	 *  
	 *  Ref: Vaguine, A.A., Richelle, J. & Wodak, S.J. (1999). Acta Cryst. D55,199-205
	 */
	public java.lang.Float getCorrelation_main_chain() 
	{
		return correlation_main_chain;
	}
 
	public void setCorrelation_main_chain(java.lang.Float correlation_main_chain)
	{
		this.correlation_main_chain = correlation_main_chain;
	}

 	protected java.lang.Float correlation_side_chain;


	/**
	 *  Correlation coefficient of electron density for each residue or ligand,
	 *  side chain, main chain
	 *  
	 *  The density correlation coefficient is calculated for each component
	 *  from atomic densities of (2Fobs-Fcalc) map - "Robs" and the model
	 *  map (Fcalc) - "Rcalc" :
	 *  
	 *  D_corr =  <Robs><Rcalc>/sqrt(<Robs**2><Rcalc**2>)
	 *  
	 *  where <Robs> is the mean of "observed" densities of atoms of the
	 *  component (backbone or side chain).
	 *  
	 *  <Rcalc> is the mean of "calculated" densities of
	 *  component atoms.
	 *  
	 *  The value of density for some atom from map R(x) is:
	 *  
	 *  sum_i ( R(xi) * Ratom(xi - xa) )
	 *  Dens =  ----------------------------------
	 *  sum_i ( Ratom(xi - xa) )
	 *  
	 *  where  Ratom(x) is atomic electron density for the x-th grid point.
	 *  xa - vector of the centre of atom.
	 *  xi - vector of the i-th point of grid.
	 *  Sum is taken over all grid points which have distance
	 *  from the center of the atom less than the Radius_limit.
	 *  For all atoms Radius_limit = 2.5 A.
	 *  
	 *  Ref: Vaguine, A.A., Richelle, J. & Wodak, S.J. (1999). Acta Cryst. D55,199-205
	 */
	public java.lang.Float getCorrelation_side_chain() 
	{
		return correlation_side_chain;
	}
 
	public void setCorrelation_side_chain(java.lang.Float correlation_side_chain)
	{
		this.correlation_side_chain = correlation_side_chain;
	}

 	protected java.lang.Float density_index;


	/**
	 *  The index of density is the product of the (2Fobs-Fcal) electron
	 *  density values for the group of atoms divided by the average value
	 *  for the structure. Low values (less than 1.0) may be problematic for
	 *  model fitting.
	 *  
	 *  index = [(D(xi)...D(xi))^(1/N)] /<D>_all
	 *  
	 *  Where :
	 *  D(xi) = (2*Fobs - Fcal)
	 *  <D>_all is the averaged value of density for the structure.
	 *  The product is for N atoms of group.
	 *  
	 *  Ref: Vaguine, A.A., Richelle, J. & Wodak, S.J. (1999). Acta Cryst. D55,199-205
	 */
	public java.lang.Float getDensity_index() 
	{
		return density_index;
	}
 
	public void setDensity_index(java.lang.Float density_index)
	{
		this.density_index = density_index;
	}

 	protected java.lang.Float density_index_main_chain;


	/**
	 *  The index of density is the product of the (2Fobs-Fcal) electron
	 *  density values for the group of atoms divided by the average value
	 *  for the structure. Low values (less than 1.0) may be problematic for
	 *  model fitting.
	 *  
	 *  index = [(D(xi)...D(xi))^(1/N)] /<D>_all
	 *  
	 *  Where :
	 *  D(xi) = (2*Fobs - Fcal)
	 *  <D>_all is the averaged value of density for the structure.
	 *  The product is for N atoms of group.
	 *  
	 *  Ref: Vaguine, A.A., Richelle, J. & Wodak, S.J. (1999). Acta Cryst. D55,199-205
	 */
	public java.lang.Float getDensity_index_main_chain() 
	{
		return density_index_main_chain;
	}
 
	public void setDensity_index_main_chain(java.lang.Float density_index_main_chain)
	{
		this.density_index_main_chain = density_index_main_chain;
	}

 	protected java.lang.Float density_index_side_chain;


	/**
	 *  The index of density is the product of the (2Fobs-Fcal) electron
	 *  density values for the group of atoms divided by the average value
	 *  for the structure. Low values (less than 1.0) may be problematic for
	 *  model fitting.
	 *  
	 *  index = [(D(xi)...D(xi))^(1/N)] /<D>_all
	 *  
	 *  Where :
	 *  D(xi) = (2*Fobs - Fcal)
	 *  <D>_all is the averaged value of density for the structure.
	 *  The product is for N atoms of group.
	 *  
	 *  Ref: Vaguine, A.A., Richelle, J. & Wodak, S.J. (1999). Acta Cryst. D55,199-205
	 */
	public java.lang.Float getDensity_index_side_chain() 
	{
		return density_index_side_chain;
	}
 
	public void setDensity_index_side_chain(java.lang.Float density_index_side_chain)
	{
		this.density_index_side_chain = density_index_side_chain;
	}

 	protected java.lang.Float density_ratio;


	/**
	 *  The density ratio is similar to the density index, but summation of the
	 *  density for the group is used for calculation.
	 *  
	 *  The ratio of density is the summation of the (2Fobs-Fcal) electron
	 *  density values for the group of atoms divided by the average value
	 *  for the structure. Low values (less than 0.4) of this ratio may be
	 *  problematic for the group.
	 *  
	 *  
	 *  index = [Sum~i D(xi)]/<D>_all
	 *  
	 *  Where:
	 *  
	 *  D(xi) = (2*Fobs - Fcal)
	 *  <D>_all is the average value of density for the structure.
	 *  The summation is for all the atoms of group.
	 */
	public java.lang.Float getDensity_ratio() 
	{
		return density_ratio;
	}
 
	public void setDensity_ratio(java.lang.Float density_ratio)
	{
		this.density_ratio = density_ratio;
	}

 	protected java.lang.Float density_ratio_main_chain;


	/**
	 *  The density ratio is similar to the density index, but summation of the
	 *  density for the group is used for calculation.
	 *  
	 *  The ratio of density is the summation of the (2Fobs-Fcal) electron
	 *  density values for the group of atoms divided by the average value
	 *  for the structure. Low values (less than 0.4) of this ratio may be
	 *  problematic for the group.
	 *  
	 *  
	 *  index = [Sum~i D(xi)]/<D>_all
	 *  
	 *  Where:
	 *  
	 *  D(xi) = (2*Fobs - Fcal)
	 *  <D>_all is the average value of density for the structure.
	 *  The summation is for all the atoms of group.
	 */
	public java.lang.Float getDensity_ratio_main_chain() 
	{
		return density_ratio_main_chain;
	}
 
	public void setDensity_ratio_main_chain(java.lang.Float density_ratio_main_chain)
	{
		this.density_ratio_main_chain = density_ratio_main_chain;
	}

 	protected java.lang.Float density_ratio_side_chain;


	/**
	 *  The density ratio is similar to the density index, but summation of the
	 *  density for the group is used for calculation.
	 *  
	 *  The ratio of density is the summation of the (2Fobs-Fcal) electron
	 *  density values for the group of atoms divided by the average value
	 *  for the structure. Low values (less than 0.4) of this ratio may be
	 *  problematic for the group.
	 *  
	 *  
	 *  index = [Sum~i D(xi)]/<D>_all
	 *  
	 *  Where:
	 *  
	 *  D(xi) = (2*Fobs - Fcal)
	 *  <D>_all is the average value of density for the structure.
	 *  The summation is for all the atoms of group.
	 */
	public java.lang.Float getDensity_ratio_side_chain() 
	{
		return density_ratio_side_chain;
	}
 
	public void setDensity_ratio_side_chain(java.lang.Float density_ratio_side_chain)
	{
		this.density_ratio_side_chain = density_ratio_side_chain;
	}

 	protected java.lang.String label_alt_id;


	/**
	 *  A component of the identifier for the component.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_sites_alt in the
	 *  ATOM_SITES_ALT category.
	 */
	public java.lang.String getLabel_alt_id() 
	{
		return label_alt_id;
	}
 
	public void setLabel_alt_id(java.lang.String label_alt_id)
	{
		this.label_alt_id = label_alt_id;
	}

 	protected java.lang.String label_asym_id;


	/**
	 *  A component of the identifier for the component.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getLabel_asym_id() 
	{
		return label_asym_id;
	}
 
	public void setLabel_asym_id(java.lang.String label_asym_id)
	{
		this.label_asym_id = label_asym_id;
	}

 	protected java.lang.String label_comp_id;


	/**
	 *  A component of the identifier for the component.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getLabel_comp_id() 
	{
		return label_comp_id;
	}
 
	public void setLabel_comp_id(java.lang.String label_comp_id)
	{
		this.label_comp_id = label_comp_id;
	}

 	protected java.lang.Integer label_seq_id;


	/**
	 *  A component of the identifier for the component.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getLabel_seq_id() 
	{
		return label_seq_id;
	}
 
	public void setLabel_seq_id(java.lang.Integer label_seq_id)
	{
		this.label_seq_id = label_seq_id;
	}

 	protected java.lang.Float real_space_R;


	/**
	 *  Real space R factor of electron density for each component,
	 *  residue side chain, or main chain.
	 *  
	 *  The real space R factor is calculated by the equation
	 *  
	 *  R_real = [Sum~i (|Dobs - Dcal|)]/[Sum~i (|Dobs + Dcal|)]
	 *  
	 *  Where:
	 *  Dobs is the observed  electron density,
	 *  Dcal is the calculated  electron density,
	 *  summation is for all the grid points
	 *  
	 *  Ref: Branden, C.I. & Jones, T.A. (1990).  Nature, 343, 687-689
	 */
	public java.lang.Float getReal_space_R() 
	{
		return real_space_R;
	}
 
	public void setReal_space_R(java.lang.Float real_space_R)
	{
		this.real_space_R = real_space_R;
	}

 	protected java.lang.Float real_space_R_main_chain;


	/**
	 *  Real space R factor of electron density for each component,
	 *  residue side chain, or main chain.
	 *  
	 *  The real space R factor is calculated by the equation
	 *  
	 *  R_real = [Sum~i (|Dobs - Dcal|)]/[Sum~i (|Dobs + Dcal|)]
	 *  
	 *  Where:
	 *  Dobs is the observed  electron density,
	 *  Dcal is the calculated  electron density,
	 *  summation is for all the grid points
	 *  
	 *  Ref: Branden, C.I. & Jones, T.A. (1990).  Nature, 343, 687-689
	 */
	public java.lang.Float getReal_space_R_main_chain() 
	{
		return real_space_R_main_chain;
	}
 
	public void setReal_space_R_main_chain(java.lang.Float real_space_R_main_chain)
	{
		this.real_space_R_main_chain = real_space_R_main_chain;
	}

 	protected java.lang.Float real_space_R_side_chain;


	/**
	 *  Real space R factor of electron density for each component,
	 *  residue side chain, or main chain.
	 *  
	 *  The real space R factor is calculated by the equation
	 *  
	 *  R_real = [Sum~i (|Dobs - Dcal|)]/[Sum~i (|Dobs + Dcal|)]
	 *  
	 *  Where:
	 *  Dobs is the observed  electron density,
	 *  Dcal is the calculated  electron density,
	 *  summation is for all the grid points
	 *  
	 *  Ref: Branden, C.I. & Jones, T.A. (1990).  Nature, 343, 687-689
	 */
	public java.lang.Float getReal_space_R_side_chain() 
	{
		return real_space_R_side_chain;
	}
 
	public void setReal_space_R_side_chain(java.lang.Float real_space_R_side_chain)
	{
		this.real_space_R_side_chain = real_space_R_side_chain;
	}

 	protected java.lang.Float shift;


	/**
	 *  The tendency of the group of atoms (e.g. residue
	 *  or ligand, side chain, main chain)  to move away from its current position.
	 *  
	 *  Displacement of atoms from electron density is estimated from the
	 *  difference (Fobs - Fcal) map. The displacement vector is the ratio of
	 *  the gradient of difference density to the curvature. The amplitude of
	 *  the displacement vector is an indicator of the positional error.
	 *  
	 *  Ref: Vaguine, A.A., Richelle, J. & Wodak, S.J. (1999). Acta Cryst. D55,199-205
	 */
	public java.lang.Float getShift() 
	{
		return shift;
	}
 
	public void setShift(java.lang.Float shift)
	{
		this.shift = shift;
	}

 	protected java.lang.Float shift_main_chain;


	/**
	 *  The tendency of the group of atoms (e.g. residue
	 *  or ligand, side chain, main chain)  to move away from its current position.
	 *  
	 *  Displacement of atoms from electron density is estimated from the
	 *  difference (Fobs - Fcal) map. The displacement vector is the ratio of
	 *  the gradient of difference density to the curvature. The amplitude of
	 *  the displacement vector is an indicator of the positional error.
	 *  
	 *  Ref: Vaguine, A.A., Richelle, J. & Wodak, S.J. (1999). Acta Cryst. D55,199-205
	 */
	public java.lang.Float getShift_main_chain() 
	{
		return shift_main_chain;
	}
 
	public void setShift_main_chain(java.lang.Float shift_main_chain)
	{
		this.shift_main_chain = shift_main_chain;
	}

 	protected java.lang.Float shift_side_chain;


	/**
	 *  The tendency of the group of atoms (e.g. residue
	 *  or ligand, side chain, main chain)  to move away from its current position.
	 *  
	 *  Displacement of atoms from electron density is estimated from the
	 *  difference (Fobs - Fcal) map. The displacement vector is the ratio of
	 *  the gradient of difference density to the curvature. The amplitude of
	 *  the displacement vector is an indicator of the positional error.
	 *  
	 *  Ref: Vaguine, A.A., Richelle, J. & Wodak, S.J. (1999). Acta Cryst. D55,199-205
	 */
	public java.lang.Float getShift_side_chain() 
	{
		return shift_side_chain;
	}
 
	public void setShift_side_chain(java.lang.Float shift_side_chain)
	{
		this.shift_side_chain = shift_side_chain;
	}

 }
