package org.pdb.beans;

/**
 *  Details decribing crystallographic twinning.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_reflns_twinCategory>
 *  <PDBx:pdbx_reflns_twin diffrn_id="1" crystal_id="1">
 *  <PDBx:type>merohedral</PDBx:type>
 *  <PDBx:operator>h,-h-k,-l</PDBx:operator>
 *  <PDBx:fraction>.43</PDBx:fraction>
 *  <PDBx:mean_I2_over_mean_I_square>1.3</PDBx:mean_I2_over_mean_I_square>
 *  <PDBx:mean_F_square_over_mean_F2>.84</PDBx:mean_F_square_over_mean_F2>
 *  </PDBx:pdbx_reflns_twin>
 *  </PDBx:pdbx_reflns_twinCategory>
 * </pre>
 */
public class Pdbx_reflns_twin 
{
		protected java.lang.String crystal_id;


	/**
	 *  The crystal identifier.  A reference to
	 *  attribute id in category exptl_crystal in category EXPTL_CRYSTAL.
	 */
	public java.lang.String getCrystal_id() 
	{
		return crystal_id;
	}
 
	public void setCrystal_id(java.lang.String crystal_id)
	{
		this.crystal_id = crystal_id;
	}

 	protected java.lang.String diffrn_id;


	/**
	 *  The diffraction data set identifier.  A reference to
	 *  attribute id in category diffrn in category DIFFRN.
	 */
	public java.lang.String getDiffrn_id() 
	{
		return diffrn_id;
	}
 
	public void setDiffrn_id(java.lang.String diffrn_id)
	{
		this.diffrn_id = diffrn_id;
	}

 	protected java.lang.Float fraction;


	/**
	 *  The twin fraction or twin factor represents a quantitative parameter for the
	 *  crystal twinning.  The value 0 represents no twinning, < 0.5 partial twinning,
	 *  = 0.5 for perfect twinning.
	 */
	public java.lang.Float getFraction() 
	{
		return fraction;
	}
 
	public void setFraction(java.lang.Float fraction)
	{
		this.fraction = fraction;
	}

 	protected java.lang.Float mean_F_square_over_mean_F2;


	/**
	 *  The ideal statistics for twinned crystals. The values calculated with the
	 *  acentric data are given below.
	 *  
	 *  Statistic Untwinned data Perfect twinned data
	 *  <I^2>/<I>^2 2.0             1.5
	 *  <F>^2/<F^2> 0.785           0.865
	 *  
	 *  References:
	 *  Yeates, T.O. (1997) Methods in Enzymology 276, 344-358. Detecting and
	 *  Overcoming Crystal Twinning.
	 *  
	 *  and information from the following on-line sites:
	 *  CNS site http://cns.csb.yale.edu/v1.1/
	 *  CCP4 site http://www.ccp4.ac.uk/dist/html/detwin.html
	 *  SHELX site http://shelx.uni-ac.gwdg.de/~rherbst/twin.html
	 */
	public java.lang.Float getMean_F_square_over_mean_F2() 
	{
		return mean_F_square_over_mean_F2;
	}
 
	public void setMean_F_square_over_mean_F2(java.lang.Float mean_F_square_over_mean_F2)
	{
		this.mean_F_square_over_mean_F2 = mean_F_square_over_mean_F2;
	}

 	protected java.lang.Float mean_I2_over_mean_I_square;


	/**
	 *  The ideal statistics for twinned crystals. The values calculated with the
	 *  acentric data are given below.
	 *  
	 *  Statistic Untwinned data Perfect twinned data
	 *  <I^2>/<I>^2 2.0             1.5
	 *  <F>^2/<F^2> 0.785           0.865
	 *  
	 *  References:
	 *  Yeates, T.O. (1997) Methods in Enzymology 276, 344-358. Detecting and
	 *  Overcoming Crystal Twinning.
	 *  
	 *  and information from the following on-line sites:
	 *  CNS site http://cns.csb.yale.edu/v1.1/
	 *  CCP4 site http://www.ccp4.ac.uk/dist/html/detwin.html
	 *  SHELX site http://shelx.uni-ac.gwdg.de/~rherbst/twin.html
	 */
	public java.lang.Float getMean_I2_over_mean_I_square() 
	{
		return mean_I2_over_mean_I_square;
	}
 
	public void setMean_I2_over_mean_I_square(java.lang.Float mean_I2_over_mean_I_square)
	{
		this.mean_I2_over_mean_I_square = mean_I2_over_mean_I_square;
	}

 	protected java.lang.String operator;


	/**
	 *  The possible merohedral or hemihedral twinning operators for different
	 *  point groups are:
	 *  
	 *  True point group   Twin operation   hkl related to
	 *  3                       2 along a,b             h,-h-k,-l
	 *  2 along a*,b*           h+k,-k ,-l
	 *  2 along c               -h,-k , l
	 *  4                       2 along a,b,a*,b*       h,-k ,-l
	 *  6                       2 along a,b,a*,b*       h,-h-k,-l
	 *  321                     2 along a*,b*,c         -h,-k , l
	 *  312                     2 along a,b,c           -h,-k , l
	 *  23                      4 along a,b,c            k,-h , l
	 *  
	 *  References:
	 *  Yeates, T.O. (1997) Methods in Enzymology 276, 344-358. Detecting and
	 *  Overcoming Crystal Twinning.
	 *  
	 *  and information from the following on-line sites:
	 *  CNS site http://cns.csb.yale.edu/v1.1/
	 *  CCP4 site http://www.ccp4.ac.uk/dist/html/detwin.html
	 *  SHELX site http://shelx.uni-ac.gwdg.de/~rherbst/twin.html
	 */
	public java.lang.String getOperator() 
	{
		return operator;
	}
 
	public void setOperator(java.lang.String operator)
	{
		this.operator = operator;
	}

 	protected java.lang.String type;


	/**
	 *  There are two types of twinning: merohedral or hemihedral
	 *  non-merohedral or epitaxial
	 *  
	 *  For merohedral twinning the diffraction patterns from the different domains are
	 *  completely superimposable.   Hemihedral twinning is a special case of merohedral
	 *  twinning. It only involves two distinct domains.
	 *  
	 *  In the case of non-merohedral or epitaxial twinning  the reciprocal
	 *  lattices do not superimpose exactly. In this case the  diffraction pattern
	 *  consists of two (or more) interpenetrating lattices, which can in principle
	 *  be separated.
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 }
