package org.pdb.beans;

/**
 *  Data items in the PDBX_SOLN_SCATTER category record details about a
 *  solution scattering experiment
 * <pre>
 *  Example 1 - based on PDB entry 1HAQ
 *  <PDBx:pdbx_soln_scatterCategory>
 *  <PDBx:pdbx_soln_scatter entry_id="1HAQ" id="1">
 *  <PDBx:type>x-ray</PDBx:type>
 *  <PDBx:source_type>SRS BEAMLINE 2.1</PDBx:source_type>
 *  <PDBx:source_class>synchrotron</PDBx:source_class>
 *  <PDBx:source_beamline>2.1</PDBx:source_beamline>
 *  <PDBx:detector_type>500-channel quadrant</PDBx:detector_type>
 *  <PDBx:temperature>288.</PDBx:temperature>
 *  <PDBx:num_time_frames>10</PDBx:num_time_frames>
 *  <PDBx:concentration_range>0.7 - 14</PDBx:concentration_range>
 *  <PDBx:buffer_name>tris</PDBx:buffer_name>
 *  <PDBx:mean_guiner_radius>11.1</PDBx:mean_guiner_radius>
 *  <PDBx:mean_guiner_radius_esd>0.4</PDBx:mean_guiner_radius_esd>
 *  <PDBx:min_mean_cross_sectional_radii_gyration>4.4</PDBx:min_mean_cross_sectional_radii_gyration>
 *  <PDBx:min_mean_cross_sectional_radii_gyration_esd>0.2</PDBx:min_mean_cross_sectional_radii_gyration_esd>
 *  <PDBx:max_mean_cross_sectional_radii_gyration>1.7</PDBx:max_mean_cross_sectional_radii_gyration>
 *  <PDBx:protein_length>40</PDBx:protein_length>
 *  </PDBx:pdbx_soln_scatter>
 *  <PDBx:pdbx_soln_scatter entry_id="1HAQ" id="2">
 *  <PDBx:type>neutron</PDBx:type>
 *  <PDBx:source_type>ILL</PDBx:source_type>
 *  <PDBx:source_class>neutron source</PDBx:source_class>
 *  <PDBx:source_beamline_instrument>D11, D22</PDBx:source_beamline_instrument>
 *  <PDBx:detector_type>area</PDBx:detector_type>
 *  <PDBx:concentration_range>0.4 - 9.6</PDBx:concentration_range>
 *  <PDBx:buffer_name>PBS in 99.9&#37; D2O</PDBx:buffer_name>
 *  <PDBx:mean_guiner_radius>11.3</PDBx:mean_guiner_radius>
 *  <PDBx:mean_guiner_radius_esd>0.4</PDBx:mean_guiner_radius_esd>
 *  <PDBx:min_mean_cross_sectional_radii_gyration>3.9</PDBx:min_mean_cross_sectional_radii_gyration>
 *  <PDBx:min_mean_cross_sectional_radii_gyration_esd>0.2</PDBx:min_mean_cross_sectional_radii_gyration_esd>
 *  <PDBx:max_mean_cross_sectional_radii_gyration>1.51</PDBx:max_mean_cross_sectional_radii_gyration>
 *  <PDBx:protein_length>37.0 - 39.0</PDBx:protein_length>
 *  </PDBx:pdbx_soln_scatter>
 *  <PDBx:pdbx_soln_scatter entry_id="1HAQ" id="3">
 *  <PDBx:type>neutron</PDBx:type>
 *  <PDBx:source_type>ISIS</PDBx:source_type>
 *  <PDBx:source_class>neutron source</PDBx:source_class>
 *  <PDBx:source_beamline>Pulsed Neutron</PDBx:source_beamline>
 *  <PDBx:source_beamline_instrument>LOQ</PDBx:source_beamline_instrument>
 *  <PDBx:detector_type>AREA (TIME-OF-FLIGHT)</PDBx:detector_type>
 *  <PDBx:concentration_range>3.7, 6.1</PDBx:concentration_range>
 *  <PDBx:buffer_name>PBS in 99.9&#37; D2O</PDBx:buffer_name>
 *  <PDBx:mean_guiner_radius>11.7</PDBx:mean_guiner_radius>
 *  <PDBx:mean_guiner_radius_esd>0.5</PDBx:mean_guiner_radius_esd>
 *  <PDBx:protein_length>40.0</PDBx:protein_length>
 *  </PDBx:pdbx_soln_scatter>
 *  </PDBx:pdbx_soln_scatterCategory>
 * </pre>
 */
public class Pdbx_soln_scatter 
{
		protected java.lang.String buffer_name;


	/**
	 *  The name of the buffer used for the sample in the solution scattering
	 *  experiment.
	 *  acetic acid
	 */
	public java.lang.String getBuffer_name() 
	{
		return buffer_name;
	}
 
	public void setBuffer_name(java.lang.String buffer_name)
	{
		this.buffer_name = buffer_name;
	}

 	protected java.lang.Float concentration_range;


	/**
	 *  The concentration range (mg/mL) of the complex in the
	 *  sample used in the solution scattering experiment to
	 *  determine the mean radius of structural elongation.
	 *  0.7 - 14
	 */
	public java.lang.Float getConcentration_range() 
	{
		return concentration_range;
	}
 
	public void setConcentration_range(java.lang.Float concentration_range)
	{
		this.concentration_range = concentration_range;
	}

 	protected java.lang.String data_analysis_software_list;


	/**
	 *  A list of the software used in the data analysis
	 *  SCTPL5 GNOM
	 */
	public java.lang.String getData_analysis_software_list() 
	{
		return data_analysis_software_list;
	}
 
	public void setData_analysis_software_list(java.lang.String data_analysis_software_list)
	{
		this.data_analysis_software_list = data_analysis_software_list;
	}

 	protected java.lang.String data_reduction_software_list;


	/**
	 *  A list of the software used in the data reduction
	 *  OTOKO
	 */
	public java.lang.String getData_reduction_software_list() 
	{
		return data_reduction_software_list;
	}
 
	public void setData_reduction_software_list(java.lang.String data_reduction_software_list)
	{
		this.data_reduction_software_list = data_reduction_software_list;
	}

 	protected java.lang.String detector_specific;


	/**
	 *  The particular radiation detector. In general this will be a
	 *  manufacturer, description, model number or some combination of
	 *  these.
	 */
	public java.lang.String getDetector_specific() 
	{
		return detector_specific;
	}
 
	public void setDetector_specific(java.lang.String detector_specific)
	{
		this.detector_specific = detector_specific;
	}

 	protected java.lang.String detector_type;


	/**
	 *  The general class of the radiation detector.
	 */
	public java.lang.String getDetector_type() 
	{
		return detector_type;
	}
 
	public void setDetector_type(java.lang.String detector_type)
	{
		this.detector_type = detector_type;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category pdbx_soln_scatter must
	 *  uniquely identify the sample in the category PDBX_SOLN_SCATTER
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Float max_mean_cross_sectional_radii_gyration;


	/**
	 *  The maximum mean radius of structural elongation of the sample.
	 *  In a given solute-solvent contrast, the radius of gyration
	 *  R_G is a measure of structural elongation if the internal
	 *  inhomogeneity of scattering densities has no effect. Guiner
	 *  analysis at low Q give the R_G and the forward scattering at
	 *  zero angle I(0).
	 *  
	 *  lnl(Q) = lnl(0) - R_G^2Q^2/3
	 *  
	 *  where
	 *  Q = 4(pi)sin(theta/lamda)
	 *  2theta = scattering angle
	 *  lamda = wavelength
	 *  
	 *  The above expression is valid in a QR_G range for extended
	 *  rod-like particles. The relative I(0)/c values ( where
	 *  c = sample concentration) for sample measurements in a
	 *  constant buffer for a single sample data session, gives the
	 *  relative masses of the protein(s) studied when referenced
	 *  against a standard.
	 *  
	 *  see:
	 *  O.Glatter & O.Kratky, (1982). Editors of "Small angle
	 *  X-ray Scattering, Academic Press, New York.
	 *  O.Kratky. (1963). X-ray small angle scattering with
	 *  substances of biological interest in diluted solutions.
	 *  Prog. Biophys. Chem., 13, 105-173.
	 *  G.D.Wignall & F.S.Bates, (1987). The small-angle approximation
	 *  of X-ray and neutron scatter from rigid rods of non-uniform
	 *  cross section and finite length. J.Appl. Crystallog., 18, 452-460.
	 *  
	 *  If the structure is elongated, the mean radius of gyration
	 *  of the cross-sectional structure R_XS  and the mean cross sectional
	 *  intensity at zero angle [I(Q).Q]_Q->0 is obtained from
	 *  ln[I(Q).Q] = ln[l(Q).(Q)]_Q->0 - ((R_XS)^2Q^2)/2
	 */
	public java.lang.Float getMax_mean_cross_sectional_radii_gyration() 
	{
		return max_mean_cross_sectional_radii_gyration;
	}
 
	public void setMax_mean_cross_sectional_radii_gyration(java.lang.Float max_mean_cross_sectional_radii_gyration)
	{
		this.max_mean_cross_sectional_radii_gyration = max_mean_cross_sectional_radii_gyration;
	}

 	protected java.lang.Float max_mean_cross_sectional_radii_gyration_esd;


	/**
	 *  The estimated standard deviation for the
	 *  minimum mean radius of structural elongation of the sample.
	 *  In a given solute-solvent contrast, the radius of gyration
	 *  R_G is a measure of structural elongation if the internal
	 *  inhomogeneity of scattering densities has no effect. Guiner
	 *  analysis at low Q give the R_G and the forward scattering at
	 *  zero angle I(0).
	 *  
	 *  lnl(Q) = lnl(0) - R_G^2Q^2/3
	 *  
	 *  where
	 *  Q = 4(pi)sin(theta/lamda)
	 *  2theta = scattering angle
	 *  lamda = wavelength
	 *  
	 *  The above expression is valid in a QR_G range for extended
	 *  rod-like particles. The relative I(0)/c values ( where
	 *  c = sample concentration) for sample measurements in a
	 *  constant buffer for a single sample data session, gives the
	 *  relative masses of the protein(s) studied when referenced
	 *  against a standard.
	 *  
	 *  see:
	 *  O.Glatter & O.Kratky, (1982). Editors of "Small angle
	 *  X-ray Scattering, Academic Press, New York.
	 *  O.Kratky. (1963). X-ray small angle scattering with
	 *  substances of biological interest in diluted solutions.
	 *  Prog. Biophys. Chem., 13, 105-173.
	 *  G.D.Wignall & F.S.Bates, (1987). The small-angle approximation
	 *  of X-ray and neutron scatter from rigid rods of non-uniform
	 *  cross section and finite length. J.Appl. Crystallog., 18, 452-460.
	 *  
	 *  If the structure is elongated, the mean radius of gyration
	 *  of the cross-sectional structure R_XS  and the mean cross sectional
	 *  intensity at zero angle [I(Q).Q]_Q->0 is obtained from
	 *  ln[I(Q).Q] = ln[l(Q).(Q)]_Q->0 - ((R_XS)^2Q^2)/2
	 */
	public java.lang.Float getMax_mean_cross_sectional_radii_gyration_esd() 
	{
		return max_mean_cross_sectional_radii_gyration_esd;
	}
 
	public void setMax_mean_cross_sectional_radii_gyration_esd(java.lang.Float max_mean_cross_sectional_radii_gyration_esd)
	{
		this.max_mean_cross_sectional_radii_gyration_esd = max_mean_cross_sectional_radii_gyration_esd;
	}

 	protected java.lang.Float mean_guiner_radius;


	/**
	 *  The mean radius of structural elongation of the sample.
	 *  In a given solute-solvent contrast, the radius of gyration
	 *  R_G is a measure of structural elongation if the internal
	 *  inhomogeneity of scattering densities has no effect. Guiner
	 *  analysis at low Q gives the R_G and the forward scattering at
	 *  zero angle I(0).
	 *  
	 *  lnl(Q) = lnl(0) - R_G^2Q^2/3
	 *  
	 *  where
	 *  Q = 4(pi)sin(theta/lamda)
	 *  2theta = scattering angle
	 *  lamda = wavelength
	 *  
	 *  The above expression is valid in a QR_G range for extended
	 *  rod-like particles. The relative I(0)/c values ( where
	 *  c = sample concentration) for sample measurements in a
	 *  constant buffer for a single sample data session, gives the
	 *  relative masses of the protein(s) studied when referenced
	 *  against a standard.
	 *  
	 *  see: O.Glatter & O.Kratky, (1982). Editors of "Small angle
	 *  X-ray Scattering, Academic Press, New York.
	 *  O.Kratky. (1963). X-ray small angle scattering with
	 *  substances of biological interest in diluted solutions.
	 *  Prog. Biophys. Chem., 13, 105-173.
	 *  
	 *  G.D.Wignall & F.S.Bates, (1987). The small-angle approximation
	 *  of X-ray and neutron scatter from rigid rods of non-uniform
	 *  cross section and finite length. J.Appl. Crystallog., 18, 452-460.
	 *  
	 *  If the structure is elongated, the mean radius of gyration
	 *  of the cross-sectional structure R_XS  and the mean cross sectional
	 *  intensity at zero angle [I(Q).Q]_Q->0 is obtained from
	 *  
	 *  ln[I(Q).Q] = ln[l(Q).(Q)]_Q->0 - ((R_XS)^2Q^2)/2
	 */
	public java.lang.Float getMean_guiner_radius() 
	{
		return mean_guiner_radius;
	}
 
	public void setMean_guiner_radius(java.lang.Float mean_guiner_radius)
	{
		this.mean_guiner_radius = mean_guiner_radius;
	}

 	protected java.lang.Float mean_guiner_radius_esd;


	/**
	 *  The estimated standard deviation for the
	 *  mean radius of structural elongation of the sample.
	 *  In a given solute-solvent contrast, the radius of gyration
	 *  R_G is a measure of structural elongation if the internal
	 *  inhomogeneity of scattering densities has no effect. Guiner
	 *  analysis at low Q give the R_G and the forward scattering at
	 *  zero angle I(0).
	 *  
	 *  lnl(Q) = lnl(0) - R_G^2Q^2/3
	 *  
	 *  where
	 *  Q = 4(pi)sin(theta/lamda)
	 *  2theta = scattering angle
	 *  lamda = wavelength
	 *  
	 *  The above expression is valid in a QR_G range for extended
	 *  rod-like particles. The relative I(0)/c values ( where
	 *  c = sample concentration) for sample measurements in a
	 *  constant buffer for a single sample data session, gives the
	 *  relative masses of the protein(s) studied when referenced
	 *  against a standard.
	 *  
	 *  see:
	 *  O.Glatter & O.Kratky, (1982). Editors of "Small angle
	 *  X-ray Scattering, Academic Press, New York.
	 *  O.Kratky. (1963). X-ray small angle scattering with
	 *  substances of biological interest in diluted solutions.
	 *  Prog. Biophys. Chem., 13, 105-173.
	 *  G.D.Wignall & F.S.Bates, (1987). The small-angle approximation
	 *  of X-ray and neutron scatter from rigid rods of non-uniform
	 *  cross section and finite length. J.Appl. Crystallog., 18, 452-460.
	 *  
	 *  If the structure is elongated, the mean radius of gyration
	 *  of the cross-sectional structure R_XS  and the mean cross sectional
	 *  intensity at zero angle [I(Q).Q]_Q->0 is obtained from
	 *  ln[I(Q).Q] = ln[l(Q).(Q)]_Q->0 - ((R_XS)^2Q^2)/2
	 */
	public java.lang.Float getMean_guiner_radius_esd() 
	{
		return mean_guiner_radius_esd;
	}
 
	public void setMean_guiner_radius_esd(java.lang.Float mean_guiner_radius_esd)
	{
		this.mean_guiner_radius_esd = mean_guiner_radius_esd;
	}

 	protected java.lang.Float min_mean_cross_sectional_radii_gyration;


	/**
	 *  The minimum mean radius of structural elongation of the sample.
	 *  In a given solute-solvent contrast, the radius of gyration
	 *  R_G is a measure of structural elongation if the internal
	 *  inhomogeneity of scattering densities has no effect. Guiner
	 *  analysis at low Q give the R_G and the forward scattering at
	 *  zero angle I(0).
	 *  
	 *  lnl(Q) = lnl(0) - R_G^2Q^2/3
	 *  
	 *  where
	 *  Q = 4(pi)sin(theta/lamda)
	 *  2theta = scattering angle
	 *  lamda = wavelength
	 *  
	 *  The above expression is valid in a QR_G range for extended
	 *  rod-like particles. The relative I(0)/c values ( where
	 *  c = sample concentration) for sample measurements in a
	 *  constant buffer for a single sample data session, gives the
	 *  relative masses of the protein(s) studied when referenced
	 *  against a standard.
	 *  
	 *  see:
	 *  O.Glatter & O.Kratky, (1982). Editors of "Small angle
	 *  X-ray Scattering, Academic Press, New York.
	 *  O.Kratky. (1963). X-ray small angle scattering with
	 *  substances of biological interest in diluted solutions.
	 *  Prog. Biophys. Chem., 13, 105-173.
	 *  G.D.Wignall & F.S.Bates, (1987). The small-angle approximation
	 *  of X-ray and neutron scatter from rigid rods of non-uniform
	 *  cross section and finite length. J.Appl. Crystallog., 18, 452-460.
	 *  
	 *  If the structure is elongated, the mean radius of gyration
	 *  of the cross-sectional structure R_XS  and the mean cross sectional
	 *  intensity at zero angle [I(Q).Q]_Q->0 is obtained from
	 *  ln[I(Q).Q] = ln[l(Q).(Q)]_Q->0 - ((R_XS)^2Q^2)/2
	 */
	public java.lang.Float getMin_mean_cross_sectional_radii_gyration() 
	{
		return min_mean_cross_sectional_radii_gyration;
	}
 
	public void setMin_mean_cross_sectional_radii_gyration(java.lang.Float min_mean_cross_sectional_radii_gyration)
	{
		this.min_mean_cross_sectional_radii_gyration = min_mean_cross_sectional_radii_gyration;
	}

 	protected java.lang.Float min_mean_cross_sectional_radii_gyration_esd;


	/**
	 *  The estimated standard deviation for the
	 *  minimum mean radius of structural elongation of the sample.
	 *  In a given solute-solvent contrast, the radius of gyration
	 *  R_G is a measure of structural elongation if the internal
	 *  inhomogeneity of scattering densities has no effect. Guiner
	 *  analysis at low Q give the R_G and the forward scattering at
	 *  zero angle I(0).
	 *  
	 *  lnl(Q) = lnl(0) - R_G^2Q^2/3
	 *  
	 *  where
	 *  Q = 4(pi)sin(theta/lamda)
	 *  2theta = scattering angle
	 *  lamda = wavelength
	 *  
	 *  The above expression is valid in a QR_G range for extended
	 *  rod-like particles. The relative I(0)/c values ( where
	 *  c = sample concentration) for sample measurements in a
	 *  constant buffer for a single sample data session, gives the
	 *  relative masses of the protein(s) studied when referenced
	 *  against a standard.
	 *  
	 *  see:
	 *  O.Glatter & O.Kratky, (1982). Editors of "Small angle
	 *  X-ray Scattering, Academic Press, New York.
	 *  O.Kratky. (1963). X-ray small angle scattering with
	 *  substances of biological interest in diluted solutions.
	 *  Prog. Biophys. Chem., 13, 105-173.
	 *  G.D.Wignall & F.S.Bates, (1987). The small-angle approximation
	 *  of X-ray and neutron scatter from rigid rods of non-uniform
	 *  cross section and finite length. J.Appl. Crystallog., 18, 452-460.
	 *  
	 *  If the structure is elongated, the mean radius of gyration
	 *  of the cross-sectional structure R_XS  and the mean cross sectional
	 *  intensity at zero angle [I(Q).Q]_Q->0 is obtained from
	 *  
	 *  ln[I(Q).Q] = ln[l(Q).(Q)]_Q->0 - ((R_XS)^2Q^2)/2
	 */
	public java.lang.Float getMin_mean_cross_sectional_radii_gyration_esd() 
	{
		return min_mean_cross_sectional_radii_gyration_esd;
	}
 
	public void setMin_mean_cross_sectional_radii_gyration_esd(java.lang.Float min_mean_cross_sectional_radii_gyration_esd)
	{
		this.min_mean_cross_sectional_radii_gyration_esd = min_mean_cross_sectional_radii_gyration_esd;
	}

 	protected java.lang.Integer num_time_frames;


	/**
	 *  The number of time frame solution scattering images used.
	 */
	public java.lang.Integer getNum_time_frames() 
	{
		return num_time_frames;
	}
 
	public void setNum_time_frames(java.lang.Integer num_time_frames)
	{
		this.num_time_frames = num_time_frames;
	}

 	protected java.lang.String protein_length;


	/**
	 *  The length (or range) of the protein sample under study.
	 *  If the solution structure is approximated as an elongated elliptical
	 *  cyclinder the the length L is determined from,
	 *  
	 *  L = sqrt [12( (R_G)^2  -  (R_XS)^2 ) ]
	 *  
	 *  The length should also be given by
	 *  
	 *  L = pi I(0) / [ I(Q).Q]_Q->0
	 */
	public java.lang.String getProtein_length() 
	{
		return protein_length;
	}
 
	public void setProtein_length(java.lang.String protein_length)
	{
		this.protein_length = protein_length;
	}

 	protected java.lang.Float sample_pH;


	/**
	 *  The pH value of the buffered sample.
	 */
	public java.lang.Float getSample_pH() 
	{
		return sample_pH;
	}
 
	public void setSample_pH(java.lang.Float sample_pH)
	{
		this.sample_pH = sample_pH;
	}

 	protected java.lang.String source_beamline;


	/**
	 *  The beamline name used for the experiment
	 */
	public java.lang.String getSource_beamline() 
	{
		return source_beamline;
	}
 
	public void setSource_beamline(java.lang.String source_beamline)
	{
		this.source_beamline = source_beamline;
	}

 	protected java.lang.String source_beamline_instrument;


	/**
	 *  The instrumentation used on the beamline
	 */
	public java.lang.String getSource_beamline_instrument() 
	{
		return source_beamline_instrument;
	}
 
	public void setSource_beamline_instrument(java.lang.String source_beamline_instrument)
	{
		this.source_beamline_instrument = source_beamline_instrument;
	}

 	protected java.lang.String source_class;


	/**
	 *  The general class of the radiation source.
	 *  neutron source
	 *  synchrotron
	 */
	public java.lang.String getSource_class() 
	{
		return source_class;
	}
 
	public void setSource_class(java.lang.String source_class)
	{
		this.source_class = source_class;
	}

 	protected java.lang.String source_type;


	/**
	 *  The make, model, name or beamline of the source of radiation.
	 */
	public java.lang.String getSource_type() 
	{
		return source_type;
	}
 
	public void setSource_type(java.lang.String source_type)
	{
		this.source_type = source_type;
	}

 	protected java.lang.Float temperature;


	/**
	 *  The temperature in kelvins at which the experiment
	 *  was conducted
	 */
	public java.lang.Float getTemperature() 
	{
		return temperature;
	}
 
	public void setTemperature(java.lang.Float temperature)
	{
		this.temperature = temperature;
	}

 	protected java.lang.String type;


	/**
	 *  The type of solution scattering experiment carried out
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 }
