package org.pdb.beans;

/**
 *  Data items in the PDBX_STRUCT_ASSEMBLY_GEN category record details about
 *  the generation of each macromolecular assemblies. The PDBX_STRUCT_ASSEMBLY_GEN
 *  data items provide the specifications of the components that
 *  constitute that assembly in terms of cartesian transformations.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_struct_assembly_genCategory>
 *  <PDBx:pdbx_struct_assembly_gen assembly_id="1" asym_id_list="A" oper_expression="1"></PDBx:pdbx_struct_assembly_gen>
 *  <PDBx:pdbx_struct_assembly_gen assembly_id="1" asym_id_list="B" oper_expression="1"></PDBx:pdbx_struct_assembly_gen>
 *  <PDBx:pdbx_struct_assembly_gen assembly_id="2" asym_id_list="A" oper_expression="2"></PDBx:pdbx_struct_assembly_gen>
 *  <PDBx:pdbx_struct_assembly_gen assembly_id="2" asym_id_list="B" oper_expression="2"></PDBx:pdbx_struct_assembly_gen>
 *  <PDBx:pdbx_struct_assembly_gen assembly_id="2" asym_id_list="C" oper_expression="2"></PDBx:pdbx_struct_assembly_gen>
 *  <PDBx:pdbx_struct_assembly_gen assembly_id="3" asym_id_list="A" oper_expression="3"></PDBx:pdbx_struct_assembly_gen>
 *  <PDBx:pdbx_struct_assembly_gen assembly_id="3" asym_id_list="B" oper_expression="3"></PDBx:pdbx_struct_assembly_gen>
 *  <PDBx:pdbx_struct_assembly_gen assembly_id="3" asym_id_list="D" oper_expression="3"></PDBx:pdbx_struct_assembly_gen>
 *  </PDBx:pdbx_struct_assembly_genCategory>
 *  
 *  
 *  Example 2 -
 *  <PDBx:pdbx_struct_assembly_genCategory>
 *  <PDBx:pdbx_struct_assembly_gen assembly_id="1" asym_id_list="A,B" oper_expression="1"></PDBx:pdbx_struct_assembly_gen>
 *  <PDBx:pdbx_struct_assembly_gen assembly_id="2" asym_id_list="A,B,C" oper_expression="2"></PDBx:pdbx_struct_assembly_gen>
 *  <PDBx:pdbx_struct_assembly_gen assembly_id="3" asym_id_list="A,B,D" oper_expression="3"></PDBx:pdbx_struct_assembly_gen>
 *  </PDBx:pdbx_struct_assembly_genCategory>
 * </pre>
 */
public class Pdbx_struct_assembly_gen 
{
		protected java.lang.String assembly_id;


	/**
	 *  This data item is a pointer to  attribute id in category pdbx_struct_assembly in the
	 *  PDBX_STRUCT_ASSEMBLY category.
	 */
	public java.lang.String getAssembly_id() 
	{
		return assembly_id;
	}
 
	public void setAssembly_id(java.lang.String assembly_id)
	{
		this.assembly_id = assembly_id;
	}

 	protected java.lang.String asym_id_list;


	/**
	 *  This data item is a pointer to  attribute id in category struct_asym in
	 *  the STRUCT_ASYM category.
	 *  
	 *  This item may be expressed as a comma separated list of identifiers.
	 */
	public java.lang.String getAsym_id_list() 
	{
		return asym_id_list;
	}
 
	public void setAsym_id_list(java.lang.String asym_id_list)
	{
		this.asym_id_list = asym_id_list;
	}

 	protected java.lang.String entity_inst_id;


	/**
	 *  This data item is a pointer to  attribute id in category pdbx_struct_entity_inst in
	 *  the PDBX_STRUCT_ENTITY_INST category.
	 *  
	 *  This item may be expressed as a comma separated list of instance identifiers.
	 */
	public java.lang.String getEntity_inst_id() 
	{
		return entity_inst_id;
	}
 
	public void setEntity_inst_id(java.lang.String entity_inst_id)
	{
		this.entity_inst_id = entity_inst_id;
	}

 	protected java.lang.String oper_expression;


	/**
	 *  Identifies the operation of collection of operations
	 *  from category PDBX_STRUCT_OPER_LIST.
	 *  
	 *  Operation expressions may have the forms:
	 *  
	 *  (1)        the single operation 1
	 *  (1,2,5)    the operations 1, 2, 5
	 *  (1-4)      the operations 1,2,3 and 4
	 *  (1,2)(3,4) the combinations of operations
	 *  3 and 4 followed by 1 and 2 (i.e.
	 *  the cartesian product of parenthetical
	 *  groups applied from right to left)
	 *  
	 *  
	 *  (1)
	 *  (1,2,5)
	 *  (1-60)
	 *  (1-60)(61)
	 */
	public java.lang.String getOper_expression() 
	{
		return oper_expression;
	}
 
	public void setOper_expression(java.lang.String oper_expression)
	{
		this.oper_expression = oper_expression;
	}

 }
