package org.pdb.beans;

/**
 *  Data items in the PDBX_STRUCT_MSYM_GEN category record details about
 *  the generation of the minimal asymmetric unit. For instance, this
 *  category can be used to provide this information for helical and point
 *  symmetry systems.   The PDBX_STRUCT_MSYM_GEN data items provide the
 *  specifications of the components that constitute the asymmetric unit
 *  in terms of cartesian transformations of deposited coordinates.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_struct_msym_genCategory>
 *  <PDBx:pdbx_struct_msym_gen msym_id="A" entity_inst_id="A" oper_expression="3"></PDBx:pdbx_struct_msym_gen>
 *  <PDBx:pdbx_struct_msym_gen msym_id="B" entity_inst_id="B" oper_expression="4"></PDBx:pdbx_struct_msym_gen>
 *  <PDBx:pdbx_struct_msym_gen msym_id="C" entity_inst_id="B" oper_expression="5"></PDBx:pdbx_struct_msym_gen>
 *  </PDBx:pdbx_struct_msym_genCategory>
 * </pre>
 */
public class Pdbx_struct_msym_gen 
{
		protected java.lang.String entity_inst_id;


	/**
	 *  This data item is a pointer to  attribute id in category pdbx_struct_entity_inst in
	 *  the PDBX_STRUCT_ENTITY_INST category.
	 */
	public java.lang.String getEntity_inst_id() 
	{
		return entity_inst_id;
	}
 
	public void setEntity_inst_id(java.lang.String entity_inst_id)
	{
		this.entity_inst_id = entity_inst_id;
	}

 	protected java.lang.String msym_id;


	/**
	 *  Uniquely identifies the this structure instance in
	 *  point symmetry unit.
	 */
	public java.lang.String getMsym_id() 
	{
		return msym_id;
	}
 
	public void setMsym_id(java.lang.String msym_id)
	{
		this.msym_id = msym_id;
	}

 	protected java.lang.String oper_expression;


	/**
	 *  Identifies the operation from category PDBX_STRUCT_OPER_LIST.
	 *  
	 *  (1)
	 *  (1-3)
	 */
	public java.lang.String getOper_expression() 
	{
		return oper_expression;
	}
 
	public void setOper_expression(java.lang.String oper_expression)
	{
		this.oper_expression = oper_expression;
	}

 }
