package org.pdb.beans;

/**
 *  Data items in the PDBX_STRUCT_REF_SEQ_FEATURE category provide a
 *  mechanism for identifying and annotating sequence features.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_struct_ref_seq_featureCategory>
 *  <PDBx:pdbx_struct_ref_seq_feature feature_id="1">
 *  <PDBx:align_id>algn2</PDBx:align_id>
 *  <PDBx:beg_auth_mon_id>GLU</PDBx:beg_auth_mon_id>
 *  <PDBx:end_auth_mon_id>PHE</PDBx:end_auth_mon_id>
 *  <PDBx:beg_auth_seq_id>10</PDBx:beg_auth_seq_id>
 *  <PDBx:end_auth_seq_id>14</PDBx:end_auth_seq_id>
 *  <PDBx:type>variant</PDBx:type>
 *  <PDBx:details>  Special </PDBx:details>
 *  </PDBx:pdbx_struct_ref_seq_feature>
 *  </PDBx:pdbx_struct_ref_seq_featureCategory>
 * </pre>
 */
public class Pdbx_struct_ref_seq_feature 
{
		protected java.lang.String align_id;


	/**
	 *  This data item is a pointer to  attribute align_id in category struct_ref_seq in
	 *  the STRUCT_REF_SEQ  category.
	 */
	public java.lang.String getAlign_id() 
	{
		return align_id;
	}
 
	public void setAlign_id(java.lang.String align_id)
	{
		this.align_id = align_id;
	}

 	protected java.lang.String asym_id;


	/**
	 *  Instance identifier for the polymer molecule.
	 *  A
	 *  B
	 */
	public java.lang.String getAsym_id() 
	{
		return asym_id;
	}
 
	public void setAsym_id(java.lang.String asym_id)
	{
		this.asym_id = asym_id;
	}

 	protected java.lang.String beg_auth_mon_id;


	/**
	 *  Monomer ID at the initial position in the PDB sequence segment.
	 *  1
	 *  2
	 */
	public java.lang.String getBeg_auth_mon_id() 
	{
		return beg_auth_mon_id;
	}
 
	public void setBeg_auth_mon_id(java.lang.String beg_auth_mon_id)
	{
		this.beg_auth_mon_id = beg_auth_mon_id;
	}

 	protected java.lang.String beg_auth_seq_id;


	/**
	 *  Initial position in the PDB sequence segment.
	 *  1
	 *  2
	 */
	public java.lang.String getBeg_auth_seq_id() 
	{
		return beg_auth_seq_id;
	}
 
	public void setBeg_auth_seq_id(java.lang.String beg_auth_seq_id)
	{
		this.beg_auth_seq_id = beg_auth_seq_id;
	}

 	protected java.lang.String beg_pdb_ins_code;


	/**
	 *  Initial insertion code of the PDB sequence segment.
	 *  A
	 *  B
	 */
	public java.lang.String getBeg_pdb_ins_code() 
	{
		return beg_pdb_ins_code;
	}
 
	public void setBeg_pdb_ins_code(java.lang.String beg_pdb_ins_code)
	{
		this.beg_pdb_ins_code = beg_pdb_ins_code;
	}

 	protected java.lang.String beg_seq_num;


	/**
	 *  Initial position in the sequence segment.
	 *  1
	 *  2
	 */
	public java.lang.String getBeg_seq_num() 
	{
		return beg_seq_num;
	}
 
	public void setBeg_seq_num(java.lang.String beg_seq_num)
	{
		this.beg_seq_num = beg_seq_num;
	}

 	protected java.lang.String details;


	/**
	 *  A description of special aspects of the feature
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String end_auth_mon_id;


	/**
	 *  Monomer ID at the terminal position in the PDB sequence segment
	 *  1
	 *  2
	 */
	public java.lang.String getEnd_auth_mon_id() 
	{
		return end_auth_mon_id;
	}
 
	public void setEnd_auth_mon_id(java.lang.String end_auth_mon_id)
	{
		this.end_auth_mon_id = end_auth_mon_id;
	}

 	protected java.lang.String end_auth_seq_id;


	/**
	 *  Ending position in the PDB sequence segment
	 *  1
	 *  2
	 */
	public java.lang.String getEnd_auth_seq_id() 
	{
		return end_auth_seq_id;
	}
 
	public void setEnd_auth_seq_id(java.lang.String end_auth_seq_id)
	{
		this.end_auth_seq_id = end_auth_seq_id;
	}

 	protected java.lang.String end_pdb_ins_code;


	/**
	 *  Terminal insertion code of the PDB sequence segment.
	 *  A
	 *  B
	 */
	public java.lang.String getEnd_pdb_ins_code() 
	{
		return end_pdb_ins_code;
	}
 
	public void setEnd_pdb_ins_code(java.lang.String end_pdb_ins_code)
	{
		this.end_pdb_ins_code = end_pdb_ins_code;
	}

 	protected java.lang.String end_seq_num;


	/**
	 *  Ending position in the sequence segment
	 *  1
	 *  2
	 */
	public java.lang.String getEnd_seq_num() 
	{
		return end_seq_num;
	}
 
	public void setEnd_seq_num(java.lang.String end_seq_num)
	{
		this.end_seq_num = end_seq_num;
	}

 	protected java.lang.Integer feature_id;


	/**
	 *  Uniquely identfies a sequence feature in
	 *  the STRUCT_REF_SEQ_FEATURE  category.
	 */
	public java.lang.Integer getFeature_id() 
	{
		return feature_id;
	}
 
	public void setFeature_id(java.lang.Integer feature_id)
	{
		this.feature_id = feature_id;
	}

 	protected java.lang.String pdb_strand_id;


	/**
	 *  PDB strand/chain id.
	 *  A
	 *  B
	 */
	public java.lang.String getPdb_strand_id() 
	{
		return pdb_strand_id;
	}
 
	public void setPdb_strand_id(java.lang.String pdb_strand_id)
	{
		this.pdb_strand_id = pdb_strand_id;
	}

 	protected java.lang.String type;


	/**
	 *  A classification of the feature
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 }
