package org.pdb.beans;

/**
 *  Data items in the PHASING category record details about the
 *  phasing of the structure, listing the various methods used in
 *  the phasing process. Details about the application of each
 *  method are listed in the appropriate subcategories.
 *  
 * <pre>
 *  Example 1 - hypothetical example.
 *  <PDBx:phasingCategory>
 *  <PDBx:phasing method="mir"></PDBx:phasing>
 *  <PDBx:phasing method="averaging"></PDBx:phasing>
 *  </PDBx:phasingCategory>
 * </pre>
 */
public class Phasing 
{
		protected java.lang.String method;


	/**
	 *  A listing of the method or methods used to phase this
	 *  structure.
	 *  phasing by ab initio methods
	 *  abinitio
	 *  phase improvement by averaging over multiple
	 *  images of the structure
	 *  averaging
	 *  phasing by direct methods
	 *  dm
	 *  phasing by iterative single-wavelength
	 *  anomalous scattering
	 *  isas
	 *  phasing by iterative single-wavelength
	 *  isomorphous replacement
	 *  isir
	 *  phasing beginning with phases calculated from
	 *  an isomorphous structure
	 *  isomorphous
	 *  phasing by multiple-wavelength anomalous
	 *  dispersion
	 *  mad
	 *  phasing by multiple isomorphous replacement
	 *  mir
	 *  phasing by multiple isomorphous replacement
	 *  with anomalous scattering
	 *  miras
	 *  phasing by molecular replacement
	 *  mr
	 *  phasing by single isomorphous replacement
	 *  sir
	 *  phasing by single isomorphous replacement
	 *  with anomalous scattering
	 *  siras
	 */
	public java.lang.String getMethod() 
	{
		return method;
	}
 
	public void setMethod(java.lang.String method)
	{
		this.method = method;
	}

 }
