package org.pdb.beans;

/**
 *  Data items in the PHASING_MAD category record details about
 *  the phasing of the structure where methods involving
 *  multiple-wavelength anomalous-dispersion techniques are involved.
 *  
 * <pre>
 *  Example 1 - based on a paper by Shapiro et al. [Nature (London)
 *  (1995), 374, 327-337].
 *  <PDBx:phasing_MADCategory>
 *  <PDBx:phasing_MAD entry_id="NCAD"></PDBx:phasing_MAD>
 *  </PDBx:phasing_MADCategory>
 * </pre>
 */
public class Phasing_MAD 
{
		protected java.lang.String details;


	/**
	 *  A description of special aspects of the MAD phasing.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String method;


	/**
	 *  A description of the MAD phasing method used to phase
	 *  this structure.
	 *  
	 *  Note that this is not the computer program used, which is
	 *  described in the SOFTWARE category, but rather the method
	 *  itself.
	 *  
	 *  This data item should be used to describe significant
	 *  methodological options used within the MAD phasing program.
	 */
	public java.lang.String getMethod() 
	{
		return method;
	}
 
	public void setMethod(java.lang.String method)
	{
		this.method = method;
	}

 	protected java.lang.Float pdbx_R_cullis;


	/**
	 *  attribute pdbx_R_cullis in category phasing_MAD records R_cullis
	 *  for MAD phasing.
	 */
	public java.lang.Float getPdbx_R_cullis() 
	{
		return pdbx_R_cullis;
	}
 
	public void setPdbx_R_cullis(java.lang.Float pdbx_R_cullis)
	{
		this.pdbx_R_cullis = pdbx_R_cullis;
	}

 	protected java.lang.Float pdbx_R_cullis_acentric;


	/**
	 *  attribute pdbx_R_cullis_acentric in category phasing_MAD records R_cullis
	 *  using acentric data for MAD phasing.
	 */
	public java.lang.Float getPdbx_R_cullis_acentric() 
	{
		return pdbx_R_cullis_acentric;
	}
 
	public void setPdbx_R_cullis_acentric(java.lang.Float pdbx_R_cullis_acentric)
	{
		this.pdbx_R_cullis_acentric = pdbx_R_cullis_acentric;
	}

 	protected java.lang.Float pdbx_R_cullis_centric;


	/**
	 *  attribute pdbx_R_cullis_centric in category phasing_MAD records R_cullis
	 *  using centric data for MAD phasing.
	 */
	public java.lang.Float getPdbx_R_cullis_centric() 
	{
		return pdbx_R_cullis_centric;
	}
 
	public void setPdbx_R_cullis_centric(java.lang.Float pdbx_R_cullis_centric)
	{
		this.pdbx_R_cullis_centric = pdbx_R_cullis_centric;
	}

 	protected java.lang.Float pdbx_R_kraut;


	/**
	 *  attribute pdbx_R_kraut in category phasing_MAD records R_kraut
	 *  for MAD phasing.
	 */
	public java.lang.Float getPdbx_R_kraut() 
	{
		return pdbx_R_kraut;
	}
 
	public void setPdbx_R_kraut(java.lang.Float pdbx_R_kraut)
	{
		this.pdbx_R_kraut = pdbx_R_kraut;
	}

 	protected java.lang.Float pdbx_R_kraut_acentric;


	/**
	 *  attribute pdbx_R_kraut_acentric in category phasing_MAD records R_kraut
	 *  using acentric data for MAD phasing.
	 */
	public java.lang.Float getPdbx_R_kraut_acentric() 
	{
		return pdbx_R_kraut_acentric;
	}
 
	public void setPdbx_R_kraut_acentric(java.lang.Float pdbx_R_kraut_acentric)
	{
		this.pdbx_R_kraut_acentric = pdbx_R_kraut_acentric;
	}

 	protected java.lang.Float pdbx_R_kraut_centric;


	/**
	 *  attribute pdbx_R_kraut_centric in category phasing_MAD records R_kraut
	 *  using centric data for MAD phasing.
	 */
	public java.lang.Float getPdbx_R_kraut_centric() 
	{
		return pdbx_R_kraut_centric;
	}
 
	public void setPdbx_R_kraut_centric(java.lang.Float pdbx_R_kraut_centric)
	{
		this.pdbx_R_kraut_centric = pdbx_R_kraut_centric;
	}

 	protected java.lang.String pdbx_anom_scat_method;


	/**
	 *  attribute pdbx_anom_scat_method in category phasing_MAD records the method
	 *  used to locate anomalous scatterers for MAD phasing.
	 */
	public java.lang.String getPdbx_anom_scat_method() 
	{
		return pdbx_anom_scat_method;
	}
 
	public void setPdbx_anom_scat_method(java.lang.String pdbx_anom_scat_method)
	{
		this.pdbx_anom_scat_method = pdbx_anom_scat_method;
	}

 	protected java.lang.Float pdbx_d_res_high;


	/**
	 *  attribute pdbx_d_res_high in category phasing_MAD records the highest resolution
	 *  for MAD phasing.
	 */
	public java.lang.Float getPdbx_d_res_high() 
	{
		return pdbx_d_res_high;
	}
 
	public void setPdbx_d_res_high(java.lang.Float pdbx_d_res_high)
	{
		this.pdbx_d_res_high = pdbx_d_res_high;
	}

 	protected java.lang.Float pdbx_d_res_low;


	/**
	 *  attribute pdbx_d_res_low in category phasing_MAD records the lowest resolution
	 *  for MAD phasing.
	 */
	public java.lang.Float getPdbx_d_res_low() 
	{
		return pdbx_d_res_low;
	}
 
	public void setPdbx_d_res_low(java.lang.Float pdbx_d_res_low)
	{
		this.pdbx_d_res_low = pdbx_d_res_low;
	}

 	protected java.lang.Float pdbx_fom;


	/**
	 *  attribute pdbx_fom in category phasing_MAD records the figure of merit
	 *  for MAD phasing.
	 */
	public java.lang.Float getPdbx_fom() 
	{
		return pdbx_fom;
	}
 
	public void setPdbx_fom(java.lang.Float pdbx_fom)
	{
		this.pdbx_fom = pdbx_fom;
	}

 	protected java.lang.Float pdbx_fom_acentric;


	/**
	 *  attribute pdbx_fom_acentric in category phasing_MAD records the figure of merit
	 *  using acentric data for MAD phasing.
	 */
	public java.lang.Float getPdbx_fom_acentric() 
	{
		return pdbx_fom_acentric;
	}
 
	public void setPdbx_fom_acentric(java.lang.Float pdbx_fom_acentric)
	{
		this.pdbx_fom_acentric = pdbx_fom_acentric;
	}

 	protected java.lang.Float pdbx_fom_centric;


	/**
	 *  attribute pdbx_fom_centric in category phasing_MAD records the figure of merit
	 *  using centric data for MAD phasing.
	 */
	public java.lang.Float getPdbx_fom_centric() 
	{
		return pdbx_fom_centric;
	}
 
	public void setPdbx_fom_centric(java.lang.Float pdbx_fom_centric)
	{
		this.pdbx_fom_centric = pdbx_fom_centric;
	}

 	protected java.lang.Float pdbx_loc;


	/**
	 *  attribute pdbx_loc in category phasing_MAD records lack of closure
	 *  for MAD phasing.
	 */
	public java.lang.Float getPdbx_loc() 
	{
		return pdbx_loc;
	}
 
	public void setPdbx_loc(java.lang.Float pdbx_loc)
	{
		this.pdbx_loc = pdbx_loc;
	}

 	protected java.lang.Float pdbx_loc_acentric;


	/**
	 *  attribute pdbx_loc_acentric in category phasing_MAD records lack of closure
	 *  using acentric data for MAD phasing.
	 */
	public java.lang.Float getPdbx_loc_acentric() 
	{
		return pdbx_loc_acentric;
	}
 
	public void setPdbx_loc_acentric(java.lang.Float pdbx_loc_acentric)
	{
		this.pdbx_loc_acentric = pdbx_loc_acentric;
	}

 	protected java.lang.Float pdbx_loc_centric;


	/**
	 *  attribute pdbx_loc_centric in category phasing_MAD records lack of closure
	 *  using centric data for MAD phasing.
	 */
	public java.lang.Float getPdbx_loc_centric() 
	{
		return pdbx_loc_centric;
	}
 
	public void setPdbx_loc_centric(java.lang.Float pdbx_loc_centric)
	{
		this.pdbx_loc_centric = pdbx_loc_centric;
	}

 	protected java.lang.Integer pdbx_number_data_sets;


	/**
	 *  attribute pdbx_loc in category phasing_MAD records the number
	 *  of data sets used for MAD phasing.
	 */
	public java.lang.Integer getPdbx_number_data_sets() 
	{
		return pdbx_number_data_sets;
	}
 
	public void setPdbx_number_data_sets(java.lang.Integer pdbx_number_data_sets)
	{
		this.pdbx_number_data_sets = pdbx_number_data_sets;
	}

 	protected java.lang.Float pdbx_power;


	/**
	 *  attribute pdbx_power in category phasing_MAD records phasing power
	 *  for MAD phasing.
	 */
	public java.lang.Float getPdbx_power() 
	{
		return pdbx_power;
	}
 
	public void setPdbx_power(java.lang.Float pdbx_power)
	{
		this.pdbx_power = pdbx_power;
	}

 	protected java.lang.Float pdbx_power_acentric;


	/**
	 *  attribute pdbx_power_acentric in category phasing_MAD records phasing power
	 *  using acentric data for MAD phasing.
	 */
	public java.lang.Float getPdbx_power_acentric() 
	{
		return pdbx_power_acentric;
	}
 
	public void setPdbx_power_acentric(java.lang.Float pdbx_power_acentric)
	{
		this.pdbx_power_acentric = pdbx_power_acentric;
	}

 	protected java.lang.Float pdbx_power_centric;


	/**
	 *  attribute pdbx_power_centric in category phasing_MAD records phasing power
	 *  using centric data for MAD phasing.
	 */
	public java.lang.Float getPdbx_power_centric() 
	{
		return pdbx_power_centric;
	}
 
	public void setPdbx_power_centric(java.lang.Float pdbx_power_centric)
	{
		this.pdbx_power_centric = pdbx_power_centric;
	}

 	protected java.lang.Integer pdbx_reflns;


	/**
	 *  attribute pdbx_reflns in category phasing_MAD records the number of
	 *  reflections used for MAD phasing.
	 */
	public java.lang.Integer getPdbx_reflns() 
	{
		return pdbx_reflns;
	}
 
	public void setPdbx_reflns(java.lang.Integer pdbx_reflns)
	{
		this.pdbx_reflns = pdbx_reflns;
	}

 	protected java.lang.Integer pdbx_reflns_acentric;


	/**
	 *  attribute pdbx_reflns_acentric in category phasing_MAD records the number of
	 *  acentric reflections for MAD phasing.
	 */
	public java.lang.Integer getPdbx_reflns_acentric() 
	{
		return pdbx_reflns_acentric;
	}
 
	public void setPdbx_reflns_acentric(java.lang.Integer pdbx_reflns_acentric)
	{
		this.pdbx_reflns_acentric = pdbx_reflns_acentric;
	}

 	protected java.lang.Integer pdbx_reflns_centric;


	/**
	 *  attribute pdbx_reflns_centric in category phasing_MAD records the number of
	 *  centric reflections for MAD phasing.
	 */
	public java.lang.Integer getPdbx_reflns_centric() 
	{
		return pdbx_reflns_centric;
	}
 
	public void setPdbx_reflns_centric(java.lang.Integer pdbx_reflns_centric)
	{
		this.pdbx_reflns_centric = pdbx_reflns_centric;
	}

 }
