package org.pdb.beans;

/**
 *  Data items in the PHASING_MAD_RATIO category record
 *  the ratios of phasing statistics between pairs of data sets
 *  in a MAD phasing experiment, in given shells of resolution.
 *  
 * <pre>
 *  Example 1 - based on a paper by Shapiro et al. [Nature (London)
 *  (1995), 374, 327-337].
 *  <PDBx:phasing_MAD_ratioCategory>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.4013" wavelength_2="1.4013">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.084</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.076</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.4013" wavelength_2="1.3857">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.067</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.4013" wavelength_2="1.3852">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.051</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.4013" wavelength_2="1.3847">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.044</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3857" wavelength_2="1.3857">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.110</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.049</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3857" wavelength_2="1.3852">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.049</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3857" wavelength_2="1.3847">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.067</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3852" wavelength_2="1.3852">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.149</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.072</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3852" wavelength_2="1.3847">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.039</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3847" wavelength_2="1.3847">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.102</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.071</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.4013" wavelength_2="1.4013">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.114</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.111</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.4013" wavelength_2="1.3857">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.089</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.4013" wavelength_2="1.3852">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.086</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.4013" wavelength_2="1.3847">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.077</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3857" wavelength_2="1.3857">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.140</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.127</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3857" wavelength_2="1.3852">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.085</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3857" wavelength_2="1.3847">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.089</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3852" wavelength_2="1.3852">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.155</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.119</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3852" wavelength_2="1.3847">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.082</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="4 wavelength" wavelength_1="1.3847" wavelength_2="1.3847">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.124</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.120</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3857" wavelength_2="1.3857">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.075</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.027</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3857" wavelength_2="1.3852">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.041</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3857" wavelength_2="1.3847">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.060</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3857" wavelength_2="1.3784">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.057</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3857" wavelength_2="1.2862">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.072</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3852" wavelength_2="1.3852">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.105</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.032</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3852" wavelength_2="1.3847">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.036</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3852" wavelength_2="1.3784">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.044</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3852" wavelength_2="1.2862">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.065</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3847" wavelength_2="1.3847">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.072</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.031</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3847" wavelength_2="1.3784">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.040</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3847" wavelength_2="1.2862">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.059</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3784" wavelength_2="1.3784">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.059</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.032</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3784" wavelength_2="1.2862">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.059</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.2862" wavelength_2="1.3847">
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>4.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.058</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.028</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3857" wavelength_2="1.3857">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.078</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.075</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3857" wavelength_2="1.3852">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.059</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3857" wavelength_2="1.3847">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.067</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3857" wavelength_2="1.3784">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.084</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3857" wavelength_2="1.2862">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.073</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3852" wavelength_2="1.3852">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.101</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.088</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3852" wavelength_2="1.3847">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.066</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3852" wavelength_2="1.3784">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.082</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3852" wavelength_2="1.2862">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.085</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3847" wavelength_2="1.3847">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.097</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.074</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3847" wavelength_2="1.3784">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.081</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3847" wavelength_2="1.2862">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.085</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3784" wavelength_2="1.3784">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.114</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.089</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.3784" wavelength_2="1.2862">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.103</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="1" clust_id="5 wavelength" wavelength_1="1.2862" wavelength_2="1.2862">
 *  <PDBx:d_res_low>4.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.062</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.060</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7263" wavelength_2="0.7263">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.035</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.026</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7263" wavelength_2="0.7251">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.028</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7263" wavelength_2="0.7284">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.023</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7263" wavelength_2="0.7246">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.025</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7263" wavelength_2="0.7217">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.026</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7251" wavelength_2="0.7251">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.060</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.026</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7251" wavelength_2="0.7284">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.029</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7251" wavelength_2="0.7246">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.031</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7251" wavelength_2="0.7217">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.035</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7284" wavelength_2="0.7284">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.075</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.030</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7284" wavelength_2="0.7246">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.023</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7284" wavelength_2="0.7217">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.027</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7246" wavelength_2="0.7246">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.069</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.026</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7246" wavelength_2="0.7217">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.024</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7217" wavelength_2="0.7284">
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.060</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.028</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7263" wavelength_2="0.7263">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.060</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.050</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7263" wavelength_2="0.7251">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.056</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7263" wavelength_2="0.7284">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.055</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7263" wavelength_2="0.7246">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.053</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7263" wavelength_2="0.7217">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.056</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7251" wavelength_2="0.7251">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.089</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.050</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7251" wavelength_2="0.7284">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.054</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7251" wavelength_2="0.7246">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.058</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7251" wavelength_2="0.7217">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.063</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7284" wavelength_2="0.7284">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.104</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.057</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7284" wavelength_2="0.7246">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.052</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7284" wavelength_2="0.7217">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.057</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7246" wavelength_2="0.7246">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.098</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.052</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7246" wavelength_2="0.7217">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_two_wl>0.054</PDBx:ratio_two_wl>
 *  </PDBx:phasing_MAD_ratio>
 *  <PDBx:phasing_MAD_ratio expt_id="2" clust_id="5 wavelength" wavelength_1="0.7217" wavelength_2="0.7284">
 *  <PDBx:d_res_low>3.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:ratio_one_wl>0.089</PDBx:ratio_one_wl>
 *  <PDBx:ratio_one_wl_centric>0.060</PDBx:ratio_one_wl_centric>
 *  </PDBx:phasing_MAD_ratio>
 *  </PDBx:phasing_MAD_ratioCategory>
 * </pre>
 */
public class Phasing_MAD_ratio 
{
		protected java.lang.String clust_id;


	/**
	 *  This data item is a pointer to  attribute id in category phasing_MAD_clust in
	 *  the PHASING_MAD_CLUST category.
	 */
	public java.lang.String getClust_id() 
	{
		return clust_id;
	}
 
	public void setClust_id(java.lang.String clust_id)
	{
		this.clust_id = clust_id;
	}

 	protected java.lang.Float d_res_high;


	/**
	 *  The lowest value for the interplanar spacings for the
	 *  reflection data used for the comparison of Bijvoet differences.
	 *  This is called the highest resolution.
	 */
	public java.lang.Float getD_res_high() 
	{
		return d_res_high;
	}
 
	public void setD_res_high(java.lang.Float d_res_high)
	{
		this.d_res_high = d_res_high;
	}

 	protected java.lang.Float d_res_low;


	/**
	 *  The highest value for the interplanar spacings for the
	 *  reflection data used for the comparison of Bijvoet differences.
	 *  This is called the lowest resolution.
	 */
	public java.lang.Float getD_res_low() 
	{
		return d_res_low;
	}
 
	public void setD_res_low(java.lang.Float d_res_low)
	{
		this.d_res_low = d_res_low;
	}

 	protected java.lang.String expt_id;


	/**
	 *  This data item is a pointer to  attribute id in category phasing_MAD_expt in the
	 *  PHASING_MAD_EXPT category.
	 */
	public java.lang.String getExpt_id() 
	{
		return expt_id;
	}
 
	public void setExpt_id(java.lang.String expt_id)
	{
		this.expt_id = expt_id;
	}

 	protected java.lang.Float ratio_one_wl;


	/**
	 *  The root-mean-square Bijvoet difference at one wavelength for
	 *  all reflections.
	 */
	public java.lang.Float getRatio_one_wl() 
	{
		return ratio_one_wl;
	}
 
	public void setRatio_one_wl(java.lang.Float ratio_one_wl)
	{
		this.ratio_one_wl = ratio_one_wl;
	}

 	protected java.lang.Float ratio_one_wl_centric;


	/**
	 *  The root-mean-square Bijvoet difference at one wavelength for
	 *  centric reflections. This would be equal to zero for perfect
	 *  data and thus serves as an estimate of the noise in the
	 *  anomalous signals.
	 */
	public java.lang.Float getRatio_one_wl_centric() 
	{
		return ratio_one_wl_centric;
	}
 
	public void setRatio_one_wl_centric(java.lang.Float ratio_one_wl_centric)
	{
		this.ratio_one_wl_centric = ratio_one_wl_centric;
	}

 	protected java.lang.Float ratio_two_wl;


	/**
	 *  The root-mean-square dispersive Bijvoet difference between
	 *  two wavelengths for all reflections.
	 */
	public java.lang.Float getRatio_two_wl() 
	{
		return ratio_two_wl;
	}
 
	public void setRatio_two_wl(java.lang.Float ratio_two_wl)
	{
		this.ratio_two_wl = ratio_two_wl;
	}

 	protected java.lang.Float wavelength_1;


	/**
	 *  This data item is a pointer to  attribute wavelength in category phasing_MAD_set in
	 *  the PHASING_MAD_SET category.
	 */
	public java.lang.Float getWavelength_1() 
	{
		return wavelength_1;
	}
 
	public void setWavelength_1(java.lang.Float wavelength_1)
	{
		this.wavelength_1 = wavelength_1;
	}

 	protected java.lang.Float wavelength_2;


	/**
	 *  This data item is a pointer to  attribute wavelength in category phasing_MAD_set in
	 *  the PHASING_MAD_SET category.
	 */
	public java.lang.Float getWavelength_2() 
	{
		return wavelength_2;
	}
 
	public void setWavelength_2(java.lang.Float wavelength_2)
	{
		this.wavelength_2 = wavelength_2;
	}

 }
