package org.pdb.beans;

/**
 *  Data items in the PHASING_MAD_SET category record
 *  details about the individual data sets used in a MAD phasing
 *  experiment.
 *  
 * <pre>
 *  Example 1 - based on a paper by Shapiro et al. [Nature (London)
 *  (1995), 374, 327-337].
 *  <PDBx:phasing_MAD_setCategory>
 *  <PDBx:phasing_MAD_set expt_id="1" clust_id="4 wavelength" set_id="aa" wavelength="1.4013">
 *  <PDBx:wavelength_details>pre-edge</PDBx:wavelength_details>
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:f_prime>-12.48</PDBx:f_prime>
 *  <PDBx:f_double_prime>3.80</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="1" clust_id="4 wavelength" set_id="bb" wavelength="1.3857">
 *  <PDBx:wavelength_details>peak</PDBx:wavelength_details>
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:f_prime>-31.22</PDBx:f_prime>
 *  <PDBx:f_double_prime>17.20</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="1" clust_id="4 wavelength" set_id="cc" wavelength="1.3852">
 *  <PDBx:wavelength_details>edge</PDBx:wavelength_details>
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:f_prime>-13.97</PDBx:f_prime>
 *  <PDBx:f_double_prime>29.17</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="1" clust_id="4 wavelength" set_id="dd" wavelength="1.3847">
 *  <PDBx:wavelength_details>remote</PDBx:wavelength_details>
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:f_prime>-6.67</PDBx:f_prime>
 *  <PDBx:f_double_prime>17.34</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="1" clust_id="5 wavelength" set_id="ee" wavelength="1.3857">
 *  <PDBx:wavelength_details>ascending edge</PDBx:wavelength_details>
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:f_prime>-28.33</PDBx:f_prime>
 *  <PDBx:f_double_prime>14.84</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="1" clust_id="5 wavelength" set_id="ff" wavelength="1.3852">
 *  <PDBx:wavelength_details>peak</PDBx:wavelength_details>
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:f_prime>-21.50</PDBx:f_prime>
 *  <PDBx:f_double_prime>30.23</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="1" clust_id="5 wavelength" set_id="gg" wavelength="1.3847">
 *  <PDBx:wavelength_details>descending edge</PDBx:wavelength_details>
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:f_prime>-10.71</PDBx:f_prime>
 *  <PDBx:f_double_prime>20.35</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="1" clust_id="5 wavelength" set_id="hh" wavelength="1.3784">
 *  <PDBx:wavelength_details>remote 1</PDBx:wavelength_details>
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:f_prime>-14.45</PDBx:f_prime>
 *  <PDBx:f_double_prime>11.84</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="1" clust_id="5 wavelength" set_id="ii" wavelength="1.2862">
 *  <PDBx:wavelength_details>remote 2</PDBx:wavelength_details>
 *  <PDBx:d_res_low>20.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>3.00</PDBx:d_res_high>
 *  <PDBx:f_prime>-9.03</PDBx:f_prime>
 *  <PDBx:f_double_prime>9.01</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="2" clust_id="5 wavelength" set_id="jj" wavelength="0.7263">
 *  <PDBx:wavelength_details>pre-edge</PDBx:wavelength_details>
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:f_prime>-21.10</PDBx:f_prime>
 *  <PDBx:f_double_prime>4.08</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="2" clust_id="5 wavelength" set_id="kk" wavelength="0.7251">
 *  <PDBx:wavelength_details>edge</PDBx:wavelength_details>
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:f_prime>-34.72</PDBx:f_prime>
 *  <PDBx:f_double_prime>7.92</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="2" clust_id="5 wavelength" set_id="ll" wavelength="0.7248">
 *  <PDBx:wavelength_details>peak</PDBx:wavelength_details>
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:f_prime>-24.87</PDBx:f_prime>
 *  <PDBx:f_double_prime>10.30</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="2" clust_id="5 wavelength" set_id="mm" wavelength="0.7246">
 *  <PDBx:wavelength_details>descending edge</PDBx:wavelength_details>
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:f_prime>-17.43</PDBx:f_prime>
 *  <PDBx:f_double_prime>9.62</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  <PDBx:phasing_MAD_set expt_id="2" clust_id="5 wavelength" set_id="nn" wavelength="0.7217">
 *  <PDBx:wavelength_details>remote</PDBx:wavelength_details>
 *  <PDBx:d_res_low>15.00</PDBx:d_res_low>
 *  <PDBx:d_res_high>1.90</PDBx:d_res_high>
 *  <PDBx:f_prime>-13.26</PDBx:f_prime>
 *  <PDBx:f_double_prime>8.40</PDBx:f_double_prime>
 *  </PDBx:phasing_MAD_set>
 *  </PDBx:phasing_MAD_setCategory>
 * </pre>
 */
public class Phasing_MAD_set 
{
		protected java.lang.String clust_id;


	/**
	 *  This data item is a pointer to  attribute id in category phasing_MAD_clust in
	 *  the PHASING_MAD_CLUST category.
	 */
	public java.lang.String getClust_id() 
	{
		return clust_id;
	}
 
	public void setClust_id(java.lang.String clust_id)
	{
		this.clust_id = clust_id;
	}

 	protected java.lang.Float d_res_high;


	/**
	 *  The lowest value for the interplanar spacings for the
	 *  reflection data used for this set of data. This is called
	 *  the highest resolution.
	 */
	public java.lang.Float getD_res_high() 
	{
		return d_res_high;
	}
 
	public void setD_res_high(java.lang.Float d_res_high)
	{
		this.d_res_high = d_res_high;
	}

 	protected java.lang.Float d_res_low;


	/**
	 *  The highest value for the interplanar spacings for the
	 *  reflection data used for this set of data. This is called
	 *  the lowest resolution.
	 */
	public java.lang.Float getD_res_low() 
	{
		return d_res_low;
	}
 
	public void setD_res_low(java.lang.Float d_res_low)
	{
		this.d_res_low = d_res_low;
	}

 	protected java.lang.String expt_id;


	/**
	 *  This data item is a pointer to  attribute id in category phasing_MAD_expt in the
	 *  PHASING_MAD_EXPT category.
	 */
	public java.lang.String getExpt_id() 
	{
		return expt_id;
	}
 
	public void setExpt_id(java.lang.String expt_id)
	{
		this.expt_id = expt_id;
	}

 	protected java.lang.Float f_double_prime;


	/**
	 *  The f'' component of the anomalous scattering factor for this
	 *  wavelength.
	 */
	public java.lang.Float getF_double_prime() 
	{
		return f_double_prime;
	}
 
	public void setF_double_prime(java.lang.Float f_double_prime)
	{
		this.f_double_prime = f_double_prime;
	}

 	protected java.lang.Float f_prime;


	/**
	 *  The f' component of the anomalous scattering factor for this
	 *  wavelength.
	 */
	public java.lang.Float getF_prime() 
	{
		return f_prime;
	}
 
	public void setF_prime(java.lang.Float f_prime)
	{
		this.f_prime = f_prime;
	}

 	protected java.lang.String pdbx_atom_type;


	/**
	 *  record the type of heavy atoms which produce anomolous singal.
	 */
	public java.lang.String getPdbx_atom_type() 
	{
		return pdbx_atom_type;
	}
 
	public void setPdbx_atom_type(java.lang.String pdbx_atom_type)
	{
		this.pdbx_atom_type = pdbx_atom_type;
	}

 	protected java.lang.Float pdbx_f_double_prime_refined;


	/**
	 *  record the refined f_double_prime (not from experiment).
	 */
	public java.lang.Float getPdbx_f_double_prime_refined() 
	{
		return pdbx_f_double_prime_refined;
	}
 
	public void setPdbx_f_double_prime_refined(java.lang.Float pdbx_f_double_prime_refined)
	{
		this.pdbx_f_double_prime_refined = pdbx_f_double_prime_refined;
	}

 	protected java.lang.Float pdbx_f_prime_refined;


	/**
	 *  record the refined f_prime (not from experiment).
	 */
	public java.lang.Float getPdbx_f_prime_refined() 
	{
		return pdbx_f_prime_refined;
	}
 
	public void setPdbx_f_prime_refined(java.lang.Float pdbx_f_prime_refined)
	{
		this.pdbx_f_prime_refined = pdbx_f_prime_refined;
	}

 	protected java.lang.String set_id;


	/**
	 *  This data item is a pointer to  attribute id in category phasing_set in the
	 *  PHASING_SET category.
	 */
	public java.lang.String getSet_id() 
	{
		return set_id;
	}
 
	public void setSet_id(java.lang.String set_id)
	{
		this.set_id = set_id;
	}

 	protected java.lang.Float wavelength;


	/**
	 *  The wavelength at which this data set was measured.
	 */
	public java.lang.Float getWavelength() 
	{
		return wavelength;
	}
 
	public void setWavelength(java.lang.Float wavelength)
	{
		this.wavelength = wavelength;
	}

 	protected java.lang.String wavelength_details;


	/**
	 *  A descriptor for this wavelength in this cluster of data sets.
	 *  peak
	 *  remote
	 *  ascending edge
	 */
	public java.lang.String getWavelength_details() 
	{
		return wavelength_details;
	}
 
	public void setWavelength_details(java.lang.String wavelength_details)
	{
		this.wavelength_details = wavelength_details;
	}

 }
