package org.pdb.beans;

/**
 *  Data items in the PHASING_MIR category record details about
 *  the phasing of the structure where methods involving isomorphous
 *  replacement are involved.
 *  
 *  All isomorphous-replacement-based techniques are covered
 *  by this category, including single isomorphous replacement (SIR),
 *  multiple isomorphous replacement (MIR) and single or multiple
 *  isomorphous replacement plus anomalous scattering (SIRAS, MIRAS).
 *  
 * <pre>
 *  Example 1 - based on a paper by Zanotti et al. [J. Biol. Chem.
 *  (1993), 268, 10728-10738].
 *  <PDBx:phasing_MIRCategory>
 *  <PDBx:phasing_MIR>
 *  <PDBx:method> Standard phase refinement (Blow &amp; Crick, 1959)</PDBx:method>
 *  </PDBx:phasing_MIR>
 *  </PDBx:phasing_MIRCategory>
 * </pre>
 */
public class Phasing_MIR 
{
		protected java.lang.Float FOM;


	/**
	 *  The mean value of the figure of merit m for all reflections
	 *  phased in the native data set.
	 *  
	 *  int P~alpha~ exp(i*alpha) dalpha
	 *  m = --------------------------------
	 *  int P~alpha~ dalpha
	 *  
	 *  P~a~ = the probability that the phase angle a is correct
	 *  
	 *  the integral is taken over the range alpha = 0 to 2 pi.
	 */
	public java.lang.Float getFOM() 
	{
		return FOM;
	}
 
	public void setFOM(java.lang.Float FOM)
	{
		this.FOM = FOM;
	}

 	protected java.lang.Float FOM_acentric;


	/**
	 *  The mean value of the figure of merit m for the acentric
	 *  reflections phased in the native data set.
	 *  
	 *  int P~alpha~ exp(i*alpha) dalpha
	 *  m = --------------------------------
	 *  int P~alpha~ dalpha
	 *  
	 *  P~a~ = the probability that the phase angle a is correct
	 *  
	 *  the integral is taken over the range alpha = 0 to 2 pi.
	 */
	public java.lang.Float getFOM_acentric() 
	{
		return FOM_acentric;
	}
 
	public void setFOM_acentric(java.lang.Float FOM_acentric)
	{
		this.FOM_acentric = FOM_acentric;
	}

 	protected java.lang.Float FOM_centric;


	/**
	 *  The mean value of the figure of merit m for the centric
	 *  reflections phased in the native data set.
	 *  
	 *  int P~alpha~ exp(i*alpha) dalpha
	 *  m = --------------------------------
	 *  int P~alpha~ dalpha
	 *  
	 *  P~a~ = the probability that the phase angle a is correct
	 *  
	 *  the integral is taken over the range alpha = 0 to 2 pi.
	 */
	public java.lang.Float getFOM_centric() 
	{
		return FOM_centric;
	}
 
	public void setFOM_centric(java.lang.Float FOM_centric)
	{
		this.FOM_centric = FOM_centric;
	}

 	protected java.lang.Float d_res_high;


	/**
	 *  The lowest value in angstroms for the interplanar spacings
	 *  for the reflection data used for the native data set. This is
	 *  called the highest resolution.
	 */
	public java.lang.Float getD_res_high() 
	{
		return d_res_high;
	}
 
	public void setD_res_high(java.lang.Float d_res_high)
	{
		this.d_res_high = d_res_high;
	}

 	protected java.lang.Float d_res_low;


	/**
	 *  The highest value in angstroms for the interplanar spacings
	 *  for the reflection data used for the native data set. This is
	 *  called the lowest resolution.
	 */
	public java.lang.Float getD_res_low() 
	{
		return d_res_low;
	}
 
	public void setD_res_low(java.lang.Float d_res_low)
	{
		this.d_res_low = d_res_low;
	}

 	protected java.lang.String details;


	/**
	 *  A description of special aspects of the isomorphous-replacement
	 *  phasing.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String method;


	/**
	 *  A description of the MIR phasing method applied to phase this
	 *  structure.
	 *  
	 *  Note that this is not the computer program used, which is
	 *  described in the SOFTWARE category, but rather the method
	 *  itself.
	 *  
	 *  This data item should be used to describe significant
	 *  methodological options used within the MIR phasing program.
	 */
	public java.lang.String getMethod() 
	{
		return method;
	}
 
	public void setMethod(java.lang.String method)
	{
		this.method = method;
	}

 	protected java.lang.Integer pdbx_number_derivatives;


	/**
	 *  The number of derivatives used in this phasing experiment.
	 */
	public java.lang.Integer getPdbx_number_derivatives() 
	{
		return pdbx_number_derivatives;
	}
 
	public void setPdbx_number_derivatives(java.lang.Integer pdbx_number_derivatives)
	{
		this.pdbx_number_derivatives = pdbx_number_derivatives;
	}

 	protected java.lang.Integer reflns;


	/**
	 *  The total number of reflections phased in the native data set.
	 */
	public java.lang.Integer getReflns() 
	{
		return reflns;
	}
 
	public void setReflns(java.lang.Integer reflns)
	{
		this.reflns = reflns;
	}

 	protected java.lang.Integer reflns_acentric;


	/**
	 *  The number of acentric reflections phased in the native data
	 *  set.
	 */
	public java.lang.Integer getReflns_acentric() 
	{
		return reflns_acentric;
	}
 
	public void setReflns_acentric(java.lang.Integer reflns_acentric)
	{
		this.reflns_acentric = reflns_acentric;
	}

 	protected java.lang.Integer reflns_centric;


	/**
	 *  The number of centric reflections phased in the native data
	 *  set.
	 */
	public java.lang.Integer getReflns_centric() 
	{
		return reflns_centric;
	}
 
	public void setReflns_centric(java.lang.Integer reflns_centric)
	{
		this.reflns_centric = reflns_centric;
	}

 	protected java.lang.String reflns_criterion;


	/**
	 *  Criterion used to limit the reflections used in the phasing
	 *  calculations.
	 *  > 4 \s(I)
	 */
	public java.lang.String getReflns_criterion() 
	{
		return reflns_criterion;
	}
 
	public void setReflns_criterion(java.lang.String reflns_criterion)
	{
		this.reflns_criterion = reflns_criterion;
	}

 }
