package org.pdb.beans;

/**
 *  Data items in the PHASING_MIR_DER category record details
 *  about individual derivatives used in the phasing of the
 *  structure when methods involving isomorphous replacement are
 *  involved.
 *  
 *  A derivative in this context does not necessarily equate with
 *  a data set; for instance, the same data set could be used to
 *  one resolution limit as an isomorphous scatterer and to a
 *  different resolution (and with a different sigma cutoff) as an
 *  anomalous scatterer. These would be treated as two distinct
 *  derivatives, although both derivatives would point to the same
 *  data sets via  attribute der_set_id in category phasing_MIR_der and
 *  attribute native_set_id in category phasing_MIR_der.
 *  
 * <pre>
 *  Example 1 - based on a paper by Zanotti et al. [J. Biol. Chem.
 *  (1993), 268, 10728-10738].
 *  <PDBx:phasing_MIR_derCategory>
 *  <PDBx:phasing_MIR_der id="KAu(CN)2">
 *  <PDBx:number_of_sites>3</PDBx:number_of_sites>
 *  <PDBx:details>major site interpreted in difference Patterson</PDBx:details>
 *  </PDBx:phasing_MIR_der>
 *  <PDBx:phasing_MIR_der id="K2HgI4">
 *  <PDBx:number_of_sites>6</PDBx:number_of_sites>
 *  <PDBx:details>sites found in cross-difference Fourier</PDBx:details>
 *  </PDBx:phasing_MIR_der>
 *  <PDBx:phasing_MIR_der id="K3IrCl6">
 *  <PDBx:number_of_sites>2</PDBx:number_of_sites>
 *  <PDBx:details>sites found in cross-difference Fourier</PDBx:details>
 *  </PDBx:phasing_MIR_der>
 *  <PDBx:phasing_MIR_der id="All">
 *  <PDBx:number_of_sites>11</PDBx:number_of_sites>
 *  <PDBx:details>data for all three derivatives combined</PDBx:details>
 *  </PDBx:phasing_MIR_der>
 *  </PDBx:phasing_MIR_derCategory>
 * </pre>
 */
public class Phasing_MIR_der 
{
		protected java.lang.Float R_cullis_acentric;


	/**
	 *  Residual factor R~cullis,acen~ for acentric reflections for this
	 *  derivative.
	 *  
	 *  The Cullis R factor was originally defined only for centric
	 *  reflections.  It is, however, also a useful statistical
	 *  measure for acentric reflections, which is how it is used in
	 *  this data item.
	 *  
	 *  sum| |Fph~obs~ +/- Fp~obs~| - Fh~calc~ |
	 *  R~cullis,acen~ = ----------------------------------------
	 *  sum|Fph~obs~ - Fp~obs~|
	 *  
	 *  Fp~obs~  = the observed structure-factor amplitude of the native
	 *  Fph~obs~ = the observed structure-factor amplitude of the
	 *  derivative
	 *  Fh~calc~ = the calculated structure-factor amplitude from the
	 *  heavy-atom model
	 *  
	 *  sum is taken over the specified reflections
	 *  
	 *  Ref: Cullis, A. F., Muirhead, H., Perutz, M. F., Rossmann, M. G.
	 *  & North, A. C. T. (1961). Proc. R. Soc. London Ser. A,
	 *  265, 15-38.
	 */
	public java.lang.Float getR_cullis_acentric() 
	{
		return R_cullis_acentric;
	}
 
	public void setR_cullis_acentric(java.lang.Float R_cullis_acentric)
	{
		this.R_cullis_acentric = R_cullis_acentric;
	}

 	protected java.lang.Float R_cullis_anomalous;


	/**
	 *  Residual factor R~cullis,ano~ for anomalous reflections for this
	 *  derivative.
	 *  
	 *  The Cullis R factor was originally defined only for centric
	 *  reflections.  It is, however, also a useful statistical
	 *  measure for anomalous  reflections, which is how it is used in
	 *  this data item.
	 *  
	 *  This is tabulated for acentric terms.  A value less than 1.0
	 *  means there is some contribution to the phasing from the
	 *  anomalous data.
	 *  
	 *  sum |Fph+~obs~Fph-~obs~ - Fh+~calc~ - Fh-~calc~|
	 *  R~cullis,ano~ = ------------------------------------------------
	 *  sum|Fph+~obs~ - Fph-~obs~|
	 *  
	 *  Fph+~obs~  = the observed positive Friedel structure-factor
	 *  amplitude for the derivative
	 *  Fph-~obs~  = the observed negative Friedel structure-factor
	 *  amplitude for the derivative
	 *  
	 *  Fh+~calc~  = the calculated positive Friedel structure-factor
	 *  amplitude from the heavy-atom model
	 *  Fh-~calc~  = the calculated negative Friedel structure-factor
	 *  amplitude from the heavy-atom model
	 *  
	 *  sum is taken over the specified reflections
	 *  
	 *  Ref: Cullis, A. F., Muirhead, H., Perutz, M. F., Rossmann, M. G.
	 *  & North, A. C. T. (1961). Proc. R. Soc.  London Ser. A,
	 *  265, 15-38.
	 */
	public java.lang.Float getR_cullis_anomalous() 
	{
		return R_cullis_anomalous;
	}
 
	public void setR_cullis_anomalous(java.lang.Float R_cullis_anomalous)
	{
		this.R_cullis_anomalous = R_cullis_anomalous;
	}

 	protected java.lang.Float R_cullis_centric;


	/**
	 *  Residual factor R~cullis~ for centric reflections for this
	 *  derivative.
	 *  
	 *  sum| |Fph~obs~ +/- Fp~obs~| - Fh~calc~ |
	 *  R~cullis~ = ----------------------------------------
	 *  sum|Fph~obs~ - Fp~obs~|
	 *  
	 *  Fp~obs~  = the observed structure-factor amplitude of the native
	 *  Fph~obs~ = the observed structure-factor amplitude of the
	 *  derivative
	 *  Fh~calc~ = the calculated structure-factor amplitude from the
	 *  heavy-atom model
	 *  
	 *  sum is taken over the specified reflections
	 *  
	 *  Ref: Cullis, A. F., Muirhead, H., Perutz, M. F., Rossmann, M. G.
	 *  & North, A. C. T. (1961). Proc. R. Soc. London Ser. A,
	 *  265, 15-38.
	 */
	public java.lang.Float getR_cullis_centric() 
	{
		return R_cullis_centric;
	}
 
	public void setR_cullis_centric(java.lang.Float R_cullis_centric)
	{
		this.R_cullis_centric = R_cullis_centric;
	}

 	protected java.lang.Float d_res_high;


	/**
	 *  The lowest value for the interplanar spacings for the
	 *  reflection data used for this derivative. This is called the
	 *  highest resolution.
	 */
	public java.lang.Float getD_res_high() 
	{
		return d_res_high;
	}
 
	public void setD_res_high(java.lang.Float d_res_high)
	{
		this.d_res_high = d_res_high;
	}

 	protected java.lang.Float d_res_low;


	/**
	 *  The highest value for  the interplanar spacings for the
	 *  reflection data used for this derivative. This is called the
	 *  lowest resolution.
	 */
	public java.lang.Float getD_res_low() 
	{
		return d_res_low;
	}
 
	public void setD_res_low(java.lang.Float d_res_low)
	{
		this.d_res_low = d_res_low;
	}

 	protected java.lang.String der_set_id;


	/**
	 *  The data set that was treated as the derivative in this
	 *  experiment.
	 *  
	 *  This data item is a pointer to  attribute id in category phasing_set in the
	 *  PHASING_SET category.
	 */
	public java.lang.String getDer_set_id() 
	{
		return der_set_id;
	}
 
	public void setDer_set_id(java.lang.String der_set_id)
	{
		this.der_set_id = der_set_id;
	}

 	protected java.lang.String details;


	/**
	 *  A description of special aspects of this derivative, its data,
	 *  its solution or its use in phasing.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category phasing_MIR_der must uniquely identify
	 *  a record in the PHASING_MIR_DER list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 *  KAu(CN)2
	 *  K2HgI4_anom
	 *  K2HgI4_iso
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String native_set_id;


	/**
	 *  The data set that was treated as the native in this
	 *  experiment.
	 *  
	 *  This data item is a pointer to  attribute id in category phasing_set in the
	 *  PHASING_SET category.
	 */
	public java.lang.String getNative_set_id() 
	{
		return native_set_id;
	}
 
	public void setNative_set_id(java.lang.String native_set_id)
	{
		this.native_set_id = native_set_id;
	}

 	protected java.lang.Integer number_of_sites;


	/**
	 *  The number of heavy-atom sites in this derivative.
	 */
	public java.lang.Integer getNumber_of_sites() 
	{
		return number_of_sites;
	}
 
	public void setNumber_of_sites(java.lang.Integer number_of_sites)
	{
		this.number_of_sites = number_of_sites;
	}

 	protected java.lang.Float pdbx_R_cullis;


	/**
	 *  record R_cullis for each derivative.
	 */
	public java.lang.Float getPdbx_R_cullis() 
	{
		return pdbx_R_cullis;
	}
 
	public void setPdbx_R_cullis(java.lang.Float pdbx_R_cullis)
	{
		this.pdbx_R_cullis = pdbx_R_cullis;
	}

 	protected java.lang.Float pdbx_R_kraut;


	/**
	 *  record R_kraut obtained from all data data for each derivative.
	 */
	public java.lang.Float getPdbx_R_kraut() 
	{
		return pdbx_R_kraut;
	}
 
	public void setPdbx_R_kraut(java.lang.Float pdbx_R_kraut)
	{
		this.pdbx_R_kraut = pdbx_R_kraut;
	}

 	protected java.lang.Float pdbx_R_kraut_acentric;


	/**
	 *  record R_kraut obtained from acentric data for each derivative.
	 */
	public java.lang.Float getPdbx_R_kraut_acentric() 
	{
		return pdbx_R_kraut_acentric;
	}
 
	public void setPdbx_R_kraut_acentric(java.lang.Float pdbx_R_kraut_acentric)
	{
		this.pdbx_R_kraut_acentric = pdbx_R_kraut_acentric;
	}

 	protected java.lang.Float pdbx_R_kraut_centric;


	/**
	 *  record R_kraut obtained from centric data for each derivative.
	 */
	public java.lang.Float getPdbx_R_kraut_centric() 
	{
		return pdbx_R_kraut_centric;
	}
 
	public void setPdbx_R_kraut_centric(java.lang.Float pdbx_R_kraut_centric)
	{
		this.pdbx_R_kraut_centric = pdbx_R_kraut_centric;
	}

 	protected java.lang.Float pdbx_fom;


	/**
	 *  record figure of merit obtained from all data for
	 *  each derivative.
	 */
	public java.lang.Float getPdbx_fom() 
	{
		return pdbx_fom;
	}
 
	public void setPdbx_fom(java.lang.Float pdbx_fom)
	{
		this.pdbx_fom = pdbx_fom;
	}

 	protected java.lang.Float pdbx_fom_acentric;


	/**
	 *  record figure of merit obtained from acentric data for
	 *  each derivative.
	 */
	public java.lang.Float getPdbx_fom_acentric() 
	{
		return pdbx_fom_acentric;
	}
 
	public void setPdbx_fom_acentric(java.lang.Float pdbx_fom_acentric)
	{
		this.pdbx_fom_acentric = pdbx_fom_acentric;
	}

 	protected java.lang.Float pdbx_fom_centric;


	/**
	 *  record figure of merit obtained from centric data for
	 *  each derivative.
	 */
	public java.lang.Float getPdbx_fom_centric() 
	{
		return pdbx_fom_centric;
	}
 
	public void setPdbx_fom_centric(java.lang.Float pdbx_fom_centric)
	{
		this.pdbx_fom_centric = pdbx_fom_centric;
	}

 	protected java.lang.Float pdbx_loc;


	/**
	 *  record lack of closure obtained from all data for
	 *  each derivative.
	 */
	public java.lang.Float getPdbx_loc() 
	{
		return pdbx_loc;
	}
 
	public void setPdbx_loc(java.lang.Float pdbx_loc)
	{
		this.pdbx_loc = pdbx_loc;
	}

 	protected java.lang.Float pdbx_loc_acentric;


	/**
	 *  record lack of closure obtained from acentric data for
	 *  each derivative.
	 */
	public java.lang.Float getPdbx_loc_acentric() 
	{
		return pdbx_loc_acentric;
	}
 
	public void setPdbx_loc_acentric(java.lang.Float pdbx_loc_acentric)
	{
		this.pdbx_loc_acentric = pdbx_loc_acentric;
	}

 	protected java.lang.Float pdbx_loc_centric;


	/**
	 *  record lack of closure obtained from centric data for
	 *  each derivative.
	 */
	public java.lang.Float getPdbx_loc_centric() 
	{
		return pdbx_loc_centric;
	}
 
	public void setPdbx_loc_centric(java.lang.Float pdbx_loc_centric)
	{
		this.pdbx_loc_centric = pdbx_loc_centric;
	}

 	protected java.lang.Float pdbx_power;


	/**
	 *  record phasing power for each derivative.
	 */
	public java.lang.Float getPdbx_power() 
	{
		return pdbx_power;
	}
 
	public void setPdbx_power(java.lang.Float pdbx_power)
	{
		this.pdbx_power = pdbx_power;
	}

 	protected java.lang.Integer pdbx_reflns;


	/**
	 *  record number of reflections used for each derivative.
	 */
	public java.lang.Integer getPdbx_reflns() 
	{
		return pdbx_reflns;
	}
 
	public void setPdbx_reflns(java.lang.Integer pdbx_reflns)
	{
		this.pdbx_reflns = pdbx_reflns;
	}

 	protected java.lang.Float power_acentric;


	/**
	 *  The mean phasing power P for acentric reflections for this
	 *  derivative.
	 *  
	 *  sum|Fh~calc~^2^|
	 *  P = (----------------------------)^1/2^
	 *  sum|Fph~obs~ - Fph~calc~|^2^
	 *  
	 *  Fph~obs~  = the observed structure-factor amplitude of this
	 *  derivative
	 *  Fph~calc~ = the calculated structure-factor amplitude of this
	 *  derivative
	 *  Fh~calc~  = the calculated structure-factor amplitude from the
	 *  heavy-atom model
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getPower_acentric() 
	{
		return power_acentric;
	}
 
	public void setPower_acentric(java.lang.Float power_acentric)
	{
		this.power_acentric = power_acentric;
	}

 	protected java.lang.Float power_centric;


	/**
	 *  The mean phasing power P for centric reflections for this
	 *  derivative.
	 *  
	 *  sum|Fh~calc~^2^|
	 *  P = (----------------------------)^1/2^
	 *  sum|Fph~obs~ - Fph~calc~|^2^
	 *  
	 *  Fph~obs~  = the observed structure-factor amplitude of the
	 *  derivative
	 *  Fph~calc~ = the calculated structure-factor amplitude of the
	 *  derivative
	 *  Fh~calc~  = the calculated structure-factor amplitude from the
	 *  heavy-atom model
	 *  
	 *  sum is taken over the specified reflections
	 */
	public java.lang.Float getPower_centric() 
	{
		return power_centric;
	}
 
	public void setPower_centric(java.lang.Float power_centric)
	{
		this.power_centric = power_centric;
	}

 	protected java.lang.Integer reflns_acentric;


	/**
	 *  The number of acentric reflections used in phasing for this
	 *  derivative.
	 */
	public java.lang.Integer getReflns_acentric() 
	{
		return reflns_acentric;
	}
 
	public void setReflns_acentric(java.lang.Integer reflns_acentric)
	{
		this.reflns_acentric = reflns_acentric;
	}

 	protected java.lang.Integer reflns_anomalous;


	/**
	 *  The number of anomalous reflections used in phasing for this
	 *  derivative.
	 */
	public java.lang.Integer getReflns_anomalous() 
	{
		return reflns_anomalous;
	}
 
	public void setReflns_anomalous(java.lang.Integer reflns_anomalous)
	{
		this.reflns_anomalous = reflns_anomalous;
	}

 	protected java.lang.Integer reflns_centric;


	/**
	 *  The number of centric reflections used in phasing for this
	 *  derivative.
	 */
	public java.lang.Integer getReflns_centric() 
	{
		return reflns_centric;
	}
 
	public void setReflns_centric(java.lang.Integer reflns_centric)
	{
		this.reflns_centric = reflns_centric;
	}

 	protected java.lang.String reflns_criteria;


	/**
	 *  Criteria used to limit the reflections used in the phasing
	 *  calculations.
	 *  > 4 \s(I)
	 */
	public java.lang.String getReflns_criteria() 
	{
		return reflns_criteria;
	}
 
	public void setReflns_criteria(java.lang.String reflns_criteria)
	{
		this.reflns_criteria = reflns_criteria;
	}

 }
