package org.pdb.beans;

/**
 *  Data items in the PHASING_MIR_DER_SITE category record details
 *  about the heavy-atom sites in an MIR phasing experiment.
 *  
 *  This list may contain information from a number of different
 *  derivatives;  attribute der_id in category phasing_MIR_der_site indicates to which
 *  derivative a given record corresponds. (A derivative in this
 *  context does not necessarily equate with a data set; see the
 *  definition of the PHASING_MIR_DER category for a
 *  discussion of the meaning of derivative.)
 *  
 * <pre>
 *  Example 1 - based on a paper by Zanotti et al. [J. Biol. Chem.
 *  (1993), 268, 10728-10738]
 *  with occupancies converted from electrons to fractional.
 *  <PDBx:phasing_MIR_der_siteCategory>
 *  <PDBx:phasing_MIR_der_site der_id="KAu(CN)2" id="1">
 *  <PDBx:atom_type_symbol>Au</PDBx:atom_type_symbol>
 *  <PDBx:occupancy>0.40</PDBx:occupancy>
 *  <PDBx:fract_x>0.082</PDBx:fract_x>
 *  <PDBx:fract_y>0.266</PDBx:fract_y>
 *  <PDBx:fract_z>0.615</PDBx:fract_z>
 *  <PDBx:B_iso>33.0</PDBx:B_iso>
 *  </PDBx:phasing_MIR_der_site>
 *  <PDBx:phasing_MIR_der_site der_id="KAu(CN)2" id="2">
 *  <PDBx:atom_type_symbol>Au</PDBx:atom_type_symbol>
 *  <PDBx:occupancy>0.03</PDBx:occupancy>
 *  <PDBx:fract_x>0.607</PDBx:fract_x>
 *  <PDBx:fract_y>0.217</PDBx:fract_y>
 *  <PDBx:fract_z>0.816</PDBx:fract_z>
 *  <PDBx:B_iso>25.9</PDBx:B_iso>
 *  </PDBx:phasing_MIR_der_site>
 *  <PDBx:phasing_MIR_der_site der_id="KAu(CN)2" id="3">
 *  <PDBx:atom_type_symbol>Au</PDBx:atom_type_symbol>
 *  <PDBx:occupancy>0.02</PDBx:occupancy>
 *  <PDBx:fract_x>0.263</PDBx:fract_x>
 *  <PDBx:fract_y>0.782</PDBx:fract_y>
 *  <PDBx:fract_z>0.906</PDBx:fract_z>
 *  <PDBx:B_iso>15.7</PDBx:B_iso>
 *  </PDBx:phasing_MIR_der_site>
 *  <PDBx:phasing_MIR_der_site der_id="K2HgI4" id="1">
 *  <PDBx:atom_type_symbol>Hg</PDBx:atom_type_symbol>
 *  <PDBx:occupancy>0.63</PDBx:occupancy>
 *  <PDBx:fract_x>0.048</PDBx:fract_x>
 *  <PDBx:fract_y>0.286</PDBx:fract_y>
 *  <PDBx:fract_z>0.636</PDBx:fract_z>
 *  <PDBx:B_iso>33.7</PDBx:B_iso>
 *  </PDBx:phasing_MIR_der_site>
 *  <PDBx:phasing_MIR_der_site der_id="K2HgI4" id="2">
 *  <PDBx:atom_type_symbol>Hg</PDBx:atom_type_symbol>
 *  <PDBx:occupancy>0.34</PDBx:occupancy>
 *  <PDBx:fract_x>0.913</PDBx:fract_x>
 *  <PDBx:fract_y>0.768</PDBx:fract_y>
 *  <PDBx:fract_z>0.889</PDBx:fract_z>
 *  <PDBx:B_iso>36.7</PDBx:B_iso>
 *  </PDBx:phasing_MIR_der_site>
 *  <PDBx:phasing_MIR_der_site der_id="K2HgI4" id="3">
 *  <PDBx:atom_type_symbol>Hg</PDBx:atom_type_symbol>
 *  <PDBx:occupancy>0.23</PDBx:occupancy>
 *  <PDBx:fract_x>0.974</PDBx:fract_x>
 *  <PDBx:fract_y>0.455</PDBx:fract_y>
 *  <PDBx:fract_z>0.974</PDBx:fract_z>
 *  <PDBx:B_iso>24.2</PDBx:B_iso>
 *  </PDBx:phasing_MIR_der_site>
 *  <PDBx:phasing_MIR_der_site der_id="K2HgI4" id="4">
 *  <PDBx:atom_type_symbol>Hg</PDBx:atom_type_symbol>
 *  <PDBx:occupancy>0.28</PDBx:occupancy>
 *  <PDBx:fract_x>0.903</PDBx:fract_x>
 *  <PDBx:fract_y>0.836</PDBx:fract_y>
 *  <PDBx:fract_z>0.859</PDBx:fract_z>
 *  <PDBx:B_iso>14.7</PDBx:B_iso>
 *  </PDBx:phasing_MIR_der_site>
 *  <PDBx:phasing_MIR_der_site der_id="K2HgI4" id="5">
 *  <PDBx:atom_type_symbol>Hg</PDBx:atom_type_symbol>
 *  <PDBx:occupancy>0.07</PDBx:occupancy>
 *  <PDBx:fract_x>0.489</PDBx:fract_x>
 *  <PDBx:fract_y>0.200</PDBx:fract_y>
 *  <PDBx:fract_z>0.885</PDBx:fract_z>
 *  <PDBx:B_iso>6.4</PDBx:B_iso>
 *  </PDBx:phasing_MIR_der_site>
 *  <PDBx:phasing_MIR_der_site der_id="K2HgI4" id="6">
 *  <PDBx:atom_type_symbol>Hg</PDBx:atom_type_symbol>
 *  <PDBx:occupancy>0.07</PDBx:occupancy>
 *  <PDBx:fract_x>0.162</PDBx:fract_x>
 *  <PDBx:fract_y>0.799</PDBx:fract_y>
 *  <PDBx:fract_z>0.889</PDBx:fract_z>
 *  <PDBx:B_iso>32.9</PDBx:B_iso>
 *  </PDBx:phasing_MIR_der_site>
 *  <PDBx:phasing_MIR_der_site der_id="K3IrCl6" id="1">
 *  <PDBx:atom_type_symbol>Ir</PDBx:atom_type_symbol>
 *  <PDBx:occupancy>0.26</PDBx:occupancy>
 *  <PDBx:fract_x>0.209</PDBx:fract_x>
 *  <PDBx:fract_y>0.739</PDBx:fract_y>
 *  <PDBx:fract_z>0.758</PDBx:fract_z>
 *  <PDBx:B_iso>40.8</PDBx:B_iso>
 *  </PDBx:phasing_MIR_der_site>
 *  <PDBx:phasing_MIR_der_site der_id="K3IrCl6" id="2">
 *  <PDBx:atom_type_symbol>Ir</PDBx:atom_type_symbol>
 *  <PDBx:occupancy>0.05</PDBx:occupancy>
 *  <PDBx:fract_x>0.279</PDBx:fract_x>
 *  <PDBx:fract_y>0.613</PDBx:fract_y>
 *  <PDBx:fract_z>0.752</PDBx:fract_z>
 *  <PDBx:B_iso>24.9</PDBx:B_iso>
 *  </PDBx:phasing_MIR_der_site>
 *  </PDBx:phasing_MIR_der_siteCategory>
 * </pre>
 */
public class Phasing_MIR_der_site 
{
		protected java.lang.Float B_iso;


	/**
	 *  Isotropic displacement parameter for this heavy-atom site in this
	 *  derivative.
	 */
	public java.lang.Float getB_iso() 
	{
		return B_iso;
	}
 
	public void setB_iso(java.lang.Float B_iso)
	{
		this.B_iso = B_iso;
	}

 	protected java.lang.Float B_iso_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute B_iso in category phasing_MIR_der_site.
	 */
	public java.lang.Float getB_iso_esd() 
	{
		return B_iso_esd;
	}
 
	public void setB_iso_esd(java.lang.Float B_iso_esd)
	{
		this.B_iso_esd = B_iso_esd;
	}

 	protected java.lang.Float Cartn_x;


	/**
	 *  The x coordinate of this heavy-atom position in this derivative
	 *  specified as orthogonal angstroms. The orthogonal Cartesian axes
	 *  are related to the cell axes as specified by the description
	 *  given in  attribute Cartn_transform_axes in category atom_sites.
	 */
	public java.lang.Float getCartn_x() 
	{
		return Cartn_x;
	}
 
	public void setCartn_x(java.lang.Float Cartn_x)
	{
		this.Cartn_x = Cartn_x;
	}

 	protected java.lang.Float Cartn_x_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute Cartn_x in category phasing_MIR_der_site.
	 */
	public java.lang.Float getCartn_x_esd() 
	{
		return Cartn_x_esd;
	}
 
	public void setCartn_x_esd(java.lang.Float Cartn_x_esd)
	{
		this.Cartn_x_esd = Cartn_x_esd;
	}

 	protected java.lang.Float Cartn_y;


	/**
	 *  The y coordinate of this heavy-atom position in this derivative
	 *  specified as orthogonal angstroms. The orthogonal Cartesian axes
	 *  are related to the cell axes as specified by the description
	 *  given in  attribute Cartn_transform_axes in category atom_sites.
	 */
	public java.lang.Float getCartn_y() 
	{
		return Cartn_y;
	}
 
	public void setCartn_y(java.lang.Float Cartn_y)
	{
		this.Cartn_y = Cartn_y;
	}

 	protected java.lang.Float Cartn_y_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute Cartn_y in category phasing_MIR_der_site.
	 */
	public java.lang.Float getCartn_y_esd() 
	{
		return Cartn_y_esd;
	}
 
	public void setCartn_y_esd(java.lang.Float Cartn_y_esd)
	{
		this.Cartn_y_esd = Cartn_y_esd;
	}

 	protected java.lang.Float Cartn_z;


	/**
	 *  The z coordinate of this heavy-atom position in this derivative
	 *  specified as orthogonal angstroms. The orthogonal Cartesian axes
	 *  are related to the cell axes as specified by the description
	 *  given in  attribute Cartn_transform_axes in category atom_sites.
	 */
	public java.lang.Float getCartn_z() 
	{
		return Cartn_z;
	}
 
	public void setCartn_z(java.lang.Float Cartn_z)
	{
		this.Cartn_z = Cartn_z;
	}

 	protected java.lang.Float Cartn_z_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute Cartn_z in category phasing_MIR_der_site.
	 */
	public java.lang.Float getCartn_z_esd() 
	{
		return Cartn_z_esd;
	}
 
	public void setCartn_z_esd(java.lang.Float Cartn_z_esd)
	{
		this.Cartn_z_esd = Cartn_z_esd;
	}

 	protected java.lang.String atom_type_symbol;


	/**
	 *  This data item is a pointer to  attribute symbol in category atom_type in the
	 *  ATOM_TYPE category.
	 *  
	 *  The scattering factors referenced via this data item should be
	 *  those used in the refinement of the heavy-atom data; in some
	 *  cases this is the scattering factor for the single heavy
	 *  atom, in other cases these are the scattering factors for an
	 *  atomic cluster.
	 */
	public java.lang.String getAtom_type_symbol() 
	{
		return atom_type_symbol;
	}
 
	public void setAtom_type_symbol(java.lang.String atom_type_symbol)
	{
		this.atom_type_symbol = atom_type_symbol;
	}

 	protected java.lang.String der_id;


	/**
	 *  This data item is a pointer to  attribute id in category phasing_MIR_der in the
	 *  PHASING_MIR_DER category.
	 */
	public java.lang.String getDer_id() 
	{
		return der_id;
	}
 
	public void setDer_id(java.lang.String der_id)
	{
		this.der_id = der_id;
	}

 	protected java.lang.String details;


	/**
	 *  A description of special aspects of the derivative site.
	 *  binds to His 117
	 *  minor site obtained from difference Fourier
	 *  same as site 2 in the K2HgI4 derivative
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.Float fract_x;


	/**
	 *  The x coordinate of this heavy-atom position in this derivative
	 *  specified as a fraction of  attribute length_a in category cell.
	 */
	public java.lang.Float getFract_x() 
	{
		return fract_x;
	}
 
	public void setFract_x(java.lang.Float fract_x)
	{
		this.fract_x = fract_x;
	}

 	protected java.lang.Float fract_x_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute fract_x in category phasing_MIR_der_site.
	 */
	public java.lang.Float getFract_x_esd() 
	{
		return fract_x_esd;
	}
 
	public void setFract_x_esd(java.lang.Float fract_x_esd)
	{
		this.fract_x_esd = fract_x_esd;
	}

 	protected java.lang.Float fract_y;


	/**
	 *  The y coordinate of this heavy-atom position in this derivative
	 *  specified as a fraction of  attribute length_b in category cell.
	 */
	public java.lang.Float getFract_y() 
	{
		return fract_y;
	}
 
	public void setFract_y(java.lang.Float fract_y)
	{
		this.fract_y = fract_y;
	}

 	protected java.lang.Float fract_y_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute fract_y in category phasing_MIR_der_site.
	 */
	public java.lang.Float getFract_y_esd() 
	{
		return fract_y_esd;
	}
 
	public void setFract_y_esd(java.lang.Float fract_y_esd)
	{
		this.fract_y_esd = fract_y_esd;
	}

 	protected java.lang.Float fract_z;


	/**
	 *  The z coordinate of this heavy-atom position in this derivative
	 *  specified as a fraction of  attribute length_c in category cell.
	 */
	public java.lang.Float getFract_z() 
	{
		return fract_z;
	}
 
	public void setFract_z(java.lang.Float fract_z)
	{
		this.fract_z = fract_z;
	}

 	protected java.lang.Float fract_z_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute fract_z in category phasing_MIR_der_site.
	 */
	public java.lang.Float getFract_z_esd() 
	{
		return fract_z_esd;
	}
 
	public void setFract_z_esd(java.lang.Float fract_z_esd)
	{
		this.fract_z_esd = fract_z_esd;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category phasing_MIR_der_site must uniquely identify each
	 *  site in each derivative in the PHASING_MIR_DER_SITE list.
	 *  
	 *  The atom identifiers need not be unique over all sites in all
	 *  derivatives; they need only be unique for each site in each
	 *  derivative.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Float occupancy;


	/**
	 *  The fraction of the atom type present at this heavy-atom site
	 *  in a given derivative. The sum of the occupancies of all the
	 *  atom types at this site may not significantly exceed 1.0 unless
	 *  it is a dummy site.
	 */
	public java.lang.Float getOccupancy() 
	{
		return occupancy;
	}
 
	public void setOccupancy(java.lang.Float occupancy)
	{
		this.occupancy = occupancy;
	}

 	protected java.lang.Float occupancy_anom;


	/**
	 *  The relative anomalous occupancy of the atom type
	 *  present at this heavy-atom site in a given derivative.
	 *  This atom occupancy will probably be on an arbitrary scale.
	 */
	public java.lang.Float getOccupancy_anom() 
	{
		return occupancy_anom;
	}
 
	public void setOccupancy_anom(java.lang.Float occupancy_anom)
	{
		this.occupancy_anom = occupancy_anom;
	}

 	protected java.lang.Float occupancy_anom_su;


	/**
	 *  The standard uncertainty (estimated standard deviation) of
	 *  attribute occupancy_anom in category phasing_MIR_der_site.
	 */
	public java.lang.Float getOccupancy_anom_su() 
	{
		return occupancy_anom_su;
	}
 
	public void setOccupancy_anom_su(java.lang.Float occupancy_anom_su)
	{
		this.occupancy_anom_su = occupancy_anom_su;
	}

 	protected java.lang.Float occupancy_iso;


	/**
	 *  The relative real isotropic occupancy of the atom type
	 *  present at this heavy-atom site in a given derivative.
	 *  This atom occupancy will probably be on an arbitrary scale.
	 */
	public java.lang.Float getOccupancy_iso() 
	{
		return occupancy_iso;
	}
 
	public void setOccupancy_iso(java.lang.Float occupancy_iso)
	{
		this.occupancy_iso = occupancy_iso;
	}

 	protected java.lang.Float occupancy_iso_su;


	/**
	 *  The standard uncertainty (estimated standard deviation) of
	 *  attribute occupancy_iso in category phasing_MIR_der_site.
	 */
	public java.lang.Float getOccupancy_iso_su() 
	{
		return occupancy_iso_su;
	}
 
	public void setOccupancy_iso_su(java.lang.Float occupancy_iso_su)
	{
		this.occupancy_iso_su = occupancy_iso_su;
	}

 }
