package org.pdb.beans;

/**
 *  Data items in the PHASING_AVERAGING category record details
 *  about the phasing of the structure where methods involving
 *  averaging of multiple observations of the molecule in the
 *  asymmetric unit are involved.
 *  
 * <pre>
 *  Example 1 - hypothetical example.
 *  <PDBx:phasing_averagingCategory>
 *  <PDBx:phasing_averaging entry_id="EXAMHYPO">
 *  <PDBx:method> Iterative threefold averaging alternating with phase
 *  extensions by 0.5 reciprocal lattice units per cycle.</PDBx:method>
 *  <PDBx:details> The position of the threefold axis was redetermined every
 *  five cycles.</PDBx:details>
 *  </PDBx:phasing_averaging>
 *  </PDBx:phasing_averagingCategory>
 * </pre>
 */
public class Phasing_averaging 
{
		protected java.lang.String details;


	/**
	 *  A description of special aspects of the averaging process.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String method;


	/**
	 *  A description of the phase-averaging phasing method used to
	 *  phase this structure.
	 *  
	 *  Note that this is not the computer program used, which is
	 *  described in the SOFTWARE category, but rather the method
	 *  itself.
	 *  
	 *  This data item should be used to describe significant
	 *  methodological options used within the phase-averaging program.
	 */
	public java.lang.String getMethod() 
	{
		return method;
	}
 
	public void setMethod(java.lang.String method)
	{
		this.method = method;
	}

 }
