package org.pdb.beans;

/**
 *  Data items in the PHASING_ISOMORPHOUS category record details
 *  about the phasing of the structure where a model isomorphous
 *  to the structure being phased was used to generate the initial
 *  phases.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 4PHV and laboratory records for the
 *  structure corresponding to PDB entry 4PHV.
 *  <PDBx:phasing_isomorphousCategory>
 *  <PDBx:phasing_isomorphous>
 *  <PDBx:parent>PDB entry 5HVP</PDBx:parent>
 *  <PDBx:details> The inhibitor and all solvent atoms were removed from the
 *  parent structure before beginning refinement. All static
 *  disorder present in the parent structure was also removed.</PDBx:details>
 *  </PDBx:phasing_isomorphous>
 *  </PDBx:phasing_isomorphousCategory>
 * </pre>
 */
public class Phasing_isomorphous 
{
		protected java.lang.String details;


	/**
	 *  A description of special aspects of the isomorphous phasing.
	 *  Residues 13-18 were eliminated from the
	 *  starting model as it was anticipated that
	 *  binding of the inhibitor would cause a
	 *  structural rearrangement in this part of the
	 *  structure.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String method;


	/**
	 *  A description of the isomorphous-phasing method used to
	 *  phase this structure.
	 *  
	 *  Note that this is not the computer program used, which is
	 *  described in the SOFTWARE category, but rather the method
	 *  itself.
	 *  
	 *  This data item should be used to describe significant
	 *  methodological options used within the isomorphous phasing
	 *  program.
	 *  Iterative threefold averaging alternating with
	 *  phase extension by 0.5 reciprocal lattice
	 *  units per cycle.
	 */
	public java.lang.String getMethod() 
	{
		return method;
	}
 
	public void setMethod(java.lang.String method)
	{
		this.method = method;
	}

 	protected java.lang.String parent;


	/**
	 *  Reference to the structure used to generate starting phases
	 *  if the structure referenced in this data block was phased
	 *  by virtue of being isomorphous to a known structure (e.g.
	 *  a mutant that crystallizes in the same space group as the
	 *  wild-type protein.)
	 */
	public java.lang.String getParent() 
	{
		return parent;
	}
 
	public void setParent(java.lang.String parent)
	{
		this.parent = parent;
	}

 }
